/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.split.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.PreInvoiceMain;
import com.xforceplus.phoenix.split.model.SplitPreInvoiceInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.impl.Bill2PreInvoiceService;
import com.xforceplus.seller.config.client.constant.InvoiceType;
import com.xforceplus.seller.invoice.client.PreInvoiceClient;
import com.xforceplus.seller.invoice.constants.enums.InvoiceHCFlag;
import com.xforceplus.seller.invoice.constants.enums.PreInvoiceLockFlag;
import com.xforceplus.seller.invoice.constants.enums.PreInvoiceStatus;
import com.xforceplus.seller.invoice.dto.PreInvoiceRelationWrapper;
import com.xforceplus.seller.invoice.dto.SplitRequest;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerPreInvoiceDaoExt;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerPreInvoiceItemDaoExt;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerPreSalesDetailDaoExt;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceItemEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreSalesDetailEntity;
import com.xforceplus.seller.invoice.service.pre.PreInvoiceService;
import com.xforceplus.seller.invoice.service.split.OriginBillPreInvoiceRelationService;
import com.xforceplus.seller.invoice.service.split.SplitCoreService;
import com.xforceplus.seller.invoice.service.tools.OssTools;
import com.xforceplus.seller.invoice.util.StringUtils;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.transaction.TransactionService;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.List;
import net.coderbee.mybatis.batch.BatchParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SplitCoreServiceImpl
implements SplitCoreService {
    private static final Logger logger = LoggerFactory.getLogger(SplitCoreServiceImpl.class);
    @Autowired
    private Bill2PreInvoiceService bill2PreInvoiceService;
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private OriginBillPreInvoiceRelationService originRelationService;
    @Autowired
    private InvSellerPreInvoiceDaoExt preInvoiceDaoExt;
    @Autowired
    private InvSellerPreSalesDetailDaoExt salesDetailDaoExt;
    @Autowired
    private InvSellerPreInvoiceItemDaoExt preInvoiceItemDaoExt;
    @Autowired
    private PreInvoiceClient preinvoiceClient;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private OssTools ossTools;
    @Value(value="${upload.count:10}")
    private int uploadCount;
    @Autowired
    private PreInvoiceService preInvoiceService;

    @Transactional
    public List<Long> split(SplitRequest splitRequest) {
        if (splitRequest == null) {
            logger.warn("\u62c6\u7968\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        BillInfo billInfo = splitRequest.getBillInfo();
        billInfo.setBatchNo(splitRequest.getBatchNo());
        SplitRule splitRule = splitRequest.getSplitRule();
        int billMergeType = splitRequest.getBillMergeType();
        long startTime = System.currentTimeMillis();
        if (billInfo.getBillItems().size() > this.uploadCount) {
            try {
                String ossUrl = this.ossTools.putFile(JsonUtils.writeObjectToJson((Object)splitRequest));
                logger.info("batchNo:{},taskId:{},\u8bf7\u6c42\u4e2d\u53f0\u62c6\u7968sdk\u6587\u4ef6\u670d\u52a1\u5668\u5165\u53c2\uff0c\u6587\u4ef6\u5730\u5740:{},\u5f00\u59cb\u65f6\u95f4:{}", new Object[]{splitRequest.getBatchNo(), splitRequest.getTaskId(), ossUrl, startTime});
            }
            catch (Exception e) {
                logger.error("\u62c6\u7968\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38:{}", (Throwable)e);
            }
        } else {
            logger.info("batchNo:{},taskId:{},\u8bf7\u6c42\u4e2d\u53f0\u62c6\u7968sdk\u63a5\u53e3\u5165\u53c2:{},\u5f00\u59cb\u65f6\u95f4:{}", new Object[]{splitRequest.getBatchNo(), splitRequest.getTaskId(), StringUtils.truncateString((String)JsonUtils.writeObjectToJson((Object)splitRequest), (int)1000), startTime});
        }
        List resultList = this.bill2PreInvoiceService.createPreInvoiceFromBill(billInfo, splitRule, "default");
        int size = 0;
        for (int i = 0; i < resultList.size(); ++i) {
            size += ((SplitPreInvoiceInfo)resultList.get(i)).getPreInvoiceItems().size();
        }
        if (size > this.uploadCount) {
            try {
                String ossUrl = this.ossTools.putFile(JsonUtils.writeObjectToJson((Object)splitRequest));
                long endTime = System.currentTimeMillis();
                logger.info("batchNo:{},taskId:{},\u4e2d\u53f0\u62c6\u7968sdk\u7ed3\u679c,\u6587\u4ef6\u5730\u5740:{},\u7ed3\u675f\u65f6\u95f4:{},cost - [{}]ms", new Object[]{splitRequest.getBatchNo(), splitRequest.getTaskId(), ossUrl, endTime, endTime - startTime});
            }
            catch (Exception e) {
                logger.error("\u62c6\u7968\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38:{}", (Throwable)e);
            }
        } else {
            long endTime = System.currentTimeMillis();
            logger.info("batchNo:{},taskId:{},\u4e2d\u53f0\u62c6\u7968sdk\u7ed3\u679c:{},\u7ed3\u675f\u65f6\u95f4:{},cost - [{}]ms", new Object[]{splitRequest.getBatchNo(), splitRequest.getTaskId(), StringUtils.truncateString((String)JsonUtils.writeObjectToJson((Object)resultList), (int)1000), endTime, endTime - startTime});
        }
        this.preInvoiceService.delPreInvoice(splitRequest.getBatchNo());
        return this.saveSplitPreInvoice(resultList, Integer.valueOf(billMergeType), splitRequest.getBatchNo());
    }

    @Transactional
    public List<Long> splitCallBack(List<SplitPreInvoiceInfo> result, Integer billMergeType, Long batchNo) {
        this.preInvoiceService.delPreInvoice(batchNo);
        return this.saveSplitPreInvoice(result, billMergeType, batchNo);
    }

    @Transactional
    public List<Long> saveSplitPreInvoice(List<SplitPreInvoiceInfo> resultList, Integer billMergeType, Long batchNo) {
        ArrayList preInvoiceList = Lists.newArrayList();
        ArrayList salesDetailList = Lists.newArrayList();
        ArrayList preInvoiceIdList = Lists.newArrayList();
        ArrayList preInvoiceItemList = Lists.newArrayList();
        LinkedHashSet needApplyRedNoIds = Sets.newLinkedHashSet();
        for (SplitPreInvoiceInfo preInvoiceInfo : resultList) {
            InvSellerPreInvoiceEntity preInvoice = this.buildPreInvoice(preInvoiceInfo);
            preInvoice.setMergeType(billMergeType);
            Long preInvoiceId = this.idGenerator.nextId();
            preInvoiceIdList.add(preInvoiceId);
            preInvoice.setId(preInvoiceId);
            preInvoiceList.add(preInvoice);
            PreInvoiceRelationWrapper wrapper = this.buildPreInvoiceItem(preInvoiceInfo, preInvoiceId);
            preInvoice.setSalesbillId(((InvSellerPreInvoiceItemEntity)wrapper.getItemList().get(0)).getSalesbillId());
            preInvoice.setSalesbillNo(((InvSellerPreInvoiceItemEntity)wrapper.getItemList().get(0)).getSalesbillNo());
            preInvoiceItemList.addAll(wrapper.getItemList());
            salesDetailList.addAll(wrapper.getSalesDetailList());
            if (!preInvoice.getInvoiceType().equals(InvoiceType.SPECIAL.value()) || preInvoice.getAmountWithTax().compareTo(BigDecimal.ZERO) >= 0) continue;
            needApplyRedNoIds.add(preInvoiceId);
        }
        if (!preInvoiceList.isEmpty()) {
            this.preInvoiceDaoExt.batchInsertPreInvoices(BatchParameter.wrap((List)preInvoiceList));
        }
        if (!preInvoiceItemList.isEmpty()) {
            this.preInvoiceItemDaoExt.batchInsertPreInvoiceItems(BatchParameter.wrap((List)preInvoiceItemList));
        }
        if (!salesDetailList.isEmpty()) {
            this.salesDetailDaoExt.batchInsertPreSalesDetails(BatchParameter.wrap((List)salesDetailList));
        }
        if (needApplyRedNoIds.size() > 0) {
            try {
                this.transactionService.afterTransactionCommit(() -> this.preinvoiceClient.applyRedNoByPreInvoice((List)Lists.newArrayList((Iterable)needApplyRedNoIds)));
            }
            catch (Exception e) {
                logger.error("\u7533\u8bf7\u7ea2\u5b57\u7684\u9884\u5236\u53d1\u7968\u6570\u636e\u5931\u8d25{}", (Object)JsonUtils.writeObjectToFastJson((Object)needApplyRedNoIds), (Object)e);
            }
        }
        this.originRelationService.buildRelation(batchNo, (List)salesDetailList, billMergeType.intValue());
        return preInvoiceIdList;
    }

    private InvSellerPreInvoiceEntity buildPreInvoice(SplitPreInvoiceInfo splitInfo) {
        InvSellerPreInvoiceEntity preInvoice = new InvSellerPreInvoiceEntity();
        PreInvoiceMain main = splitInfo.getPreInvoiceMain();
        BeanUtils.copyProperties((Object)main, (Object)preInvoice);
        preInvoice.setInvoiceCode("");
        preInvoice.setInvoiceNo("");
        preInvoice.setStatus(Integer.valueOf(PreInvoiceStatus.PENDING_INVOICE.value()));
        preInvoice.setLockFlag(Integer.valueOf(PreInvoiceLockFlag.NONE.value()));
        preInvoice.setRedFlag(InvoiceHCFlag.NORMAL.value());
        preInvoice.setCreateTime(Calendar.getInstance().getTime());
        preInvoice.setUpdateTime(Calendar.getInstance().getTime());
        preInvoice.setRuleId(Long.valueOf(splitInfo.getRuleId()));
        preInvoice.setOutBatchNo(main.getBatchNo());
        return preInvoice;
    }

    private PreInvoiceRelationWrapper buildPreInvoiceItem(SplitPreInvoiceInfo splitInfo, Long preInvoiceId) {
        PreInvoiceRelationWrapper wrapper = new PreInvoiceRelationWrapper();
        ArrayList itemList = Lists.newArrayList();
        ArrayList salesDetailList = Lists.newArrayList();
        List resultList = splitInfo.getPreInvoiceItems();
        resultList.forEach(item -> {
            InvSellerPreInvoiceItemEntity entity = new InvSellerPreInvoiceItemEntity();
            BeanUtils.copyProperties((Object)item, (Object)entity);
            entity.setPreInvoiceId(preInvoiceId);
            long preInvoiceItemId = this.idGenerator.nextId();
            entity.setId(Long.valueOf(preInvoiceItemId));
            entity.setPriceMethod("0");
            itemList.add(entity);
            InvSellerPreSalesDetailEntity billDetailEntity = new InvSellerPreSalesDetailEntity();
            BeanUtils.copyProperties((Object)item, (Object)billDetailEntity);
            billDetailEntity.setBatchNo(splitInfo.getPreInvoiceMain().getBatchNo());
            billDetailEntity.setPreInvoiceId(preInvoiceId);
            billDetailEntity.setPreInvoiceItemId(Long.valueOf(preInvoiceItemId));
            billDetailEntity.setBusinessBillType(splitInfo.getPreInvoiceMain().getBusinessBillType());
            billDetailEntity.setStatus("1");
            billDetailEntity.setCreateTime(Calendar.getInstance().getTime());
            billDetailEntity.setCreateUserId(Long.valueOf(0L));
            billDetailEntity.setUpdateUserId(Long.valueOf(0L));
            salesDetailList.add(billDetailEntity);
        });
        wrapper.setItemList((List)itemList);
        wrapper.setSalesDetailList((List)salesDetailList);
        return wrapper;
    }
}

