/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.tools;

import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.seller.invoice.util.ConstantUtils;
import com.xforceplus.seller.invoice.util.DateTools;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OssTools {
    private static final Logger logger = LoggerFactory.getLogger(OssTools.class);
    @Autowired
    private OssUtil ossUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putFile(String data) throws IOException {
        String filePath = ConstantUtils.SALES_SPLIT_REQUEST_DATA_PATH + "/" + DateTools.day() + "/" + UUID.randomUUID().toString();
        OutputStream out = null;
        File localFile = null;
        OutputStreamWriter writer = null;
        BufferedWriter bw = null;
        try {
            localFile = new File(filePath);
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();
            }
            out = new FileOutputStream(localFile);
            writer = new OutputStreamWriter(out);
            bw = new BufferedWriter(writer);
            bw.write(data);
            bw.flush();
            String key = this.ossUtil.uploadFile(filePath, Module.SELLER, true);
            FileUtils.deleteQuietly((File)localFile);
            String string = this.ossUtil.fileKeyToDownloadUrlViaPlatform(key);
            return string;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20oos/minol \u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (localFile != null) {
                localFile.delete();
            }
        }
    }
}

