/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.maintenace.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.maintenance.model.FiltersConditionRequest;
import com.xforceplus.maintenance.model.RequestField;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.invoice.client.model.MakeOutFailInfo;
import com.xforceplus.seller.invoice.client.model.QueryMakeOutFailResponse;
import com.xforceplus.seller.invoice.client.model.ResendTerminalInfo;
import com.xforceplus.seller.invoice.repository.dao.InvSellerMakeOutRequestDao;
import com.xforceplus.seller.invoice.repository.dao.InvSellerPreBillDetailDao;
import com.xforceplus.seller.invoice.repository.dao.InvSellerPreInvoiceDao;
import com.xforceplus.seller.invoice.repository.daoext.InvAutoMakeOutExtDao;
import com.xforceplus.seller.invoice.repository.model.InvSellerMakeOutRequestEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerMakeOutRequestExample;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreBillDetailEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreBillDetailExample;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceExample;
import com.xforceplus.seller.invoice.service.maintenace.AutoMakeOutFailService;
import com.xforceplus.seller.invoice.service.split.AutoInvoiceService;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatframework.utils.date.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AutoMakeOutFailServiceImpl
implements AutoMakeOutFailService {
    private static final Logger logger = LoggerFactory.getLogger(AutoMakeOutFailServiceImpl.class);
    @Autowired
    private InvSellerPreInvoiceDao preInvoiceDao;
    @Autowired
    private InvAutoMakeOutExtDao makeOutExtDao;
    @Autowired
    private InvSellerPreBillDetailDao preBillDetailDao;
    @Autowired
    private InvSellerMakeOutRequestDao makeOutRequestDao;
    @Autowired
    private AutoInvoiceService autoInvoiceService;
    @Autowired
    private IDGenerator idGenerator;

    public Response resendMakeOutRequest(List<Long> requestIdList) {
        logger.info("\u91cd\u65b0\u5f00\u5177\u53c2\u6570:{}", requestIdList);
        if (CollectionUtils.isEmpty(requestIdList)) {
            return Response.failed((String)"\u8bf7\u9009\u62e9\u9700\u8981\u91cd\u65b0\u5f00\u5177\u7684\u9884\u5236\u53d1\u7968");
        }
        InvSellerMakeOutRequestExample example = new InvSellerMakeOutRequestExample();
        example.createCriteria().andIdIn(requestIdList);
        List entityList = this.makeOutRequestDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        ArrayList manualMakeOutRequestList = new ArrayList();
        ArrayList autoMakeOutRequestList = new ArrayList();
        entityList.stream().forEach(entity -> {
            if (StringUtils.isNotBlank((CharSequence)entity.getTerminalUn())) {
                manualMakeOutRequestList.add(entity);
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getTerminalCode())) {
                autoMakeOutRequestList.add(entity);
            }
        });
        HashMap<ResendTerminalInfo, List> map = new HashMap<ResendTerminalInfo, List>();
        if (manualMakeOutRequestList.size() > 0) {
            Map<String, List<InvSellerMakeOutRequestEntity>> manualMap = manualMakeOutRequestList.stream().collect(Collectors.groupingBy(InvSellerMakeOutRequestEntity::getTerminalUn));
            manualMap.keySet().stream().forEach(ket -> {
                ResendTerminalInfo terminalInfo = new ResendTerminalInfo();
                terminalInfo.setTerminalUn(ket);
                map.put(terminalInfo, (List)manualMap.get(ket));
            });
        }
        if (autoMakeOutRequestList.size() > 0) {
            Map<String, List<InvSellerMakeOutRequestEntity>> autoMap = autoMakeOutRequestList.stream().collect(Collectors.groupingBy(InvSellerMakeOutRequestEntity::getTerminalCode));
            autoMap.keySet().stream().forEach(ket -> {
                ResendTerminalInfo terminalInfo = new ResendTerminalInfo();
                terminalInfo.setTerminalCode(ket);
                map.put(terminalInfo, (List)autoMap.get(ket));
            });
        }
        map.forEach((terminalInfo, requestList) -> {
            List preInvoiceIdList = requestList.stream().map(InvSellerMakeOutRequestEntity::getPreInvoiceId).collect(Collectors.toList());
            this.autoInvoiceService.resendMakeOutRequest(terminalInfo, preInvoiceIdList, Long.valueOf(this.idGenerator.nextId()));
        });
        return Response.ok((String)"\u91cd\u65b0\u53d1\u8d77\u6210\u529f");
    }

    public QueryMakeOutFailResponse queryFailList(FiltersConditionRequest request) {
        logger.info("\u67e5\u8be2\u8bf7\u6c42:{}", (Object)JsonUtils.writeObjectToJson((Object)request));
        QueryMakeOutFailResponse response = new QueryMakeOutFailResponse();
        if (request == null || CollectionUtils.isEmpty((Collection)request.getFilters())) {
            return response.fail("\u8bf7\u8f93\u5165\u67e5\u8be2\u6761\u4ef6");
        }
        HashMap map = Maps.newHashMap();
        boolean hasGroup = false;
        for (RequestField filter : request.getFilters()) {
            if ("sellerGroupId".equals(filter.getFieldName())) {
                hasGroup = true;
            }
            if ("createTime".equals(filter.getFieldName())) {
                map.put("startTime", filter.getValue().get(0));
                map.put("endTime", filter.getValue().get(1));
                continue;
            }
            map.put(filter.getFieldName(), filter.getValue().get(0));
        }
        if (!hasGroup) {
            logger.warn("\u9500\u65b9\u96c6\u56e2id\u5fc5\u586b");
            return response.fail("\u8bf7\u9009\u62e9\u9500\u65b9\u96c6\u56e2");
        }
        int pageNo = request.getPageNo() == null ? 1 : request.getPageNo();
        int pageSize = request.getPageSize() == null ? 20 : request.getPageSize();
        int total = 0;
        if (pageNo == 1) {
            total = this.makeOutExtDao.queryMakeOutFailPreInvoiceCount((Map)map);
        }
        map.put("start", (pageNo - 1) * pageSize);
        map.put("pageSize", pageSize);
        if (total == 0) {
            return response.ok((List)Lists.newArrayList(), total, "\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        logger.info("\u603b\u67e5\u8be2\u6761\u6570: {}", (Object)total);
        List entityList = this.makeOutExtDao.queryMakeOutFailPreInvoiceList((Map)map);
        List preInvoiceIds = entityList.stream().map(entity -> entity.getId()).collect(Collectors.toList());
        InvSellerMakeOutRequestExample example = new InvSellerMakeOutRequestExample();
        InvSellerMakeOutRequestExample.Criteria criteria = example.createCriteria();
        criteria.andPreInvoiceIdIn(preInvoiceIds);
        criteria.andProcessStatusIn(Arrays.asList(0, 2));
        List makeOutRequestEntities = this.makeOutRequestDao.selectByExample(example);
        ArrayList list = Lists.newArrayList();
        if (makeOutRequestEntities != null && makeOutRequestEntities.size() > 0) {
            Map<Long, List<InvSellerMakeOutRequestEntity>> makeOutListMap = makeOutRequestEntities.stream().collect(Collectors.groupingBy(InvSellerMakeOutRequestEntity::getPreInvoiceId));
            entityList.stream().forEach(entity -> {
                List makeOutList = (List)makeOutListMap.get(entity.getId());
                if (makeOutList != null && makeOutList.size() > 0) {
                    InvSellerMakeOutRequestEntity lastRequest = (InvSellerMakeOutRequestEntity)makeOutList.stream().sorted(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList()).get(0);
                    MakeOutFailInfo makeOutFailInfo = new MakeOutFailInfo();
                    BeanUtils.copyProperties((Object)lastRequest, (Object)makeOutFailInfo);
                    BeanUtils.copyProperties((Object)entity, (Object)makeOutFailInfo);
                    makeOutFailInfo.setId(lastRequest.getId());
                    makeOutFailInfo.setPreInvoiceId(lastRequest.getPreInvoiceId());
                    makeOutFailInfo.setUpdateTime(DateUtil.formatDateToString((Date)lastRequest.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    list.add(makeOutFailInfo);
                }
            });
        }
        logger.info("\u67e5\u8be2\u7ed3\u679c: {}", (Object)JsonUtils.writeObjectToJson((Object)list));
        return response.ok((List)list, total, "\u67e5\u8be2\u6210\u529f");
    }

    private Map<Long, String> querySalesBillNoByPreInvoiceId(List<Long> preInvoiceIdList) {
        InvSellerPreBillDetailExample example = new InvSellerPreBillDetailExample();
        example.createCriteria().andPreInvoiceIdIn(preInvoiceIdList);
        List entityList = this.preBillDetailDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Maps.newHashMap();
        }
        Map<Long, List<InvSellerPreBillDetailEntity>> tmpMap = entityList.stream().collect(Collectors.groupingBy(InvSellerPreBillDetailEntity::getPreInvoiceId));
        HashMap resultMap = Maps.newHashMap();
        tmpMap.forEach((preInvoiceId, list) -> {
            List salesBillNoList = list.stream().map(InvSellerPreBillDetailEntity::getSalesbillNo).distinct().collect(Collectors.toList());
            resultMap.put(preInvoiceId, String.join((CharSequence)",", salesBillNoList));
        });
        return resultMap;
    }

    private List<InvSellerPreInvoiceEntity> queryPreInvoiceByIdList(List<Long> preInvoiceIdList) {
        if (CollectionUtils.isEmpty(preInvoiceIdList)) {
            return Lists.newArrayList();
        }
        InvSellerPreInvoiceExample example = new InvSellerPreInvoiceExample();
        example.createCriteria().andIdIn(preInvoiceIdList);
        return this.preInvoiceDao.selectByExample(example);
    }

    private List<Long> queryPreInvoiceIdBySalesBillNo(String salesBillNo) {
        if (StringUtils.isBlank((CharSequence)salesBillNo)) {
            return Lists.newArrayList();
        }
        InvSellerPreBillDetailExample example = new InvSellerPreBillDetailExample();
        example.createCriteria().andSalesbillNoEqualTo(salesBillNo);
        List entityList = this.preBillDetailDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Lists.newArrayList();
        }
        return entityList.stream().map(InvSellerPreBillDetailEntity::getPreInvoiceId).collect(Collectors.toList());
    }
}

