/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.split.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.bill.client.model.BillSplitLogRequest;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.phoenix.split.model.BaseResponse;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.CreatePreInvoiceParam;
import com.xforceplus.phoenix.split.model.SplitResponse;
import com.xforceplus.phoenix.sqs.SQSSender;
import com.xforceplus.seller.invoice.client.BillInvoiceApiClient;
import com.xforceplus.seller.invoice.client.BillSplitLogClient;
import com.xforceplus.seller.invoice.client.model.SplitCallbackData;
import com.xforceplus.seller.invoice.client.model.SplitCallbackRequest;
import com.xforceplus.seller.invoice.client.model.SplitCallbackResponse;
import com.xforceplus.seller.invoice.client.model.SplitCallbackResult;
import com.xforceplus.seller.invoice.common.util.RestTemplateTools;
import com.xforceplus.seller.invoice.common.util.ZipUtil;
import com.xforceplus.seller.invoice.constants.enums.SplitResult;
import com.xforceplus.seller.invoice.constants.enums.SplitType;
import com.xforceplus.seller.invoice.dto.SplitRequest;
import com.xforceplus.seller.invoice.repository.dao.InvSellerSplitRequestLogDao;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerSplitRequestExtDao;
import com.xforceplus.seller.invoice.repository.model.InvSellerSplitRequestLogEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerSplitRequestLogExample;
import com.xforceplus.seller.invoice.service.pre.PreInvoiceService;
import com.xforceplus.seller.invoice.service.split.AutoInvoiceService;
import com.xforceplus.seller.invoice.service.split.SplitCoreService;
import com.xforceplus.seller.invoice.service.split.SplitService;
import com.xforceplus.seller.invoice.service.tools.OssTools;
import com.xforceplus.seller.invoice.util.HttpUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SplitServiceImpl
implements SplitService {
    private static final Logger logger = LoggerFactory.getLogger(SplitServiceImpl.class);
    @Autowired
    private InvSellerSplitRequestLogDao splitRequestLogDao;
    @Autowired
    private SplitCoreService splitCoreService;
    @Autowired
    private OssUtil ossUtil;
    @Autowired
    private AutoInvoiceService autoInvoiceService;
    @Autowired
    private BillInvoiceApiClient billInvoiceApiClient;
    @Autowired
    private BillSplitLogClient splitLogClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RestTemplateTools restTemplateTools;
    @Autowired
    private InvSellerSplitRequestExtDao invSellerSplitRequestExtDao;
    @Value(value="${split.service.url}")
    private String splitServiceUrl;
    @Value(value="${territorial.or.platform:1}")
    private int territorialOrPlatform;
    @Value(value="${split_routing_key:zt_tycpx}")
    private String routingKey;
    @Value(value="${upload.count:50}")
    private int uploadCount;
    @Value(value="${cooperation.preinvoice.flag:false}")
    private boolean cooperationPreinvoiceFlag;
    @Autowired
    private OssTools ossTools;
    @Autowired
    private PreInvoiceService preInvoiceService;

    public void split(SplitRequest request) {
        if (this.territorialOrPlatform == 1) {
            this.platformSplit(request);
        } else {
            this.territorialSplit(request);
        }
    }

    private void platformSplit(SplitRequest request) {
        String message;
        boolean success = true;
        long taskId = request.getTaskId();
        String txId = "";
        try {
            Response response = this.sendSplit(request);
            if (response.getCode().intValue() == Response.Fail.intValue()) {
                this.billInvoiceApiClient.afterCancelPreviewPreInvoice((List)Lists.newArrayList((Object[])new Long[]{request.getBatchNo()}));
                success = false;
                message = response.getMessage();
            } else {
                txId = response.getResult().toString();
                message = "\u8bf7\u6c42\u6210\u529f";
            }
        }
        catch (Exception e) {
            logger.error("http taskId:{}\u62c6\u7968\u5931\u8d25", (Throwable)e);
            message = e.getMessage();
            success = false;
            this.billInvoiceApiClient.afterCancelPreviewPreInvoice((List)Lists.newArrayList((Object[])new Long[]{request.getBatchNo()}));
        }
        this.updateSplitResult(Long.valueOf(taskId), success ? SplitResult.PROCESSING : SplitResult.FAIL, message, txId, Integer.valueOf(request.getBillMergeType()));
    }

    private void territorialSplit(SplitRequest request) {
        String message;
        boolean success;
        List preInvoiceIdList = Lists.newArrayList();
        long taskId = request.getTaskId();
        try {
            preInvoiceIdList = this.splitCoreService.split(request);
            success = !CollectionUtils.isEmpty((Collection)preInvoiceIdList);
            String string = message = success ? "\u62c6\u7968\u6210\u529f" : "\u62c6\u7968\u5931\u8d25";
            if (success && this.cooperationPreinvoiceFlag) {
                SQSSender.sendStrMsg((String)"phoenix-pre-invoice-cooperation-request", (String)JsonUtils.writeObjectToJson((Object)preInvoiceIdList), new HashMap(), (boolean)true);
            }
        }
        catch (Exception e) {
            logger.error("taskId:{}\u62c6\u7968\u5931\u8d25", (Throwable)e);
            message = e.getMessage();
            success = false;
            this.billInvoiceApiClient.afterCancelPreviewPreInvoice((List)Lists.newArrayList((Object[])new Long[]{request.getBatchNo()}));
        }
        this.updateSplitResult(Long.valueOf(taskId), success ? SplitResult.SUCCESS : SplitResult.FAIL, message, null, Integer.valueOf(request.getBillMergeType()));
        if (success) {
            try {
                this.autoInvoice(request.getTerminalCode(), preInvoiceIdList, taskId);
            }
            catch (Exception e) {
                logger.error("autoInvoice Exception:{}", (Throwable)e);
            }
        }
        this.splitResult(request.getSplitType(), taskId, success, request.getBatchNo().longValue(), message);
    }

    private void autoInvoice(String terminalCode, List<Long> preInvoiceIdList, long taskId) {
        if (StringUtils.isNotBlank((CharSequence)terminalCode) && !"null".equals(terminalCode)) {
            this.autoInvoiceService.autoInvoice(terminalCode, preInvoiceIdList, Long.valueOf(taskId));
        }
    }

    private void splitResult(int splitType, long taskId, boolean success, long batchNo, String message) {
        if (splitType == SplitType.AUTO.value()) {
            BillSplitLogRequest resultRequest = new BillSplitLogRequest();
            logger.info("taskId:{}\u81ea\u52a8\u62c6\u7968\uff0c\u901a\u77e5\u5355\u636e\u62c6\u7968\u7ed3\u679c:{}", (Object)taskId, (Object)success);
            resultRequest.setBatchNo(batchNo);
            resultRequest.setResult(success ? 1 : 0);
            resultRequest.setSplitType(splitType);
            resultRequest.setMessage(message);
            this.splitLogClient.splitResult(resultRequest);
        }
    }

    public void asyncSplit(String ossKey, Long taskId) {
        logger.info("\u5f02\u6b65\u62c6\u7968\u6570\u636e");
        String fileName = this.localFile(taskId);
        this.ossUtil.downLoadToLocalPathInternal(ossKey, fileName);
        try (FileInputStream fis = new FileInputStream(fileName);
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            byte[] buf = new byte[4096];
            while ((len = fis.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            byte[] data = bos.toByteArray();
            SplitRequest request = (SplitRequest)ZipUtil.uncompress((byte[])data, SplitRequest.class);
            this.split(request);
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u62c6\u7968\u5931\u8d25,taskId:{}", (Throwable)e);
        }
    }

    private Response sendSplit(SplitRequest request) {
        long tenantId = 200L;
        long appId = 200L;
        CreatePreInvoiceParam createPreInvoiceParam = this.buildCreatePreInvoiceParam(request);
        String msg = JsonUtils.writeObjectToJson((Object)createPreInvoiceParam);
        if (createPreInvoiceParam.getBillInfo().getBillItems().size() > this.uploadCount) {
            try {
                String ossUrl = this.ossTools.putFile(msg);
                logger.info("\u8bf7\u6c42\u62c6\u7968http\u6587\u4ef6\u670d\u52a1\u5668\u5165\u53c2\uff0c\u6587\u4ef6\u5730\u5740:{},taskId:{},batchNo:{}", new Object[]{ossUrl, request.getTaskId(), request.getBatchNo()});
            }
            catch (Exception e) {
                logger.error("\u62c6\u7968\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38:{}", (Throwable)e);
            }
        } else {
            logger.info("\u8bf7\u6c42\u62c6\u7968http\u63a5\u53e3\u5165\u53c2:{},taskId:{},batchNo:{}", new Object[]{msg, request.getTaskId(), request.getBatchNo()});
        }
        BaseResponse baseResponse = this.sendSplitMsg(msg, tenantId, appId);
        if (!"BSCTZZ0001".equals(baseResponse.getCode())) {
            return Response.failed((String)baseResponse.getMessage());
        }
        String txId = (String)baseResponse.getResult();
        return Response.ok((String)"\u8bf7\u6c42\u6210\u529f", (Object)txId);
    }

    private BaseResponse<String> sendSplitMsg(String msg, long tenantId, long appId) {
        BaseResponse baseResponse = new BaseResponse();
        try {
            String tmpSplitServiceUrl = this.splitServiceUrl;
            tmpSplitServiceUrl = tmpSplitServiceUrl.replace("{tenantId}", Long.toString(tenantId));
            tmpSplitServiceUrl = tmpSplitServiceUrl + "?appId=" + appId;
            Map headers = this.restTemplateTools.getHeader();
            String reslut = HttpUtils.doPostJson((String)tmpSplitServiceUrl, (String)msg, (Map)headers);
            logger.info("\u8bf7\u6c42\u62c6\u7968http post\u63a5\u53e3\u7ed3\u679c:{}", (Object)reslut);
            if (StringUtils.isEmpty((CharSequence)reslut)) {
                baseResponse.setCode("BSCTZZ0500");
                baseResponse.setMessage("\u7cfb\u7edf\u5185\u90e8\u9519\u8bef\uff0c\u8054\u7cfb\u4e2d\u53f0\u89e3\u51b3");
                return baseResponse;
            }
            baseResponse = (BaseResponse)JsonUtils.writeJsonToObject((String)reslut, BaseResponse.class);
        }
        catch (Exception e) {
            logger.error("sendSplitMsg Exception-{}", (Throwable)e);
            baseResponse.setCode("BSCTZZ0500");
            baseResponse.setMessage("\u8bf7\u6c42\u5931\u8d25");
        }
        return baseResponse;
    }

    public CreatePreInvoiceParam buildCreatePreInvoiceParam(SplitRequest request) {
        CreatePreInvoiceParam greatePreInvoice = new CreatePreInvoiceParam();
        BillInfo billInfo = request.getBillInfo();
        billInfo.setBatchNo(request.getBatchNo());
        greatePreInvoice.setBillInfo(billInfo);
        greatePreInvoice.setRule(request.getSplitRule());
        greatePreInvoice.setRoutingKey(this.routingKey);
        return greatePreInvoice;
    }

    private void updateSplitResult(Long taskId, SplitResult result, String message, String txId, Integer mergeType) {
        InvSellerSplitRequestLogEntity entity = new InvSellerSplitRequestLogEntity();
        entity.setId(taskId);
        entity.setResult(Integer.valueOf(result.value()));
        entity.setRemark(StringUtils.substring((String)message, (int)0, (int)255));
        if (mergeType != null) {
            entity.setMergeType(mergeType);
        }
        if (StringUtils.isNotBlank((CharSequence)txId)) {
            entity.setTxid(txId);
        }
        if (result.value() != SplitResult.PROCESSING.value()) {
            entity.setToken(entity.getId().toString());
        }
        this.splitRequestLogDao.updateByPrimaryKeySelective(entity);
    }

    private int updateCallBackSplitResult(Long id, SplitResult result, String message) {
        InvSellerSplitRequestLogEntity entity = new InvSellerSplitRequestLogEntity();
        entity.setResult(Integer.valueOf(result.value()));
        entity.setRemark(StringUtils.substring((String)message, (int)0, (int)255));
        entity.setToken(id.toString());
        InvSellerSplitRequestLogExample example = new InvSellerSplitRequestLogExample();
        example.createCriteria().andIdEqualTo(id).andResultIn((List)Lists.newArrayList((Object[])new Integer[]{SplitResult.FAIL.value(), SplitResult.PROCESSING.value()}));
        return this.splitRequestLogDao.updateByExampleSelective(entity, example);
    }

    private void updateByTxid(String message, String txId, Integer result) {
        InvSellerSplitRequestLogEntity entity = new InvSellerSplitRequestLogEntity();
        entity.setTxid(txId);
        entity.setRemark(StringUtils.substring((String)message, (int)0, (int)255));
        entity.setResult(result);
        entity.setToken(txId);
        this.invSellerSplitRequestExtDao.updateByTxid(entity);
    }

    private InvSellerSplitRequestLogEntity queryInvSellerSplitRequestLogEntity(String txId) {
        InvSellerSplitRequestLogExample example = new InvSellerSplitRequestLogExample();
        InvSellerSplitRequestLogExample.Criteria criteria = example.createCriteria().andTxidEqualTo(txId);
        return this.splitRequestLogDao.selectOneByExample(example);
    }

    private static String today() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(Calendar.getInstance().getTime());
    }

    private String localFile(Long taskId) {
        String fileName = CommonTools.format((String)"output/{}/{}", (Object[])new Object[]{SplitServiceImpl.today(), taskId});
        File localFile = new File(fileName);
        if (!localFile.getParentFile().exists()) {
            localFile.getParentFile().mkdirs();
        }
        return fileName;
    }

    public SplitCallbackResponse dealWithSplitCallback(SplitCallbackRequest splitCallbackRequest) {
        SplitCallbackResponse response = new SplitCallbackResponse();
        String txId = null;
        try {
            long start = System.currentTimeMillis();
            logger.info("\u4e1a\u52a1\u4e2d\u53f0\u5f02\u6b65\u56de\u8c03\u62c6\u7968\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToJson((Object)splitCallbackRequest));
            if ("CPTNCB0001".equals(splitCallbackRequest.getCode())) {
                SplitCallbackResult result = splitCallbackRequest.getResult();
                SplitCallbackData callbackData = (SplitCallbackData)JsonUtils.writeJsonToObject((String)result.getData(), SplitCallbackData.class);
                txId = callbackData.getTxId();
                SplitResponse splitResponse = this.getSplitResult(callbackData.getOssUrl(), callbackData.isCompress());
                logger.info("\u4e2d\u53f0\u62c6\u7968\u7ed3\u679c\u89e3\u6790 txId: {}, splitResponse: {}", (Object)txId, (Object)JsonUtils.writeObjectToJson((Object)splitResponse));
                if (splitResponse == null) {
                    this.updateByTxid("\u62c6\u7968\u5f02\u6b65\u56de\u8c03\u4e0b\u8f7d\u62c6\u7968\u7ed3\u679c\u5931\u8d25", callbackData.getTxId(), Integer.valueOf(SplitResult.FAIL.value()));
                    return response.code("CPTNCB1001").message("\u4e0b\u8f7d\u62c6\u7968\u7ed3\u679c\u5931\u8d25");
                }
                if (!"BSCTZZ0001".equals(splitResponse.getCode())) {
                    InvSellerSplitRequestLogEntity invSellerSplitRequestLogEntity = this.queryInvSellerSplitRequestLogEntity(callbackData.getTxId());
                    this.updateByTxid(splitResponse.getMessage(), callbackData.getTxId(), Integer.valueOf(SplitResult.FAIL.value()));
                    this.billInvoiceApiClient.afterCancelPreviewPreInvoice((List)Lists.newArrayList((Object[])new Long[]{invSellerSplitRequestLogEntity.getBatchNo()}));
                    return response.code("CPTNCB0001").message("\u62c6\u7968\u5931\u8d25");
                }
                this.dealWithSplitResult(txId, splitResponse);
            }
            logger.info("\u9884\u5236\u4e2d\u53f0\u5f02\u6b65\u56de\u8c03\u62c6\u7968\u7ed3\u679c\u5904\u7406\u4e2d\uff1a cost - [{}]ms", (Object)(System.currentTimeMillis() - start));
            return response.code(splitCallbackRequest.getCode()).message("\u7ed3\u679c\u5904\u7406\u7ed3\u675f");
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u4e1a\u52a1\u4e2d\u53f0\u62c6\u7968\u7ed3\u679c\u8fd4\u56de\u5f02\u5e38:{}", (Throwable)e);
            if (StringUtils.isNotBlank(txId)) {
                logger.error("\u5f02\u5e38\u6d41\u6c34\u53f7\u4e3a:{}", txId);
                this.updateByTxid(e.getMessage(), txId, Integer.valueOf(SplitResult.FAIL.value()));
            }
            logger.error("\u5904\u7406\u4e1a\u52a1\u4e2d\u53f0\u62c6\u7968\u7ed3\u679c\u8fd4\u56de\u5f02\u5e38:{}", (Throwable)e);
            return response.code("CPTNCB1001").message("\u7ed3\u679c\u5904\u7406\u5931\u8d25");
        }
    }

    public void dealWithSplitResult(String txId, SplitResponse splitResponse) {
        InvSellerSplitRequestLogEntity invSellerSplitRequestLogEntity = this.queryInvSellerSplitRequestLogEntity(txId);
        Integer billMergeType = invSellerSplitRequestLogEntity.getMergeType();
        Long batchNo = invSellerSplitRequestLogEntity.getBatchNo();
        Long taskId = invSellerSplitRequestLogEntity.getId();
        String terminalCode = invSellerSplitRequestLogEntity.getTerminalCode();
        Integer reslut = invSellerSplitRequestLogEntity.getResult();
        if (reslut != null && reslut.intValue() == SplitResult.SUCCESS.value()) {
            logger.info("txId:{},batchNo:{},\u62c6\u7968\u5f02\u6b65\u56de\u8c03\u62c6\u7968,\u5df2\u5904\u7406\u6210\u529f\uff0c\u65e0\u9700\u5728\u5904\u7406", (Object)txId, (Object)batchNo);
            return;
        }
        String message = "\u62c6\u7968\u6210\u529f";
        int res = this.updateCallBackSplitResult(taskId, SplitResult.SUCCESS, message);
        if (res == 0) {
            logger.info("txId:{},batchNo:{},\u62c6\u7968\u5f02\u6b65\u56de\u8c03\u62c6\u7968,\u5df2\u5904\u7406\u6216\u8005\u6b63\u5728\u5904\u7406\uff0c\u65e0\u9700\u5728\u5904\u7406", (Object)txId, (Object)batchNo);
            return;
        }
        List preInvoiceIdList = this.splitCoreService.splitCallBack(splitResponse.getResult(), billMergeType, batchNo);
        if (this.cooperationPreinvoiceFlag) {
            SQSSender.sendStrMsg((String)"phoenix-pre-invoice-cooperation-request", (String)JsonUtils.writeObjectToJson((Object)preInvoiceIdList), new HashMap(), (boolean)true);
        }
        try {
            this.autoInvoice(terminalCode, preInvoiceIdList, taskId.longValue());
        }
        catch (Exception e) {
            logger.error("dealWithSplitCallback Exception:{}", (Throwable)e);
        }
        this.splitResult(billMergeType.intValue(), taskId.longValue(), true, batchNo.longValue(), message);
    }

    private SplitResponse getSplitResult(String ossUrl, boolean compress) {
        try {
            URI uri = new URI(ossUrl);
            ResponseEntity response = this.restTemplate.getForEntity(uri, byte[].class);
            byte[] splitData = (byte[])response.getBody();
            if (compress) {
                Inflater decompresser = new Inflater();
                decompresser.setInput(splitData);
                byte[] data = new byte[1024];
                int length = 0;
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream(splitData.length);){
                    while (!decompresser.finished()) {
                        length = decompresser.inflate(data);
                        bos.write(data, 0, length);
                    }
                    decompresser.end();
                    splitData = bos.toByteArray();
                }
            }
            return (SplitResponse)JSON.parseObject((byte[])splitData, SplitResponse.class, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7ossUrl\u4e0b\u8f7d\u62c6\u7968\u7ed3\u679c\u5f02\u5e38:{}", (Throwable)e);
            return null;
        }
    }
}

