/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.util;

import com.xforceplus.seller.invoice.util.RamUsageEstimator;
import com.xforceplus.seller.invoice.util.RamUsageTester;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RamUsageTester {
    public static long sizeOf(Object obj, Accumulator accumulator) {
        return RamUsageTester.measureObjectSize((Object)obj, (Accumulator)accumulator);
    }

    public static long sizeOf(Object obj) {
        return RamUsageTester.sizeOf((Object)obj, (Accumulator)new Accumulator());
    }

    public static String humanSizeOf(Object object) {
        return RamUsageEstimator.humanReadableUnits((long)RamUsageTester.sizeOf((Object)object));
    }

    private static long measureObjectSize(Object root, Accumulator accumulator) {
        IdentityHashSet seen = new IdentityHashSet();
        IdentityHashMap classCache = new IdentityHashMap();
        ArrayList<Object> stack = new ArrayList<Object>();
        stack.add(root);
        long totalSize = 0L;
        while (!stack.isEmpty()) {
            Object ob = stack.remove(stack.size() - 1);
            if (ob == null || seen.contains(ob)) continue;
            seen.add(ob);
            Class<?> obClazz = ob.getClass();
            assert (obClazz != null) : "jvm bug detected (Object.getClass() == null). please report this to your vendor";
            if (obClazz.isArray()) {
                long shallowSize = RamUsageEstimator.shallowSizeOf(ob);
                int len = Array.getLength(ob);
                Class<?> componentClazz = obClazz.getComponentType();
                1 values = componentClazz.isPrimitive() ? Collections.emptyList() : new /* Unavailable Anonymous Inner Class!! */;
                totalSize += accumulator.accumulateArray(ob, shallowSize, (List)values, stack);
                continue;
            }
            try {
                ClassCache cachedInfo = (ClassCache)classCache.get(obClazz);
                if (cachedInfo == null) {
                    cachedInfo = RamUsageTester.createCacheEntry(obClazz);
                    classCache.put(obClazz, cachedInfo);
                }
                HashMap<Field, Object> fieldValues = new HashMap<Field, Object>();
                for (Field f : cachedInfo.referenceFields) {
                    fieldValues.put(f, f.get(ob));
                }
                totalSize += accumulator.accumulateObject(ob, cachedInfo.alignedShallowInstanceSize, fieldValues, stack);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Reflective field access failed?", e);
            }
        }
        seen.clear();
        stack.clear();
        classCache.clear();
        return totalSize;
    }

    private static ClassCache createCacheEntry(Class<?> clazz) {
        long shallowInstanceSize = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        ArrayList<Field> referenceFields = new ArrayList<Field>(32);
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            Field[] fields;
            if (c == Class.class) continue;
            for (Field f : fields = c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                shallowInstanceSize = RamUsageEstimator.adjustForField((long)shallowInstanceSize, (Field)f);
                if (f.getType().isPrimitive()) continue;
                f.setAccessible(true);
                referenceFields.add(f);
            }
        }
        ClassCache cachedInfo = new ClassCache(RamUsageEstimator.alignObjectSize((long)shallowInstanceSize), referenceFields.toArray(new Field[referenceFields.size()]));
        return cachedInfo;
    }
}

