/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.config;

import com.xforceplus.xplatframework.utils.JsonUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.data.elasticsearch.ElasticsearchProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableConfigurationProperties(value={ElasticsearchProperties.class})
public class ElasticSearchConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ElasticsearchProperties properties;
    @Value(value="${elasticsearch.xPackSecurity:true}")
    private String xPackSecurity;

    public ElasticSearchConfig(ElasticsearchProperties properties) {
        this.properties = properties;
    }

    @Bean
    public TransportClient transportClient() {
        return new PreBuiltXPackTransportClient(this.settings(), new Class[0]).addTransportAddresses(this.addresses());
    }

    private Settings settings() {
        Settings.Builder builder = Settings.builder();
        this.logger.info("settings xPackSecurity: {}", (Object)JsonUtils.writeObjectToFastJson((Object)this.xPackSecurity));
        builder.put("cluster.name", this.properties.getClusterName());
        this.properties.getProperties().forEach((a, b) -> {
            if (null != this.xPackSecurity && !"false".equalsIgnoreCase(this.xPackSecurity) || !"xpack.security.user".equalsIgnoreCase((String)a)) {
                builder.put(a, b);
            }
        });
        this.logger.info("settings builder map: {}", (Object)JsonUtils.writeObjectToFastJson((Object)builder.internalMap()));
        return builder.build();
    }

    private TransportAddress[] addresses() {
        String clusterNodesStr = this.properties.getClusterNodes();
        Assert.hasText((String)clusterNodesStr, (String)"Cluster nodes source must not be null or empty!");
        String[] nodes = StringUtils.delimitedListToStringArray((String)clusterNodesStr, (String)",");
        return (TransportAddress[])Arrays.stream(nodes).map(node -> {
            String[] segments = StringUtils.delimitedListToStringArray((String)node, (String)":");
            Assert.isTrue((segments.length == 2 ? 1 : 0) != 0, () -> String.format("Invalid cluster node %s in %s! Must be in the format host:port!", node, clusterNodesStr));
            String host = segments[0].trim();
            String port = segments[1].trim();
            Assert.hasText((String)host, () -> String.format("No host name given cluster node %s!", node));
            Assert.hasText((String)port, () -> String.format("No port given in cluster node %s!", node));
            return new InetSocketTransportAddress(ElasticSearchConfig.toInetAddress((String)host), Integer.valueOf(port).intValue());
        }).toArray(TransportAddress[]::new);
    }

    private static InetAddress toInetAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

