/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.split.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.bill.client.enums.BillMergeType;
import com.xforceplus.phoenix.bill.client.model.AutoBillRelationResponse;
import com.xforceplus.phoenix.bill.client.model.AutoBillRelationship;
import com.xforceplus.phoenix.bill.client.model.BillAutoItemResponse;
import com.xforceplus.phoenix.bill.client.model.BillSourceRelationship;
import com.xforceplus.phoenix.bill.client.model.BillSourceResponse;
import com.xforceplus.phoenix.bill.client.model.OrdAutoSalesbillItemWithOriginVO;
import com.xforceplus.phoenix.bill.client.model.OrdSalesbillItemVO;
import com.xforceplus.seller.invoice.client.BillInvoiceApiClient;
import com.xforceplus.seller.invoice.common.util.BigDecimalUtil;
import com.xforceplus.seller.invoice.dto.AmountDto;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerPreBillDetailExtDao;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerPreOriginalSalesDetailDaoExt;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerPreSalesDetailDaoExt;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreBillDetailEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreOriginalSalesDetailEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreSalesDetailEntity;
import com.xforceplus.seller.invoice.service.split.OriginBillPreInvoiceRelationService;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.coderbee.mybatis.batch.BatchParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OriginBillPreInvoiceRelationServiceImpl
implements OriginBillPreInvoiceRelationService {
    private static final Logger logger = LoggerFactory.getLogger(OriginBillPreInvoiceRelationServiceImpl.class);
    @Autowired
    private BillInvoiceApiClient billInvoiceApiClient;
    @Autowired
    private InvSellerPreOriginalSalesDetailDaoExt originalSalesDetailDaoExt;
    @Autowired
    private InvSellerPreBillDetailExtDao preBillDetailExtDao;
    @Autowired
    private InvSellerPreSalesDetailDaoExt salesDetailDaoExt;

    public void buildRelation(Long batchNo, List<InvSellerPreSalesDetailEntity> salesDetailList, int billMergeType) {
        if (batchNo == null || CollectionUtils.isEmpty(salesDetailList)) {
            logger.warn("\u6279\u6b21:{}\u65e0\u7ed3\u7b97\u5355\u5173\u7cfb", (Object)batchNo);
            return;
        }
        BillSourceResponse sourceResponse = this.billInvoiceApiClient.queryBillSource(batchNo);
        if (sourceResponse == null || !Response.OK.equals(sourceResponse.getCode())) {
            logger.error("\u67e5\u8be2\u539f\u5355\u4fe1\u606f\uff0c\u6279\u6b21\u53f7:{},\u54cd\u5e94{}", (Object)batchNo, (Object)JsonUtils.writeObjectToFastJson((Object)sourceResponse));
            throw new RuntimeException("\u5efa\u7acb\u660e\u7ec6\u5173\u7cfb\u5931\u8d25, \u67e5\u8be2\u539f\u5355\u5173\u7cfb\u5931\u8d25");
        }
        AutoBillRelationResponse response = null;
        if (!(billMergeType == BillMergeType.NONE.value() || (response = this.billInvoiceApiClient.queryAutoBillRelationship(batchNo)) != null && Response.OK.equals(response.getCode()))) {
            logger.error("\u67e5\u8be2\u81ea\u52a8\u5408\u5e76\u4fe1\u606f\uff0c\u6279\u6b21\u53f7:{},\u54cd\u5e94{}", (Object)batchNo, (Object)response);
            throw new RuntimeException("\u5efa\u7acb\u660e\u7ec6\u5173\u7cfb\u5931\u8d25\uff0c\u67e5\u8be2\u5408\u5e76\u62c6\u5206\u5355\u636e\u5931\u8d25");
        }
        if (billMergeType == BillMergeType.AUTO_COMBINE.value()) {
            this.buildCombineRelation(response.getRelationshipList(), salesDetailList);
        } else if (billMergeType == BillMergeType.AUTO_MERGE.value()) {
            logger.debug("response.getRelationshipList,{}" + response.getRelationshipList());
            salesDetailList = this.buildAndSaveMergeRelation(response.getRelationshipList(), salesDetailList);
            logger.info("\u81ea\u52a8\u5408\u5e76salesDetailList\uff1a{}", (Object)salesDetailList);
        }
        this.preBillDetailExtDao.batchInsertPreBillDetail(BatchParameter.wrap(salesDetailList));
        this.buildAndSaveOriginBillItemRelation(sourceResponse.getResult(), salesDetailList, batchNo);
    }

    private void buildCombineRelation(List<AutoBillRelationship> relationshipList, List<InvSellerPreSalesDetailEntity> detailList) {
        HashMap relationshipMap = Maps.newHashMap();
        relationshipList.forEach(relation -> relationshipMap.put(relation.getAutoSalesBillItemId(), relation));
        detailList.forEach(detail -> {
            AutoBillRelationship relationship = (AutoBillRelationship)relationshipMap.get(detail.getSalesbillItemId());
            detail.setSalesbillId(relationship.getOriginSalesBillId());
            detail.setSalesbillItemId(relationship.getOriginSalesBillItemId());
            detail.setSalesbillNo(relationship.getSalesBillNo());
        });
    }

    private List<InvSellerPreSalesDetailEntity> buildAndSaveMergeRelation(List<AutoBillRelationship> relationshipList, List<InvSellerPreSalesDetailEntity> detailList) {
        ArrayList<InvSellerPreSalesDetailEntity> newDetailList = new ArrayList<InvSellerPreSalesDetailEntity>();
        ArrayList preSalesDetailDetailList = new ArrayList();
        detailList.forEach(detail -> {
            for (AutoBillRelationship relation : relationshipList) {
                if (!relation.getAutoSalesBillItemId().equals(detail.getSalesbillItemId())) continue;
                InvSellerPreSalesDetailEntity entity = new InvSellerPreSalesDetailEntity();
                entity.setBatchNo(detail.getBatchNo());
                entity.setPreInvoiceId(detail.getPreInvoiceId());
                entity.setPreInvoiceItemId(detail.getPreInvoiceItemId());
                entity.setSalesbillId(relation.getOriginSalesBillId());
                entity.setSalesbillItemId(relation.getOriginSalesBillItemId());
                entity.setAmountWithoutTax(relation.getSourceAmountWithoutTax());
                entity.setTaxAmount(relation.getSourceTaxAmount());
                entity.setAmountWithTax(relation.getSourceAmountWithTax());
                entity.setStatus(detail.getStatus());
                entity.setOutterDiscountWithTax(relation.getOutterDiscountWithTax());
                entity.setOutterDiscountWithoutTax(relation.getOutterDiscountWithoutTax());
                entity.setOutterDiscountTax(relation.getOutterDiscountTax());
                entity.setInnerDiscountWithTax(relation.getInnerDiscountWithTax());
                entity.setInnerDiscountWithoutTax(relation.getInnerDiscountWithoutTax());
                entity.setInnerDiscountTax(relation.getInnerDiscountTax());
                entity.setOutterPrepayAmountWithTax(relation.getOutterPrepayAmountWithTax());
                entity.setOutterPrepayAmountWithoutTax(relation.getOutterPrepayAmountWithoutTax());
                entity.setOutterPrepayAmountTax(relation.getOutterPrepayAmountTax());
                entity.setInnerPrepayAmountWithTax(relation.getInnerPrepayAmountWithTax());
                entity.setInnerPrepayAmountWithoutTax(relation.getInnerPrepayAmountWithoutTax());
                entity.setInnerPrepayAmountTax(relation.getInnerPrepayAmountTax());
                entity.setDeduction(relation.getDeductions());
                entity.setCreateTime(new Date());
                entity.setCreateUserId(detail.getCreateUserId());
                entity.setUpdateTime(new Date());
                entity.setUpdateUserId(detail.getUpdateUserId());
                entity.setSalesbillNo(detail.getSalesbillNo());
                entity.setBusinessBillType(detail.getBusinessBillType());
                newDetailList.add(entity);
            }
        });
        if (!CollectionUtils.isEmpty(detailList)) {
            InvSellerPreSalesDetailEntity first = detailList.get(0);
            Long batchNo = first.getBatchNo();
            BillAutoItemResponse response = this.billInvoiceApiClient.queryAutoBillItem(batchNo);
            logger.info("zero response:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response));
            if (null != response && !CollectionUtils.isEmpty((Collection)response.getResult())) {
                List result = response.getResult();
                result.forEach(a -> {
                    InvSellerPreSalesDetailEntity entity = this.getZeroInvSellerPreSalesDetailEntity(first, batchNo, a);
                    preSalesDetailDetailList.add(entity);
                    List originalItemVoList = a.getOriginalItemVoList();
                    if (!CollectionUtils.isEmpty((Collection)originalItemVoList)) {
                        originalItemVoList.forEach(b -> {
                            InvSellerPreSalesDetailEntity entity2 = this.getInvNonZeroSellerPreSalesDetailEntity(first, batchNo, b);
                            newDetailList.add(entity2);
                        });
                    }
                });
            }
        }
        this.salesDetailDaoExt.batchInsertPreSalesDetails(BatchParameter.wrap(preSalesDetailDetailList));
        logger.info("newDetailList:{}", newDetailList);
        return newDetailList;
    }

    private InvSellerPreSalesDetailEntity getInvNonZeroSellerPreSalesDetailEntity(InvSellerPreSalesDetailEntity first, Long batchNo, OrdSalesbillItemVO b) {
        InvSellerPreSalesDetailEntity entity2 = new InvSellerPreSalesDetailEntity();
        entity2.setBatchNo(batchNo);
        entity2.setPreInvoiceId(first.getPreInvoiceId());
        entity2.setPreInvoiceItemId(first.getPreInvoiceItemId());
        entity2.setSalesbillId(b.getSalesbillId());
        entity2.setSalesbillItemId(b.getSalesbillItemId());
        entity2.setAmountWithoutTax(b.getAmountWithoutTax());
        entity2.setTaxAmount(b.getTaxAmount());
        entity2.setAmountWithTax(b.getAmountWithTax());
        entity2.setStatus(first.getStatus());
        entity2.setOutterDiscountWithTax(b.getOutterDiscountWithTax());
        entity2.setOutterDiscountWithoutTax(b.getOutterDiscountWithoutTax());
        entity2.setOutterDiscountTax(b.getOutterDiscountTax());
        entity2.setInnerDiscountWithTax(b.getInnerDiscountWithTax());
        entity2.setInnerDiscountWithoutTax(b.getInnerDiscountWithoutTax());
        entity2.setInnerDiscountTax(b.getInnerDiscountTax());
        entity2.setOutterPrepayAmountWithTax(b.getOutterPrepayAmountWithTax());
        entity2.setOutterPrepayAmountWithoutTax(b.getOutterPrepayAmountWithoutTax());
        entity2.setOutterPrepayAmountTax(b.getOutterPrepayAmountTax());
        entity2.setInnerPrepayAmountWithTax(b.getInnerPrepayAmountWithTax());
        entity2.setInnerPrepayAmountWithoutTax(b.getInnerPrepayAmountWithoutTax());
        entity2.setInnerPrepayAmountTax(b.getInnerPrepayAmountTax());
        entity2.setDeduction(b.getDeductions());
        entity2.setCreateTime(new Date());
        entity2.setCreateUserId(first.getCreateUserId());
        entity2.setUpdateTime(new Date());
        entity2.setUpdateUserId(first.getUpdateUserId());
        entity2.setSalesbillNo(first.getSalesbillNo());
        entity2.setBusinessBillType(first.getBusinessBillType());
        return entity2;
    }

    private InvSellerPreSalesDetailEntity getZeroInvSellerPreSalesDetailEntity(InvSellerPreSalesDetailEntity first, Long batchNo, OrdAutoSalesbillItemWithOriginVO a) {
        InvSellerPreSalesDetailEntity entity = new InvSellerPreSalesDetailEntity();
        entity.setBatchNo(batchNo);
        entity.setPreInvoiceId(first.getPreInvoiceId());
        entity.setPreInvoiceItemId(first.getPreInvoiceItemId());
        entity.setSalesbillId(a.getSalesbillId());
        entity.setSalesbillItemId(a.getSalesbillItemId());
        entity.setAmountWithoutTax(a.getAmountWithoutTax());
        entity.setTaxAmount(a.getTaxAmount());
        entity.setAmountWithTax(a.getAmountWithTax());
        entity.setStatus(first.getStatus());
        entity.setOutterDiscountWithTax(a.getOutterDiscountWithTax());
        entity.setOutterDiscountWithoutTax(a.getOutterDiscountWithoutTax());
        entity.setOutterDiscountTax(a.getOutterDiscountTax());
        entity.setInnerDiscountWithTax(a.getInnerDiscountWithTax());
        entity.setInnerDiscountWithoutTax(a.getInnerDiscountWithoutTax());
        entity.setInnerDiscountTax(a.getInnerDiscountTax());
        entity.setOutterPrepayAmountWithTax(a.getOutterPrepayAmountWithTax());
        entity.setOutterPrepayAmountWithoutTax(a.getOutterPrepayAmountWithoutTax());
        entity.setOutterPrepayAmountTax(a.getOutterPrepayAmountTax());
        entity.setInnerPrepayAmountWithTax(a.getInnerPrepayAmountWithTax());
        entity.setInnerPrepayAmountWithoutTax(a.getInnerPrepayAmountWithoutTax());
        entity.setInnerPrepayAmountTax(a.getInnerPrepayAmountTax());
        entity.setDeduction(a.getDeductions());
        entity.setCreateTime(new Date());
        entity.setCreateUserId(first.getCreateUserId());
        entity.setUpdateTime(new Date());
        entity.setUpdateUserId(first.getUpdateUserId());
        entity.setSalesbillNo(first.getSalesbillNo());
        entity.setBusinessBillType(first.getBusinessBillType());
        return entity;
    }

    private void buildAndSaveOriginBillItemRelation(List<BillSourceRelationship> sourceList, List<InvSellerPreSalesDetailEntity> detailList, Long batchNo) {
        Map<Long, List<BillSourceRelationship>> sourceMap = sourceList.stream().collect(Collectors.groupingBy(BillSourceRelationship::getTargetSalesbillItemId));
        ArrayList resultList = Lists.newArrayList();
        for (InvSellerPreSalesDetailEntity d : detailList) {
            List<BillSourceRelationship> source = sourceMap.get(d.getSalesbillItemId());
            logger.info("\u539f\u5355\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtils.writeObjectToFastJson(source));
            InvSellerPreBillDetailEntity detail = new InvSellerPreBillDetailEntity();
            BeanUtils.copyProperties((Object)d, (Object)detail);
            if (CollectionUtils.isEmpty(source)) continue;
            for (BillSourceRelationship billSource : source) {
                InvSellerPreOriginalSalesDetailEntity entity = new InvSellerPreOriginalSalesDetailEntity();
                entity.setBatchNo(batchNo);
                entity.setPreInvoiceId(detail.getPreInvoiceId());
                entity.setPreInvoiceItemId(detail.getPreInvoiceItemId());
                entity.setOriginalSalesbillId(billSource.getSourceSalesbillId());
                entity.setOriginalSalesbillItemId(billSource.getSourceSalesbillItemId());
                entity.setOriginalSalesbillNo(billSource.getSalesbillNo());
                entity.setOriginalSalesbillItemNo(billSource.getSourceSalesbillItemNo());
                entity.setCreateUserId(Long.valueOf(0L));
                if (billSource.getSourceAmountWithTax().multiply(detail.getAmountWithoutTax()).compareTo(BigDecimal.ZERO) > 0) {
                    this.calcAmount(billSource, detail, entity);
                } else {
                    entity.setAmountWithoutTax(BigDecimal.ZERO);
                    entity.setAmountWithTax(BigDecimal.ZERO);
                    entity.setTaxAmount(BigDecimal.ZERO);
                }
                this.calcOtherAmount(billSource, detail, entity);
                resultList.add(entity);
            }
        }
        logger.info("\u4fdd\u5b58\u539f\u5355\u660e\u7ec6\u548c\u9884\u5236\u53d1\u7968\u660e\u7ec6\u7684\u5173\u7cfb\uff1a{}", (Object)JsonUtils.writeObjectToJson((Object)BatchParameter.wrap((List)resultList)));
        this.originalSalesDetailDaoExt.batchInsertPreOriginalSalesDetails(BatchParameter.wrap((List)resultList));
    }

    private void calcAmount(BillSourceRelationship source, InvSellerPreBillDetailEntity detail, InvSellerPreOriginalSalesDetailEntity entity) {
        AmountDto dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getSourceAmountWithoutTax(), (BigDecimal)detail.getAmountWithoutTax());
        source.setSourceAmountWithoutTax(dto.getSourceAmount());
        detail.setAmountWithoutTax(dto.getItemAmount());
        entity.setAmountWithoutTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getSourceAmountWithTax(), (BigDecimal)detail.getAmountWithTax());
        source.setSourceAmountWithTax(dto.getSourceAmount());
        detail.setAmountWithTax(dto.getItemAmount());
        entity.setAmountWithTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getSourceTaxAmount(), (BigDecimal)detail.getTaxAmount());
        source.setSourceTaxAmount(dto.getSourceAmount());
        detail.setTaxAmount(dto.getItemAmount());
        entity.setTaxAmount(dto.getEntityAmount());
    }

    private void calcOtherAmount(BillSourceRelationship source, InvSellerPreBillDetailEntity detail, InvSellerPreOriginalSalesDetailEntity entity) {
        AmountDto dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getInnerDiscountTax(), (BigDecimal)detail.getInnerDiscountTax());
        source.setInnerDiscountTax(dto.getSourceAmount());
        detail.setInnerDiscountTax(dto.getItemAmount());
        entity.setInnerDiscountTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getInnerDiscountWithoutTax(), (BigDecimal)detail.getInnerDiscountWithoutTax());
        source.setInnerDiscountWithoutTax(dto.getSourceAmount());
        detail.setInnerDiscountWithoutTax(dto.getItemAmount());
        entity.setInnerDiscountWithoutTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getInnerDiscountWithTax(), (BigDecimal)detail.getInnerDiscountWithTax());
        source.setInnerDiscountWithTax(dto.getSourceAmount());
        detail.setInnerDiscountWithTax(dto.getItemAmount());
        entity.setInnerDiscountWithTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getInnerPrepayAmountTax(), (BigDecimal)detail.getInnerPrepayAmountTax());
        source.setInnerPrepayAmountTax(dto.getSourceAmount());
        detail.setInnerPrepayAmountTax(dto.getItemAmount());
        entity.setInnerPrepayAmountTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getInnerPrepayAmountWithoutTax(), (BigDecimal)detail.getInnerPrepayAmountWithoutTax());
        source.setInnerPrepayAmountWithoutTax(dto.getSourceAmount());
        detail.setInnerPrepayAmountWithoutTax(dto.getItemAmount());
        entity.setInnerPrepayAmountWithoutTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getInnerPrepayAmountWithTax(), (BigDecimal)detail.getInnerPrepayAmountWithTax());
        source.setInnerPrepayAmountWithTax(dto.getSourceAmount());
        detail.setInnerPrepayAmountWithTax(dto.getItemAmount());
        entity.setInnerPrepayAmountWithTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getOutterDiscountTax(), (BigDecimal)detail.getOutterDiscountTax());
        source.setOutterDiscountTax(dto.getSourceAmount());
        detail.setOutterDiscountTax(dto.getItemAmount());
        entity.setOutterDiscountTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getOutterDiscountWithoutTax(), (BigDecimal)detail.getOutterDiscountWithoutTax());
        source.setOutterDiscountWithoutTax(dto.getSourceAmount());
        detail.setOutterDiscountWithoutTax(dto.getItemAmount());
        entity.setOutterDiscountWithoutTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getOutterDiscountWithTax(), (BigDecimal)detail.getOutterDiscountWithTax());
        source.setOutterDiscountWithTax(dto.getSourceAmount());
        detail.setOutterDiscountWithTax(dto.getItemAmount());
        entity.setOutterDiscountWithTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getOutterPrepayAmountTax(), (BigDecimal)detail.getOutterPrepayAmountTax());
        source.setOutterPrepayAmountTax(dto.getSourceAmount());
        detail.setOutterPrepayAmountTax(dto.getItemAmount());
        entity.setOutterPrepayAmountTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getOutterPrepayAmountWithoutTax(), (BigDecimal)detail.getOutterPrepayAmountWithoutTax());
        source.setOutterPrepayAmountWithoutTax(dto.getSourceAmount());
        detail.setOutterPrepayAmountWithoutTax(dto.getItemAmount());
        entity.setOutterPrepayAmountWithoutTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getOutterPrepayAmountWithTax(), (BigDecimal)detail.getOutterPrepayAmountWithTax());
        source.setOutterPrepayAmountWithTax(dto.getSourceAmount());
        detail.setOutterPrepayAmountWithTax(dto.getItemAmount());
        entity.setOutterPrepayAmountWithTax(dto.getEntityAmount());
        dto = BigDecimalUtil.compareAndSubtract((BigDecimal)source.getDeductions(), (BigDecimal)detail.getDeduction());
        source.setDeductions(dto.getSourceAmount());
        detail.setDeduction(dto.getItemAmount());
        entity.setDeduction(dto.getEntityAmount());
    }
}

