/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.maintenace.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.maintenance.model.GroupFiltersConditionRequest;
import com.xforceplus.maintenance.model.RequestField;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.invoice.client.model.MakeOutFailInfo;
import com.xforceplus.seller.invoice.client.model.QueryMakeOutFailResponse;
import com.xforceplus.seller.invoice.client.model.ResendTerminalInfo;
import com.xforceplus.seller.invoice.repository.dao.InvSellerMakeOutRequestDao;
import com.xforceplus.seller.invoice.repository.dao.InvSellerPreBillDetailDao;
import com.xforceplus.seller.invoice.repository.dao.InvSellerPreInvoiceDao;
import com.xforceplus.seller.invoice.repository.daoext.InvAutoMakeOutExtDao;
import com.xforceplus.seller.invoice.repository.model.InvSellerMakeOutRequestEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerMakeOutRequestExample;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreBillDetailEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreBillDetailExample;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceExample;
import com.xforceplus.seller.invoice.service.maintenace.AutoMakeOutFailService;
import com.xforceplus.seller.invoice.service.split.AutoInvoiceService;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatframework.utils.date.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AutoMakeOutFailServiceImpl
implements AutoMakeOutFailService {
    private static final Logger logger = LoggerFactory.getLogger(AutoMakeOutFailServiceImpl.class);
    @Autowired
    private InvSellerPreInvoiceDao preInvoiceDao;
    @Autowired
    private InvAutoMakeOutExtDao makeOutExtDao;
    @Autowired
    private InvSellerPreBillDetailDao preBillDetailDao;
    @Autowired
    private InvSellerMakeOutRequestDao makeOutRequestDao;
    @Autowired
    private AutoInvoiceService autoInvoiceService;
    @Autowired
    private IDGenerator idGenerator;

    public Response resendMakeOutRequest(List<Long> requestIdList) {
        logger.info("\u91cd\u65b0\u5f00\u5177\u53c2\u6570:{}", requestIdList);
        if (CollectionUtils.isEmpty(requestIdList)) {
            return Response.failed((String)"\u8bf7\u9009\u62e9\u9700\u8981\u91cd\u65b0\u5f00\u5177\u7684\u9884\u5236\u53d1\u7968");
        }
        InvSellerMakeOutRequestExample example = new InvSellerMakeOutRequestExample();
        example.createCriteria().andIdIn(requestIdList);
        List entityList = this.makeOutRequestDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        ArrayList manualMakeOutRequestList = new ArrayList();
        ArrayList autoMakeOutRequestList = new ArrayList();
        entityList.stream().forEach(entity -> {
            if (StringUtils.isNotBlank((CharSequence)entity.getTerminalUn())) {
                manualMakeOutRequestList.add(entity);
            } else if (StringUtils.isNotBlank((CharSequence)entity.getTerminalCode())) {
                autoMakeOutRequestList.add(entity);
            }
        });
        HashMap<ResendTerminalInfo, List> map = new HashMap<ResendTerminalInfo, List>();
        if (manualMakeOutRequestList.size() > 0) {
            Map<String, List<InvSellerMakeOutRequestEntity>> manualMap = manualMakeOutRequestList.stream().collect(Collectors.groupingBy(InvSellerMakeOutRequestEntity::getTerminalUn));
            manualMap.keySet().stream().forEach(ket -> {
                ResendTerminalInfo terminalInfo = new ResendTerminalInfo();
                terminalInfo.setTerminalUn(ket);
                map.put(terminalInfo, (List)manualMap.get(ket));
            });
        }
        if (autoMakeOutRequestList.size() > 0) {
            Map<String, List<InvSellerMakeOutRequestEntity>> autoMap = autoMakeOutRequestList.stream().collect(Collectors.groupingBy(InvSellerMakeOutRequestEntity::getTerminalCode));
            autoMap.keySet().stream().forEach(ket -> {
                ResendTerminalInfo terminalInfo = new ResendTerminalInfo();
                terminalInfo.setTerminalCode(ket);
                map.put(terminalInfo, (List)autoMap.get(ket));
            });
        }
        map.forEach((terminalInfo, requestList) -> {
            List preInvoiceIdList = requestList.stream().map(InvSellerMakeOutRequestEntity::getPreInvoiceId).collect(Collectors.toList());
            this.autoInvoiceService.resendMakeOutRequest(terminalInfo, preInvoiceIdList, Long.valueOf(this.idGenerator.nextId()));
        });
        return Response.ok((String)"\u91cd\u65b0\u53d1\u8d77\u6210\u529f");
    }

    public QueryMakeOutFailResponse queryFailList(GroupFiltersConditionRequest request) {
        logger.info("\u67e5\u8be2\u8bf7\u6c42:{}", (Object)JsonUtils.writeObjectToJson((Object)request));
        QueryMakeOutFailResponse response = new QueryMakeOutFailResponse();
        if (request == null || CollectionUtils.isEmpty((Collection)request.getFilters())) {
            return response.fail("\u8bf7\u8f93\u5165\u67e5\u8be2\u6761\u4ef6");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList paramsMapList = new ArrayList();
        for (List filters : request.getFilters()) {
            HashMap paramsMap = new HashMap();
            boolean hasGroup = false;
            for (RequestField filter : filters) {
                if ("sellerGroupId".equals(filter.getFieldName())) {
                    hasGroup = true;
                }
                paramsMap.put(filter.getFieldName(), filter.getValue().get(0));
            }
            if (!hasGroup) continue;
            paramsMapList.add(paramsMap);
        }
        List createTime = request.getCreateTime();
        if (createTime != null && createTime.size() == 2) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar startTime = Calendar.getInstance();
            startTime.setTime(new Date((Long)createTime.get(0)));
            startTime.set(11, 0);
            startTime.set(12, 0);
            startTime.set(13, 0);
            startTime.set(14, 0);
            Calendar endTime = Calendar.getInstance();
            endTime.setTime(new Date((Long)createTime.get(1)));
            endTime.set(11, 0);
            endTime.set(12, 0);
            endTime.set(13, 0);
            endTime.set(14, 0);
            map.put("startTime", startTime.getTime());
            map.put("endTime", this.addDays(endTime.getTime(), 1));
        }
        if (paramsMapList.size() <= 0) {
            return response.fail("\u83b7\u53d6\u67e5\u8be2\u6761\u4ef6\u5931\u8d25");
        }
        map.put("list", paramsMapList);
        logger.debug("\u67e5\u8be2\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToJson(map));
        int pageNo = request.getPageNo() == null ? 1 : request.getPageNo();
        int pageSize = request.getPageSize() == null ? 20 : request.getPageSize();
        int total = this.makeOutExtDao.queryMakeOutFailPreInvoiceCount(map);
        map.put("start", (pageNo - 1) * pageSize);
        map.put("pageSize", pageSize);
        if (total == 0) {
            return response.ok((List)Lists.newArrayList(), total, "\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        logger.debug("\u603b\u67e5\u8be2\u6761\u6570: {}", (Object)total);
        List entityList = this.makeOutExtDao.queryMakeOutFailPreInvoiceList(map);
        List preInvoiceIds = entityList.stream().map(entity -> entity.getId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(preInvoiceIds)) {
            return response.ok((List)Lists.newArrayList(), total, "");
        }
        InvSellerMakeOutRequestExample example = new InvSellerMakeOutRequestExample();
        InvSellerMakeOutRequestExample.Criteria criteria = example.createCriteria();
        criteria.andPreInvoiceIdIn(preInvoiceIds);
        criteria.andProcessStatusIn(Arrays.asList(0, 2));
        List makeOutRequestEntities = this.makeOutRequestDao.selectByExample(example);
        ArrayList list = Lists.newArrayList();
        if (makeOutRequestEntities != null && makeOutRequestEntities.size() > 0) {
            Map<Long, List<InvSellerMakeOutRequestEntity>> makeOutListMap = makeOutRequestEntities.stream().collect(Collectors.groupingBy(InvSellerMakeOutRequestEntity::getPreInvoiceId));
            entityList.stream().forEach(entity -> {
                List makeOutList = (List)makeOutListMap.get(entity.getId());
                if (makeOutList != null && makeOutList.size() > 0) {
                    InvSellerMakeOutRequestEntity lastRequest = (InvSellerMakeOutRequestEntity)makeOutList.stream().sorted(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList()).get(0);
                    MakeOutFailInfo makeOutFailInfo = new MakeOutFailInfo();
                    BeanUtils.copyProperties((Object)lastRequest, (Object)makeOutFailInfo);
                    BeanUtils.copyProperties((Object)entity, (Object)makeOutFailInfo);
                    makeOutFailInfo.setId(lastRequest.getId());
                    makeOutFailInfo.setPreInvoiceId(lastRequest.getPreInvoiceId());
                    makeOutFailInfo.setUpdateTime(DateUtil.formatDateToString((Date)lastRequest.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    list.add(makeOutFailInfo);
                }
            });
        }
        logger.debug("\u67e5\u8be2\u7ed3\u679c: {}", (Object)JsonUtils.writeObjectToJson((Object)list));
        return response.ok((List)list, total, "\u67e5\u8be2\u6210\u529f");
    }

    private Map<Long, String> querySalesBillNoByPreInvoiceId(List<Long> preInvoiceIdList) {
        InvSellerPreBillDetailExample example = new InvSellerPreBillDetailExample();
        example.createCriteria().andPreInvoiceIdIn(preInvoiceIdList);
        List entityList = this.preBillDetailDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Maps.newHashMap();
        }
        Map<Long, List<InvSellerPreBillDetailEntity>> tmpMap = entityList.stream().collect(Collectors.groupingBy(InvSellerPreBillDetailEntity::getPreInvoiceId));
        HashMap resultMap = Maps.newHashMap();
        tmpMap.forEach((preInvoiceId, list) -> {
            List salesBillNoList = list.stream().map(InvSellerPreBillDetailEntity::getSalesbillNo).distinct().collect(Collectors.toList());
            resultMap.put(preInvoiceId, String.join((CharSequence)",", salesBillNoList));
        });
        return resultMap;
    }

    private List<InvSellerPreInvoiceEntity> queryPreInvoiceByIdList(List<Long> preInvoiceIdList) {
        if (CollectionUtils.isEmpty(preInvoiceIdList)) {
            return Lists.newArrayList();
        }
        InvSellerPreInvoiceExample example = new InvSellerPreInvoiceExample();
        example.createCriteria().andIdIn(preInvoiceIdList);
        return this.preInvoiceDao.selectByExample(example);
    }

    private List<Long> queryPreInvoiceIdBySalesBillNo(String salesBillNo) {
        if (StringUtils.isBlank((CharSequence)salesBillNo)) {
            return Lists.newArrayList();
        }
        InvSellerPreBillDetailExample example = new InvSellerPreBillDetailExample();
        example.createCriteria().andSalesbillNoEqualTo(salesBillNo);
        List entityList = this.preBillDetailDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Lists.newArrayList();
        }
        return entityList.stream().map(InvSellerPreBillDetailEntity::getPreInvoiceId).collect(Collectors.toList());
    }

    public Date addDays(Date date, int days) {
        if (date == null) {
            if (logger.isInfoEnabled()) {
                logger.info("\u4f20\u5165\u7684date\u5bf9\u8c61\u4e3a\u7a7a,\u8fd4\u56denull");
            }
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }
}

