/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.split.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.model.ZeroTaxOption;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SplitPreInvoiceResponse;
import com.xforceplus.seller.invoice.common.util.ZipUtil;
import com.xforceplus.seller.invoice.constants.enums.SalesListFlag;
import com.xforceplus.seller.invoice.constants.enums.SplitResult;
import com.xforceplus.seller.invoice.constants.enums.SplitType;
import com.xforceplus.seller.invoice.dto.SplitRequest;
import com.xforceplus.seller.invoice.repository.dao.InvSellerSplitRequestLogDao;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerSplitRequestExtDao;
import com.xforceplus.seller.invoice.repository.model.InvSellerSplitRequestLogEntity;
import com.xforceplus.seller.invoice.service.split.PreSplitService;
import com.xforceplus.seller.invoice.service.split.SplitService;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatmq.rabbit.RabbitmqService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.coderbee.mybatis.batch.BatchParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PreSplitServiceImpl
implements PreSplitService {
    private static final Logger logger = LoggerFactory.getLogger(PreSplitServiceImpl.class);
    @Autowired
    private SplitService splitService;
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private InvSellerSplitRequestExtDao splitRequestExtDao;
    @Autowired
    private InvSellerSplitRequestLogDao splitRequestDao;
    @Autowired
    private InvSellerSplitRequestLogDao splitRequestLogDao;
    @Autowired
    private OssUtil ossUtil;
    @Autowired
    private RabbitmqService rabbitmqService;
    @Value(value="${invoice.async.limit.rate:5}")
    private int limitRate;
    @Value(value="${invoice.async.items.count:2000}")
    private int asyncMaxItemCount;

    public SplitPreInvoiceResponse split(List<SplitPreInvoiceRequest> splitRequestList) {
        SplitPreInvoiceResponse res = new SplitPreInvoiceResponse();
        logger.info("split-\u62c6\u7968\u8bf7\u6c42:{}", (Object)JsonUtils.writeObjectToJson(splitRequestList));
        if (CollectionUtils.isEmpty(splitRequestList)) {
            res.setCode(Response.Fail);
            res.setMessage("\u62c6\u7968\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a.");
            return res;
        }
        long taskId = this.idGenerator.nextId();
        logger.info("taskId:{},\u62c6\u7968\u8bf7\u6c42\u5f00\u59cb,\u5f00\u59cb\u65f6\u95f4:{}", (Object)taskId, (Object)System.currentTimeMillis());
        ArrayList requestLogEntityList = Lists.newArrayList();
        HashSet set = new HashSet();
        splitRequestList.forEach(request -> {
            InvSellerSplitRequestLogEntity entity = new InvSellerSplitRequestLogEntity();
            if (request.getBatchNo() == null) {
                logger.error("taskId:{}\u6279\u6b21\u53f7\u4e3a\u7a7a", (Object)taskId);
                throw new RuntimeException("\u62c6\u7968\u5931\u8d25\uff0c\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!SplitType.isValid((int)request.getSplitType())) {
                logger.error("batchNo:{}\u62c6\u7968\u7c7b\u578b\u9519\u8bef,\u6240\u4f20\u7c7b\u578b:{}", (Object)request.getBatchNo(), (Object)request.getSplitType());
                throw new RuntimeException("\u9519\u8bef\u7684\u62c6\u7968\u7c7b\u578b");
            }
            if (request.getSplitRule() == null || request.getSplitRule().getRuleId() == null) {
                logger.error("batchNo:{}\u62c6\u7968\u89c4\u5219\u4e3a\u7a7a", (Object)request.getBatchNo());
                throw new RuntimeException("\u62c6\u7968\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (set.contains(request.getBatchNo())) {
                throw new RuntimeException("\u6279\u6b21\u53f7" + request.getBatchNo() + "\u4e0d\u80fd\u5206\u6279\u7ec4\u88c5\u3002");
            }
            set.add(request.getBatchNo());
            entity.setId(Long.valueOf(this.idGenerator.nextId()));
            entity.setResult(Integer.valueOf(SplitResult.PROCESSING.value()));
            entity.setOssKey("");
            entity.setRemark("\u5904\u7406\u4e2d");
            entity.setTerminalCode(request.getTerminalCode());
            entity.setTaskId(Long.valueOf(taskId));
            entity.setSplitType(Integer.valueOf(request.getSplitType()));
            entity.setBatchNo(request.getBatchNo());
            entity.setToken("");
            entity.setTerminalName(request.getTerminalName());
            entity.setOriginInvoiceType(request.getBillInfo().getOriginInvoiceType());
            entity.setOriginPaperDrawDate(request.getBillInfo().getOriginPaperDrawDate());
            requestLogEntityList.add(entity);
            request.setTaskId(entity.getId());
        });
        if (CollectionUtils.isEmpty((Collection)requestLogEntityList)) {
            logger.error("split requestLogEntityList:{}", (Object)JsonUtils.writeObjectToFastJson((Object)requestLogEntityList));
        } else {
            this.splitRequestExtDao.batchInsertSplitRequest(BatchParameter.wrap((List)requestLogEntityList));
        }
        splitRequestList.forEach(arg_0 -> this.split(arg_0));
        return res.ok(taskId);
    }

    private void split(SplitPreInvoiceRequest splitRequest) {
        boolean sync;
        if (splitRequest == null || splitRequest.getBillInfo() == null || splitRequest.getSplitRule() == null) {
            logger.warn("\u62c6\u7968\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        BillInfo billInfo = this.copyBillInfo(splitRequest);
        List itemList = this.copyBillItem(splitRequest);
        billInfo.setBillItems(itemList);
        SplitRule splitRule = this.copySplitRule(splitRequest);
        int rate = billInfo.getAmountWithoutTax().divide(splitRule.getInvoiceLimit(), 2, 4).intValue();
        boolean bl = sync = rate >= this.limitRate;
        if (itemList.size() >= this.asyncMaxItemCount && (SalesListFlag.NONE.value().equals(splitRule.getSaleListOption()) || splitRule.getInvoiceItemMaxRow() == 0)) {
            sync = true;
        }
        long taskId = splitRequest.getTaskId();
        String terminalCode = splitRequest.getTerminalCode();
        SplitRequest request = new SplitRequest();
        request.setBillInfo(billInfo);
        request.setBillMergeType(splitRequest.getMergeType());
        request.setSplitRule(splitRule);
        request.setSplitType(splitRequest.getSplitType());
        request.setTaskId(Long.valueOf(taskId));
        request.setBatchNo(splitRequest.getBatchNo());
        request.setTerminalCode(terminalCode);
        request.setTerminalName(splitRequest.getTerminalName());
        request.setOriginPaperrawDate(splitRequest.getBillInfo().getOriginPaperDrawDate());
        request.setOriginInvoiceType(splitRequest.getBillInfo().getOriginInvoiceType());
        logger.debug("\u8c03\u7528\u4e2d\u53f0\u62c6\u7968\u8bf7\u6c42:{}", (Object)JsonUtils.writeObjectToJson((Object)request));
        if (sync) {
            logger.info("taskId:{}\u5355\u636e\u91d1\u989d\u8f83\u5927 \u8fdb\u5165\u5f02\u6b65\u62c6\u7968\u6d41\u7a0b", (Object)taskId);
            this.asyncSplit(request);
        } else {
            logger.info("taskId:{}\u5355\u636e\u8f83\u5c0f \u8fdb\u5165\u540c\u6b65\u62c6\u7968", (Object)taskId);
            this.splitService.split(request);
        }
    }

    private SplitRule copySplitRule(SplitPreInvoiceRequest splitRequest) {
        SplitRule splitRule = (SplitRule)JsonUtils.writeJsonToObject((String)JsonUtils.writeObjectToJson((Object)splitRequest.getSplitRule()), SplitRule.class);
        if (splitRule.getInvoiceItemMaxRow() == null) {
            splitRule.setInvoiceItemMaxRow(Integer.valueOf(0));
        }
        if (splitRule.getZeroTaxOption() == null) {
            splitRule.setZeroTaxOption(ZeroTaxOption.NOT_PROCESS);
        }
        splitRule.setMergeBySplitFiled(splitRequest.getSplitRule().isMergeBySplitField());
        return splitRule;
    }

    private BillInfo copyBillInfo(SplitPreInvoiceRequest splitRequest) {
        BillInfo billInfo = new BillInfo();
        BeanUtils.copyProperties((Object)splitRequest.getBillInfo(), (Object)billInfo);
        billInfo.setRedNotificationNo(splitRequest.getBillInfo().getRedNotification());
        return billInfo;
    }

    private List<BillItem> copyBillItem(SplitPreInvoiceRequest splitRequest) {
        ArrayList itemList = Lists.newArrayList();
        splitRequest.getBillInfo().getBillItems().forEach(item -> {
            BillItem billItem = new BillItem();
            BeanUtils.copyProperties((Object)item, (Object)billItem);
            if (billItem.getDeductions() == null) {
                billItem.setDeductions(BigDecimal.ZERO);
            }
            if (billItem.getDiscountTax() == null) {
                billItem.setDiscountTax(BigDecimal.ZERO);
            }
            if (billItem.getDiscountWithoutTax() == null) {
                billItem.setDiscountWithoutTax(BigDecimal.ZERO);
            }
            if (billItem.getDiscountWithTax() == null) {
                billItem.setDiscountWithTax(BigDecimal.ZERO);
            }
            if (billItem.getInnerDiscountTax() == null) {
                billItem.setInnerDiscountTax(BigDecimal.ZERO);
            }
            if (billItem.getInnerDiscountWithoutTax() == null) {
                billItem.setInnerDiscountWithoutTax(BigDecimal.ZERO);
            }
            if (billItem.getInnerPrepayAmountTax() == null) {
                billItem.setInnerPrepayAmountTax(BigDecimal.ZERO);
            }
            if (billItem.getInnerPrepayAmountWithoutTax() == null) {
                billItem.setInnerPrepayAmountWithoutTax(BigDecimal.ZERO);
            }
            if (billItem.getInnerPrepayAmountWithTax() == null) {
                billItem.setInnerPrepayAmountWithTax(BigDecimal.ZERO);
            }
            if (billItem.getOutterDiscountTax() == null) {
                billItem.setOutterDiscountTax(BigDecimal.ZERO);
            }
            if (billItem.getOutterDiscountWithoutTax() == null) {
                billItem.setOutterDiscountWithoutTax(BigDecimal.ZERO);
            }
            if (billItem.getOutterDiscountWithTax() == null) {
                billItem.setOutterDiscountWithTax(BigDecimal.ZERO);
            }
            if (billItem.getOutterPrepayAmountTax() == null) {
                billItem.setOutterPrepayAmountTax(BigDecimal.ZERO);
            }
            if (billItem.getOutterPrepayAmountWithoutTax() == null) {
                billItem.setOutterPrepayAmountWithoutTax(BigDecimal.ZERO);
            }
            if (billItem.getOutterPrepayAmountWithTax() == null) {
                billItem.setOutterPrepayAmountWithTax(BigDecimal.ZERO);
            }
            itemList.add(billItem);
        });
        return itemList;
    }

    private void asyncSplit(SplitRequest request) {
        byte[] data = ZipUtil.compress((Object)request);
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        String key = this.ossUtil.uploadFileByInputStreamInternal(null, (InputStream)bis, Module.SELLER, false);
        InvSellerSplitRequestLogEntity entity = new InvSellerSplitRequestLogEntity();
        entity.setId(request.getTaskId());
        entity.setOssKey(key);
        this.splitRequestLogDao.updateByPrimaryKeySelective(entity);
        HashMap map = Maps.newHashMap();
        map.put("taskId", request.getTaskId());
        this.rabbitmqService.send("phoenix.seller.async.split", key, (Map)map);
    }
}

