/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.split.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.CreatePreInvoiceParam;
import com.xforceplus.phoenix.split.model.PreInvoiceMain;
import com.xforceplus.phoenix.split.model.SplitPreInvoiceInfo;
import com.xforceplus.phoenix.split.model.SplitResponse;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.seller.config.client.constant.InvoiceType;
import com.xforceplus.seller.invoice.client.PreInvoiceClient;
import com.xforceplus.seller.invoice.constants.enums.BillSystemOrigin;
import com.xforceplus.seller.invoice.constants.enums.InvoiceHCFlag;
import com.xforceplus.seller.invoice.constants.enums.PreInvoiceLockFlag;
import com.xforceplus.seller.invoice.constants.enums.PreInvoiceStatus;
import com.xforceplus.seller.invoice.dto.ExtInfo;
import com.xforceplus.seller.invoice.dto.PreInvoiceRelationWrapper;
import com.xforceplus.seller.invoice.dto.SplitRequest;
import com.xforceplus.seller.invoice.repository.daoext.InvBusinessLogExtDao;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerPreInvoiceDaoExt;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerPreInvoiceItemDaoExt;
import com.xforceplus.seller.invoice.repository.daoext.InvSellerPreSalesDetailDaoExt;
import com.xforceplus.seller.invoice.repository.model.InvSellerBusinessLogEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceItemEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreSalesDetailEntity;
import com.xforceplus.seller.invoice.service.pre.PreInvoiceService;
import com.xforceplus.seller.invoice.service.split.OriginBillPreInvoiceRelationService;
import com.xforceplus.seller.invoice.service.split.SplitCoreService;
import com.xforceplus.seller.invoice.service.split.SplitService;
import com.xforceplus.seller.invoice.service.tools.OssTools;
import com.xforceplus.seller.invoice.util.DateTools;
import com.xforceplus.seller.invoice.util.HttpUtils;
import com.xforceplus.seller.invoice.util.StringUtils;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.transaction.TransactionService;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.coderbee.mybatis.batch.BatchParameter;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SplitCoreServiceImpl
implements SplitCoreService {
    private static final Logger logger = LoggerFactory.getLogger(SplitCoreServiceImpl.class);
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private OriginBillPreInvoiceRelationService originRelationService;
    @Autowired
    private InvSellerPreInvoiceDaoExt preInvoiceDaoExt;
    @Autowired
    private InvSellerPreSalesDetailDaoExt salesDetailDaoExt;
    @Autowired
    private InvSellerPreInvoiceItemDaoExt preInvoiceItemDaoExt;
    @Autowired
    private PreInvoiceClient preinvoiceClient;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private OssTools ossTools;
    @Value(value="${upload.count:10}")
    private int uploadCount;
    @Autowired
    SplitService splitService;
    @Autowired
    PreInvoiceService preInvoiceService;
    @Autowired
    private InvBusinessLogExtDao businessLogExtDao;
    @Value(value="${split.preinvoice.url:http://bill-split-service.crc-local.xforceplus.com/2/invoice/v1/pre-invoices?appId=200&returnMode=sync}")
    private String splitUrl;

    @Transactional
    public List<Long> split(SplitRequest splitRequest) {
        if (splitRequest == null) {
            logger.warn("\u62c6\u7968\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        BillInfo billInfo = splitRequest.getBillInfo();
        billInfo.setBatchNo(splitRequest.getBatchNo());
        SplitRule splitRule = splitRequest.getSplitRule();
        int billMergeType = splitRequest.getBillMergeType();
        long startTime = System.currentTimeMillis();
        if (billInfo.getBillItems().size() > this.uploadCount) {
            try {
                String ossUrl = this.ossTools.putFile(JsonUtils.writeObjectToJson((Object)splitRequest));
                logger.info("batchNo:{},taskId:{},\u8bf7\u6c42\u4e2d\u53f0\u62c6\u7968sdk\u6587\u4ef6\u670d\u52a1\u5668\u5165\u53c2\uff0c\u6587\u4ef6\u5730\u5740:{},\u5f00\u59cb\u65f6\u95f4:{}", new Object[]{splitRequest.getBatchNo(), splitRequest.getTaskId(), ossUrl, startTime});
            }
            catch (Exception e) {
                logger.error("\u62c6\u7968\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38:{}", (Throwable)e);
            }
        } else {
            logger.info("batchNo:{},taskId:{},\u8bf7\u6c42\u4e2d\u53f0\u62c6\u7968sdk\u63a5\u53e3\u5165\u53c2:{},\u5f00\u59cb\u65f6\u95f4:{}", new Object[]{splitRequest.getBatchNo(), splitRequest.getTaskId(), StringUtils.truncateString((String)JsonUtils.writeObjectToJson((Object)splitRequest), (int)1000), startTime});
        }
        List resultList = this.splitByRest(splitRequest);
        return this.saveSplitPreInvoice(resultList, Integer.valueOf(billMergeType), splitRequest.getBatchNo(), splitRequest.getOriginPaperrawDate(), splitRequest.getOriginInvoiceType());
    }

    public List<SplitPreInvoiceInfo> splitByRest(SplitRequest splitRequest) {
        CreatePreInvoiceParam createPreInvoiceParam = this.splitService.buildCreatePreInvoiceParam(splitRequest);
        String msg = JsonUtils.writeObjectToJson((Object)createPreInvoiceParam);
        logger.debug("\u8bf7\u6c42\u62c6\u7968http\u63a5\u53e3\u5165\u53c2:{}", (Object)msg);
        long startTime = System.currentTimeMillis();
        try {
            String splitResult = HttpUtils.doPostJson((String)this.splitUrl, (String)msg);
            SplitResponse response = (SplitResponse)JsonUtils.writeFastJsonToObject((String)splitResult, SplitResponse.class);
            if ("BSCTZZ0001".equals(response.getCode())) {
                List resultList = response.getResult();
                int size = 0;
                for (int i = 0; i < resultList.size(); ++i) {
                    size += ((SplitPreInvoiceInfo)resultList.get(i)).getPreInvoiceItems().size();
                }
                if (size > this.uploadCount) {
                    try {
                        String ossUrl = this.ossTools.putFile(JsonUtils.writeObjectToJson((Object)splitRequest));
                        long endTime = System.currentTimeMillis();
                        logger.info("batchNo:{},taskId:{},\u4e2d\u53f0\u62c6\u7968sdk\u7ed3\u679c,\u6587\u4ef6\u5730\u5740:{},\u7ed3\u675f\u65f6\u95f4:{},cost - [{}]ms", new Object[]{splitRequest.getBatchNo(), splitRequest.getTaskId(), ossUrl, endTime, endTime - startTime});
                    }
                    catch (Exception e) {
                        logger.error("\u62c6\u7968\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38:{}", (Throwable)e);
                    }
                } else {
                    long endTime = System.currentTimeMillis();
                    logger.info("batchNo:{},taskId:{},\u4e2d\u53f0\u62c6\u7968sdk\u7ed3\u679c:{},\u7ed3\u675f\u65f6\u95f4:{},cost - [{}]ms", new Object[]{splitRequest.getBatchNo(), splitRequest.getTaskId(), StringUtils.truncateString((String)JsonUtils.writeObjectToJson((Object)resultList), (int)1000), endTime, endTime - startTime});
                }
                return resultList;
            }
            String errorMsg = "\u5c5e\u5730\u62c6\u7968\u5f02\u5e38,\u8fd4\u56de\u9519\u8bef\u7801:" + response.getCode() + ",\u9519\u8bef\u6d88\u606f\u63cf\u8ff0:" + response.getMessage();
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        catch (IOException e) {
            logger.error("\u5c5e\u5730\u62c6\u7968\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u5c5e\u5730\u62c6\u7968\u670d\u52a1\u53d1\u751f\u5f02\u5e38");
        }
    }

    @Transactional
    public List<Long> splitCallBack(List<SplitPreInvoiceInfo> result, Integer billMergeType, Long batchNo, String paperDrawDate, String originInvoiceType) {
        this.preInvoiceService.delPreInvoice(batchNo);
        return this.saveSplitPreInvoice(result, billMergeType, batchNo, paperDrawDate, originInvoiceType);
    }

    @Transactional
    public List<Long> saveSplitPreInvoice(List<SplitPreInvoiceInfo> resultList, Integer billMergeType, Long batchNo, String originPaperDrawDate, String originInvoiceType) {
        ArrayList preInvoiceList = Lists.newArrayList();
        ArrayList salesDetailList = Lists.newArrayList();
        ArrayList preInvoiceIdList = Lists.newArrayList();
        ArrayList preInvoiceItemList = Lists.newArrayList();
        LinkedHashSet needApplyRedNoIds = Sets.newLinkedHashSet();
        for (SplitPreInvoiceInfo preInvoiceInfo : resultList) {
            List itemEntityList;
            InvSellerPreInvoiceEntity preInvoice = this.buildPreInvoice(preInvoiceInfo);
            preInvoice.setMergeType(billMergeType);
            preInvoice.setOriginPaperDrawDate(originPaperDrawDate);
            preInvoice.setOriginInvoiceType(originInvoiceType);
            Long preInvoiceId = this.idGenerator.nextId();
            preInvoiceIdList.add(preInvoiceId);
            preInvoice.setId(preInvoiceId);
            preInvoiceList.add(preInvoice);
            PreInvoiceRelationWrapper wrapper = this.buildPreInvoiceItem(preInvoiceInfo, preInvoiceId);
            preInvoice.setSalesbillId(((InvSellerPreInvoiceItemEntity)wrapper.getItemList().get(0)).getSalesbillId());
            preInvoice.setSalesbillNo(((InvSellerPreInvoiceItemEntity)wrapper.getItemList().get(0)).getSalesbillNo());
            preInvoiceItemList.addAll(wrapper.getItemList());
            salesDetailList.addAll(wrapper.getSalesDetailList());
            if (preInvoice.getInvoiceType().equals(InvoiceType.SPECIAL.value()) && preInvoice.getAmountWithTax().compareTo(BigDecimal.ZERO) < 0) {
                needApplyRedNoIds.add(preInvoiceId);
            }
            if (CollectionUtils.isEmpty((Collection)(itemEntityList = wrapper.getItemList()))) continue;
            int modifyMarkSum = 0;
            for (InvSellerPreInvoiceItemEntity preItemEntity : itemEntityList) {
                modifyMarkSum += Objects.isNull(preItemEntity.getModifyMark()) ? 0 : preItemEntity.getModifyMark();
            }
            if (modifyMarkSum <= 0) continue;
            preInvoice.setModifyMark(Integer.valueOf(1));
        }
        if (!preInvoiceList.isEmpty()) {
            logger.info("preInvoiceList {}", (Object)JsonUtils.writeObjectToFastJson((Object)preInvoiceList));
            this.preInvoiceDaoExt.batchInsertPreInvoices(BatchParameter.wrap((List)preInvoiceList));
            String logName = "\u3010" + DateTools.getTimeStr() + "\u3011\u65f6\u95f4\uff0c\u751f\u6210\u9884\u5236\u53d1\u7968!";
            this.insertBusinessLog((List)preInvoiceIdList, 7, logName);
        }
        if (!preInvoiceItemList.isEmpty()) {
            logger.info("preInvoiceItemList {}", (Object)JsonUtils.writeObjectToFastJson((Object)preInvoiceItemList));
            this.preInvoiceItemDaoExt.batchInsertPreInvoiceItems(BatchParameter.wrap((List)preInvoiceItemList));
        }
        if (!salesDetailList.isEmpty()) {
            this.salesDetailDaoExt.batchInsertPreSalesDetails(BatchParameter.wrap((List)salesDetailList));
        }
        if (needApplyRedNoIds.size() > 0) {
            try {
                this.transactionService.afterTransactionCommit(() -> this.preinvoiceClient.applyRedNoByPreInvoice((List)Lists.newArrayList((Iterable)needApplyRedNoIds)));
            }
            catch (Exception e) {
                logger.error("\u7533\u8bf7\u7ea2\u5b57\u7684\u9884\u5236\u53d1\u7968\u6570\u636e\u5931\u8d25{}", (Object)JsonUtils.writeObjectToFastJson((Object)needApplyRedNoIds), (Object)e);
            }
        }
        this.originRelationService.buildRelation(batchNo, (List)salesDetailList, billMergeType.intValue());
        return preInvoiceIdList;
    }

    private void insertBusinessLog(List<Long> preInvoiceIdList, int operationType, String logName) {
        List collect = preInvoiceIdList.stream().map(preInv -> {
            InvSellerBusinessLogEntity entity = new InvSellerBusinessLogEntity();
            entity.setBusinessId(preInv);
            entity.setCreateTime(DateTime.now().toDate());
            entity.setBusinessType(Integer.valueOf(1));
            entity.setOperationTime(DateTime.now().toDate());
            entity.setOperationType(Integer.valueOf(operationType));
            entity.setOperationDesc("\u751f\u6210\u9884\u5236\u53d1\u7968");
            entity.setOperationContent(logName);
            entity.setOperationUserId(Long.valueOf(0L));
            entity.setOperationUserName("\u7cfb\u7edf");
            return entity;
        }).collect(Collectors.toList());
        this.businessLogExtDao.batchInsertBusinessLog(BatchParameter.wrap(collect));
    }

    private InvSellerPreInvoiceEntity buildPreInvoice(SplitPreInvoiceInfo splitInfo) {
        InvSellerPreInvoiceEntity preInvoice = new InvSellerPreInvoiceEntity();
        PreInvoiceMain main = splitInfo.getPreInvoiceMain();
        BeanUtils.copyProperties((Object)main, (Object)preInvoice);
        preInvoice.setInvoiceCode("");
        preInvoice.setInvoiceNo("");
        preInvoice.setStatus(Integer.valueOf(PreInvoiceStatus.PENDING_INVOICE.value()));
        preInvoice.setLockFlag(Integer.valueOf(PreInvoiceLockFlag.NONE.value()));
        preInvoice.setRedFlag(InvoiceHCFlag.NORMAL.value());
        preInvoice.setCreateTime(Calendar.getInstance().getTime());
        preInvoice.setUpdateTime(Calendar.getInstance().getTime());
        preInvoice.setRuleId(Long.valueOf(splitInfo.getRuleId()));
        preInvoice.setOutBatchNo(main.getBatchNo());
        String extInfoJson = main.getExtInfo();
        ExtInfo extInfo = this.generatorExtInfo(extInfoJson);
        if (Objects.nonNull(extInfo)) {
            preInvoice.setModifyMark(extInfo.getModifyMark());
        } else {
            preInvoice.setModifyMark(Integer.valueOf(0));
        }
        if (BillSystemOrigin.IMPORT.value().equals(main.getSystemOrig())) {
            preInvoice.setSystemOrigType(Integer.valueOf(1));
        } else {
            preInvoice.setSystemOrigType(Integer.valueOf(0));
        }
        return preInvoice;
    }

    private PreInvoiceRelationWrapper buildPreInvoiceItem(SplitPreInvoiceInfo splitInfo, Long preInvoiceId) {
        PreInvoiceRelationWrapper wrapper = new PreInvoiceRelationWrapper();
        ArrayList itemList = Lists.newArrayList();
        ArrayList salesDetailList = Lists.newArrayList();
        List resultList = splitInfo.getPreInvoiceItems();
        resultList.forEach(item -> {
            InvSellerPreInvoiceItemEntity entity = new InvSellerPreInvoiceItemEntity();
            BeanUtils.copyProperties((Object)item, (Object)entity);
            ExtInfo extInfo = this.generatorExtInfo(item.getExtInfo());
            if (Objects.nonNull(extInfo)) {
                entity.setModifyMark(extInfo.getModifyMark());
            } else {
                entity.setModifyMark(Integer.valueOf(0));
            }
            entity.setPreInvoiceId(preInvoiceId);
            long preInvoiceItemId = this.idGenerator.nextId();
            entity.setId(Long.valueOf(preInvoiceItemId));
            entity.setPriceMethod("0");
            itemList.add(entity);
            InvSellerPreSalesDetailEntity billDetailEntity = new InvSellerPreSalesDetailEntity();
            BeanUtils.copyProperties((Object)item, (Object)billDetailEntity);
            billDetailEntity.setBatchNo(splitInfo.getPreInvoiceMain().getBatchNo());
            billDetailEntity.setPreInvoiceId(preInvoiceId);
            billDetailEntity.setPreInvoiceItemId(Long.valueOf(preInvoiceItemId));
            billDetailEntity.setBusinessBillType(splitInfo.getPreInvoiceMain().getBusinessBillType());
            billDetailEntity.setStatus("1");
            billDetailEntity.setCreateTime(Calendar.getInstance().getTime());
            billDetailEntity.setCreateUserId(Long.valueOf(0L));
            billDetailEntity.setUpdateUserId(Long.valueOf(0L));
            salesDetailList.add(billDetailEntity);
        });
        wrapper.setItemList((List)itemList);
        wrapper.setSalesDetailList((List)salesDetailList);
        return wrapper;
    }

    private ExtInfo generatorExtInfo(String extInfoJson) {
        ExtInfo extInfo;
        if (!org.springframework.util.StringUtils.isEmpty((Object)extInfoJson) && Objects.nonNull(extInfo = (ExtInfo)JsonUtils.writeJsonToObject((String)extInfoJson, ExtInfo.class))) {
            if (extInfo.getModifyMark() == null) {
                extInfo.setModifyMark(Integer.valueOf(0));
            }
            return extInfo;
        }
        return null;
    }
}

