package com.xforceplus.smart.match.invoice.client.api;

import com.xforceplus.smart.match.invoice.client.model.PreApplyValidateRequest;
import com.xforceplus.smart.match.invoice.client.model.PreApplyValidateResult;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author : hujintao
 * @version : 1.0
 * @description :
 * @date : 2024/06/04
 **/
public interface PreApplyRedConfirmationApi {

    @ApiOperation(value = "预申请红字确认单校验", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/pre-apply/validate",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<PreApplyValidateResult> preApplyValidate(@ApiParam(value = "预申请红字校验请求信息", required = true) @RequestBody
        PreApplyValidateRequest request);
}
