package com.xforceplus.smart.match.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 轮询打分结果信息
 */
@Data
public class PollingMatchedInvoiceRequest implements Serializable {
    @ApiModelProperty(value = "任务Id")
    @JsonProperty("taskId")
    private Long taskId;

    @ApiModelProperty(value = "消息类型")
    @JsonProperty("msgType")
    private Integer msgType;

    @ApiModelProperty(value = "消息id")
    @JsonProperty("msgSeq")
    private Long msgSeq;

    @ApiModelProperty(value = "消息处理落库时间")
    @JsonProperty("msgTime")
    private Long msgTime;

    @ApiModelProperty(value = "匹配度")
    @JsonProperty("matchingDegree")
    private BigDecimal matchingDegree;
}
