package com.xforceplus.smart.match.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author : hujintao
 * @version : 1.0
 * @description : 预申请校验请求信息
 * @date : 2024/05/31
 **/
@Data
public class PreApplyValidateRequest {

    @ApiModelProperty("计价方式 1-含税 0-不含税")
    @Range(min = 0, max = 1, message = "计价方式不合法")
    private Integer priceMethod;
    @ApiModelProperty("源信息（单据/预制发票）")
    @NotNull(message = "源数据不能为空")
    private PreApplyMainInfo source;
    @ApiModelProperty("已预申请信息")
    private List<PreApplyMainInfo> preApplyList;
    @ApiModelProperty("此次预申请信息")
    @NotNull(message = "预申请信息不能为空")
    private PreApplyMainInfo preApplyInfo;
    @ApiModelProperty("匹配规则")
    @NotEmpty(message = "匹配规则不能为空")
    private List<ConfigItemBean> configItemBeanList;

    @Data
    public static class PreApplyMainInfo {

        @ApiModelProperty("主信息id")
        private Long id;
        @ApiModelProperty("购方租户id")
        private Long purchaserTenantId;
        @ApiModelProperty("购方公司id")
        private Long purchaserId;
        @ApiModelProperty("购方编号")
        private String purchaserNo;
        @ApiModelProperty("购方名称")
        private String purchaserName;
        @ApiModelProperty("购方税号")
        private String purchaserTaxNo;
        @ApiModelProperty("购方电话")
        private String purchaserTel;
        @ApiModelProperty("购方地址")
        private String purchaserAddress;
        @ApiModelProperty("购方开户行")
        private String purchaserBankName;
        @ApiModelProperty("购方银行账号")
        private String purchaserBankAccount;
        @ApiModelProperty("销方租户id")
        private Long sellerTenantId;
        @ApiModelProperty("销方编号")
        private String sellerNo;
        @ApiModelProperty("销方税号")
        private String sellerTaxNo;
        @ApiModelProperty("销方名称")
        private String sellerName;
        @ApiModelProperty("销方电话")
        private String sellerTel;
        @ApiModelProperty("销方地址")
        private String sellerAddress;
        @ApiModelProperty("销方开户行")
        private String sellerBankName;
        @ApiModelProperty("销方银行账号")
        private String sellerBankAccount;
        @ApiModelProperty("销方公司id")
        private Long sellerId;
        @ApiModelProperty("发票类型")
        private String invoiceType;
        @ApiModelProperty("税控发票来源 qd - 全电发票; sk - 税控发票")
        private String taxInvoiceSource;
        @ApiModelProperty("发票票种 s - 纸专; se - 电专; c - 纸普; ce - 电普; v - 机动车; vs - 二手机动车; ju - 卷票")
        private String invoiceKind;
        @ApiModelProperty("单据类型")
        private String salesbillType;
        @ApiModelProperty("不含税金额")
        private BigDecimal amountWithoutTax;
        @ApiModelProperty("税额")
        private BigDecimal taxAmount;
        @ApiModelProperty("含税金额")
        private BigDecimal amountWithTax;
        @ApiModelProperty("税率")
        private String taxRate;
        @ApiModelProperty("备注")
        private String remark;
        @ApiModelProperty("收款人")
        private String cashierName;
        @ApiModelProperty("复核人")
        private String checkerName;
        @ApiModelProperty("开票人")
        private String invoicerName;
        @ApiModelProperty("特殊发票标记  0-默认  1-通行费   2-成品油")
        private String specialInvoiceFlag;
        @ApiModelProperty("认证状态")
        private String identifyStatus;
        @ApiModelProperty("认证所属期")
        private String authTaxPeriod;
        @ApiModelProperty("扩展1")
        private String ext1;
        @ApiModelProperty("扩展2")
        private String ext2;
        @ApiModelProperty("扩展3")
        private String ext3;
        @ApiModelProperty("扩展4")
        private String ext4;
        @ApiModelProperty("扩展5")
        private String ext5;
        @ApiModelProperty("扩展6")
        private String ext6;
        @ApiModelProperty("扩展7")
        private String ext7;
        @ApiModelProperty("扩展8")
        private String ext8;
        @ApiModelProperty("扩展9")
        private String ext9;
        @ApiModelProperty("扩展10")
        private String ext10;
        @ApiModelProperty("扩展11")
        private String ext11;
        @ApiModelProperty("扩展12")
        private String ext12;
        @ApiModelProperty("扩展13")
        private String ext13;
        @ApiModelProperty("扩展14")
        private String ext14;
        @ApiModelProperty("扩展15")
        private String ext15;
        @ApiModelProperty("扩展16")
        private String ext16;
        @ApiModelProperty("扩展17")
        private String ext17;
        @ApiModelProperty("扩展18")
        private String ext18;
        @ApiModelProperty("扩展19")
        private String ext19;
        @ApiModelProperty("扩展20")
        private String ext20;
        @ApiModelProperty("扩展21")
        private String ext21;
        @ApiModelProperty("扩展22")
        private String ext22;
        @ApiModelProperty("扩展23")
        private String ext23;
        @ApiModelProperty("扩展24")
        private String ext24;
        @ApiModelProperty("扩展25")
        private String ext25;
        @ApiModelProperty("明细信息")
        private List<PreApplyItemInfo> itemList;
    }

    @Data
    public static class PreApplyItemInfo {

        @ApiModelProperty("明细信息id")
        private Long id;
        @ApiModelProperty("发票明细id")
        private Long invoiceItemId;
        @ApiModelProperty("发票明细行号")
        private Integer rowNum;
        @ApiModelProperty("税收分类编码")
        private String goodsTaxNo;
        @ApiModelProperty("货物或应税劳务名称")
        private String cargoName;
        @ApiModelProperty("货物或应税劳务代码")
        private String cargoCode;
        @ApiModelProperty("规格型号")
        private String itemSpec;
        @ApiModelProperty("单价不含税")
        private BigDecimal unitPrice;
        @ApiModelProperty("数量")
        private BigDecimal quantity;
        @ApiModelProperty("单位")
        private String quantityUnit;
        @ApiModelProperty("税率")
        private BigDecimal taxRate;
        @ApiModelProperty("不含税金额")
        private BigDecimal amountWithoutTax;
        @ApiModelProperty("税额")
        private BigDecimal taxAmount;
        @ApiModelProperty("含税金额")
        private BigDecimal amountWithTax;
        @ApiModelProperty("折扣不含税金额")
        private BigDecimal discountWithoutTax;
        @ApiModelProperty("折扣含税金额")
        private BigDecimal discountWithTax;
        @ApiModelProperty("折扣税额")
        private BigDecimal discountTax;
        @ApiModelProperty("编码版本号")
        private String goodsNoVer;
        @ApiModelProperty("是否享受税收优惠政策")
        private String taxPre;
        @ApiModelProperty("是否享受税收优惠政策内容")
        private String taxPreCon;
        @ApiModelProperty("零税率标识")
        private String zeroTax;
        @ApiModelProperty("扣除额")
        private BigDecimal deduction;
        @ApiModelProperty("扩展1")
        private String ext1;
        @ApiModelProperty("扩展2")
        private String ext2;
        @ApiModelProperty("扩展3")
        private String ext3;
        @ApiModelProperty("扩展4")
        private String ext4;
        @ApiModelProperty("扩展5")
        private String ext5;
        @ApiModelProperty("扩展6")
        private String ext6;
        @ApiModelProperty("扩展7")
        private String ext7;
        @ApiModelProperty("扩展8")
        private String ext8;
        @ApiModelProperty("扩展9")
        private String ext9;
        @ApiModelProperty("扩展10")
        private String ext10;
        @ApiModelProperty("扩展11")
        private String ext11;
        @ApiModelProperty("扩展12")
        private String ext12;
        @ApiModelProperty("扩展13")
        private String ext13;
        @ApiModelProperty("扩展14")
        private String ext14;
        @ApiModelProperty("扩展15")
        private String ext15;
        @ApiModelProperty("扩展16")
        private String ext16;
        @ApiModelProperty("扩展17")
        private String ext17;
        @ApiModelProperty("扩展18")
        private String ext18;
        @ApiModelProperty("扩展19")
        private String ext19;
        @ApiModelProperty("扩展20")
        private String ext20;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ConfigItemBean {
        @JsonProperty("configItemId")
        private Long configItemId = null;
        @JsonProperty("configId")
        private Long configId = null;
        @JsonProperty("configItemName")
        private String configItemName = null;
        @JsonProperty("configItemDisplayName")
        private String configItemDisplayName = null;
        @JsonProperty("configItemValue")
        private List<String> configItemValue = new ArrayList<>();
        @JsonProperty("sort")
        private Integer sort = null;
    }
}
