package com.xforceplus.smart.match.invoice.client.model;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author : hujintao
 * @version : 1.0
 * @description : 预申请校验结果
 * @date : 2024/05/31
 **/
@Data
public class PreApplyValidateResult {

    @ApiModelProperty("主信息校验结果 true-成功 false-失败")
    private boolean mainCheck = true;
    @ApiModelProperty("主信息校验失败原因")
    private String mainFailMsg = "";
    @ApiModelProperty("明细信息校验结果 true-成功 false-失败")
    private boolean itemCheck = true;
    @ApiModelProperty("明细信息校验失败详情")
    private List<PreApplyDetailResult> itemResultList = new ArrayList<>();

    public boolean checkSuccess() {
        return this.mainCheck && this.itemCheck;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class PreApplyDetailResult {

        @ApiModelProperty("蓝票明细id")
        private Long invoiceItemId;
        @ApiModelProperty("货物或应税劳务名称")
        private String cargoName;
        @ApiModelProperty("校验失败原因")
        private String failMsg;
        @ApiModelProperty("明细行号")
        private Integer rowNum;
    }
}
