package com.xforceplus.smart.match.invoice.client.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 预处理预申请数据
 */
public class ReengineeringPreApplyData implements Serializable {

    /**
     * 请求数据
     */
    @Data
    public static class Request implements Serializable {
        private List<MainData> dataList;
    }

    /**
     * 返回数据
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Result implements Serializable {
        private List<MainData> dataList;
    }

    /**
     * 一个发票的数据
     */
    @Data
    public static class MainData implements Serializable {
        private List<PreApplyItemData> itemList;
    }

    /**
     * 一个发票的明细数据
     */
    @Data
    public static class PreApplyItemData implements Serializable {
        private Long id;
        private Long redLetterId;
        private String itemCode;
        private String itemName;
        private String itemShortName;
        private String goodsTaxNo;
        private String taxPreCon;
        private String unit;
        private String specifications;
        private BigDecimal quantity;
        private BigDecimal taxRate;
        private BigDecimal amountWithTax;
        private BigDecimal amountWithoutTax;
        private BigDecimal taxAmount;
        private BigDecimal deduction;
        private Long rowNum;
        private Long createdBy;
        private Date createdAt;
        private Long modifiedBy;
        private Date modifiedAt;
        private BigDecimal unitPriceWithTax;
        private BigDecimal unitPrice;
    }
}
