package com.xforceplus.smart.match.invoice.client.api;

import com.xforceplus.smart.match.invoice.client.model.PreApplyCustomizationDto;
import com.xforceplus.smart.match.invoice.client.model.ReengineeringPreApplyData;
import com.xforceplus.smart.match.invoice.client.model.ReengineeringSmartData;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface ReengineeringApi {

    @ApiOperation(value = "智能找票发票数据预处理", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/{tenantId}/preDealSmartInvoiceData",
            produces = {"application/json"},
            method = RequestMethod.POST)
    @Deprecated
    Response<ReengineeringSmartData.Result> preDealSmartInvoiceData(@PathVariable("tenantId") Long tenantId, @RequestBody ReengineeringSmartData.Request request);

    @ApiOperation(value = "预申请数据预处理", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/{tenantId}/preDealPreApplyInvoiceData",
            produces = {"application/json"},
            method = RequestMethod.POST)
    @Deprecated
    Response<ReengineeringPreApplyData.Result> preDealPreApplyInvoiceData(@PathVariable("tenantId") Long tenantId, @RequestBody ReengineeringPreApplyData.Request request);

    @ApiOperation(value = "预申请数据预处理V2", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/v2/{tenantId}/preDealPreApplyInvoiceData",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<PreApplyCustomizationDto> preDealPreApplyInvoiceDataV2(@PathVariable("tenantId") Long tenantId, @RequestBody PreApplyCustomizationDto dto);
}
