package com.xforceplus.smart.match.invoice.client.api;

import com.xforceplus.smart.match.invoice.client.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.constraints.NotNull;
import java.util.List;

@Api(value = "invoice", description = "the invoice API")
public interface SmartMatchInvoiceApi {

    @ApiOperation(value = "智能匹配发票查询(同步）", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/invoice/smart-match/invoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<SmartMatchInvoiceResult> smartMatchingInvoice(@ApiParam(value = "匹配发票查询请求", required = true) @RequestBody SmartMatchInvoiceRequest matchRequest);


    @ApiOperation(value = "获取最近一次匹配任务信息", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SmartMatchInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/invoice/smart-match/recentlyTask",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<SmartMatchTask> queryRecentlySmartMatchTask(@NotNull @ApiParam(value = "获取最近一次匹配任务信息", required = true) @RequestBody RunningTaskRequest runningTaskRequest);

    @ApiOperation(value = "智能匹配发票查询（异步）", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/invoice/async-smart-match/invoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<Long> asyncSmartMatchingInvoice(@ApiParam(value = "智能匹配发票查询请求(异步）", required = true) @RequestBody SmartMatchInvoiceRequest matchRequest);

    @ApiOperation(value = "智能匹配发票结果轮询", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/invoice/async-smart-match/pollingMatchedInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<SmartMatchInvoiceResult> pollingMatchedInvoice(@ApiParam(value = "智能匹配发票结果轮询", required = true) @RequestBody PollingMatchedInvoiceRequest pollingRequest);
    @ApiOperation(value = "智能组合发票结果轮询", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/invoice/async-smart-match/pollingRecommendInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<SmartMatchInvoiceResult> pollingRecommendInvoice(@ApiParam(value = "智能组合发票结果轮询", required = true) @RequestBody PollingRecommendInvoiceRequest pollingRequest);

    @ApiOperation(value = "增加/减少预申请锁定金额", response = Response.class, tags = {"SmartInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/invoice/update-pre-reverse-amount", produces = {"application/json"}, method = RequestMethod.POST)
    Response<Object> updateInvoicePreReverseAmount(@RequestBody UpdateInvoiceItemPreReverseAmountRequest request);

    @ApiOperation(value = "查询智能组合失败的详细信息", response = Response.class, tags = {"SmartInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/invoice/recommend-fail-result", produces = {"application/json"}, method = RequestMethod.POST)
    Response<List<QueryRecommendFailResult>> getRecommendFailResult(@RequestBody QueryRecommendFailRequest request);
}
