package com.xforceplus.smart.match.invoice.client.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class PreApplyCustomizationDto implements Serializable {
    private List<Invoice> invoiceDataList;
    private List<Bill> billDataList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Invoice implements Serializable {
        private List<InvoiceItem> itemList;
    }

    /**
     * 一个发票的明细数据
     */
    @Data
    public static class InvoiceItem implements Serializable {
        private Long id;
        private Long redLetterId;
        private String itemCode;
        private String itemName;
        private String itemShortName;
        private String goodsTaxNo;
        private String taxPreCon;
        private String unit;
        private String specifications;
        private BigDecimal quantity;
        private BigDecimal taxRate;
        private BigDecimal amountWithTax;
        private BigDecimal amountWithoutTax;
        private BigDecimal taxAmount;
        private BigDecimal deduction;
        private Long rowNum;
        private Long createdBy;
        private Date createdAt;
        private Long modifiedBy;
        private Date modifiedAt;
        private BigDecimal unitPriceWithTax;
        private BigDecimal unitPrice;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Bill implements Serializable {
        private List<BillItem> itemList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class BillItem {
        private Long id;
        private Long redLetterId;
        private String itemCode;
        private String itemName;
        private String itemShortName;
        private String goodsTaxNo;
        private String taxPreCon;
        private String quantityUnit;
        private String itemSpec;
        private BigDecimal quantity;
        private BigDecimal taxRate;
        private BigDecimal amountWithTax;
        private BigDecimal amountWithoutTax;
        private BigDecimal taxAmount;
        private BigDecimal outterDiscountWithTax;
        private BigDecimal outterDiscountWithoutTax;
        private BigDecimal outterDiscountTax;
        private BigDecimal innerDiscountWithTax;
        private BigDecimal innerDiscountWithoutTax;
        private BigDecimal innerDiscountTax;
        private BigDecimal deduction;
        private BigDecimal unitPriceWithTax;
        private BigDecimal unitPrice;
        private Integer originalInvoiceRowNum;
    }

}
