package com.xforceplus.smart.match.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class RunningTaskRequest implements Serializable {

    @ApiModelProperty(value = "销方租户ID，协同场景下需要传")
    @JsonProperty("sellerGroupId")
    private Long sellerGroupId;

    @ApiModelProperty(value = "使用上下文租户Id")
    @JsonProperty("useContextGroupId")
    private Boolean useContextGroupId = true;

    @ApiModelProperty(value = "单据或预制发票主键")
    @JsonProperty("matchId")
    private Long matchId;

    @ApiModelProperty("匹配角色")
    private Integer matchRole;

    @ApiModelProperty("红冲原因")
    private String makingReason;

    @ApiModelProperty("不含税金额")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty("含税金额")
    private BigDecimal amountWithTax;

    @ApiModelProperty("操作类型")
    private String actionType;

}
