package com.xforceplus.smart.match.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 按匹配度返回查询的发票信息
 */
@Data
public class SmartMatchInvoiceRequest implements Serializable {
    @ApiModelProperty(value = "单据/预制发票对象")
    @JsonProperty("matchingMain")
    private MatchingMain matchingMain;

    @ApiModelProperty(value = "销方租户ID，协同场景下需要传")
    @JsonProperty("sellerGroupId")
    private Long sellerGroupId;

    @ApiModelProperty(value = "开票日期范围")
    @JsonProperty("rangeTimes")
    private List<Long> rangeTimes;

    @ApiModelProperty(value = "认证状态集合")
    @JsonProperty("identifyStatusList")
    private List<String> identifyStatusList;

    @ApiModelProperty(value = "请求来源")
    @JsonProperty("requestSource")
    private String requestSource;

    @ApiModelProperty(value = "预匹配的发票idList")
    @JsonProperty("invoiceIdList")
    private List<Long> invoiceIdList;

    @ApiModelProperty(value = "预申请已关联发票idList")
    @JsonProperty("excludeInvoiceIdList")
    private List<Long> excludeInvoiceIdList;

    @ApiModelProperty("找票和算分规则")
    private List<MatchingRule> rules;

    /**
     * 支持单个
     */
    @ApiModelProperty("找票和算分规则")
    private MatchingRule rule;

    @ApiModelProperty("匹配角色")
    private Integer matchRole;

    @ApiModelProperty("调用方标识，自定义。主要用于智能推荐/组合完成后的异步下发")
    private String callerIdentity;

    @ApiModelProperty("外部系统标识，自定义。主要用于智能推荐/组合完成后的异步下发")
    private String externalId;

    @ApiModelProperty("购方租户id， 协同场景下需要传")
    private Long purchaserGroupId;

    @ApiModelProperty("操作类型")
    private String actionType;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MatchingMain implements Serializable {
        @ApiModelProperty("匹配对象Id 业务单id 或 预制发票id")
        private Long matchId;
        @ApiModelProperty("salesbillNo")
        private String salesbillNo;
        @ApiModelProperty("sellerGroupId")
        private Long sellerGroupId;
        @ApiModelProperty("invoiceType")
        private String invoiceType;
        @ApiModelProperty("sellerName")
        private String sellerName;
        @ApiModelProperty("sellerTaxNo")
        private String sellerTaxNo;
        @ApiModelProperty("purchaserGroupId")
        private Long purchaserGroupId;
        @ApiModelProperty("purchaserName")
        private String purchaserName;
        @ApiModelProperty("purchaserTaxNo")
        private String purchaserTaxNo;
        @ApiModelProperty("priceMethod")
        private Integer priceMethod;
        @ApiModelProperty("amountWithoutTax")
        private BigDecimal amountWithoutTax;
        @ApiModelProperty("amountWithTax")
        private BigDecimal amountWithTax;
        @ApiModelProperty("taxAmount")
        private BigDecimal taxAmount;
        @ApiModelProperty("makingReason")
        private String makingReason;
        @ApiModelProperty("匹配明细对象List 单据明细或预制发票明细")
        private List<MatchingItem> matchingItemList;
        @ApiModelProperty("请求来源")
        private String requestSource;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MatchingItem implements Serializable {
        @ApiModelProperty("明细Id")
        private Long billItemId;
        @ApiModelProperty("货物名称 格式：*简称*商品名称")
        private String itemName;
        @ApiModelProperty("计价方式")
        private Integer priceMethod;
        @ApiModelProperty("不含税单价")
        private BigDecimal unitPrice;
        @ApiModelProperty("含税单价")
        private BigDecimal unitPriceWithTax;
        @ApiModelProperty("含税金额")
        private BigDecimal amountWithTax;
        @ApiModelProperty("不含税金额")
        private BigDecimal amountWithoutTax;
        @ApiModelProperty("税额")
        private BigDecimal taxAmount;
        @ApiModelProperty("数量")
        private BigDecimal quantity;
        @ApiModelProperty("数量单位")
        private String quantityUnit;
        @ApiModelProperty("税收分类编码")
        private String goodsTaxNo;
        @ApiModelProperty("规格型号")
        private String itemSpec;
        @ApiModelProperty("税率")
        private BigDecimal taxRate;
        @ApiModelProperty("是否享受税收优惠政策0-不1-享受")
        private String taxPre;
        @ApiModelProperty("享受税收优惠政策内容 0-不 1-享受")
        private String taxPreCon;
        @ApiModelProperty("零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率")
        private String zeroTax;
        @ApiModelProperty("税编转换代码")
        private String taxConvertCode;
        @ApiModelProperty("编码版本号")
        private String goodsNoVer;
        @ApiModelProperty("大类名称")
        private String largeCategoryName;
        @ApiModelProperty("中类名称")
        private String medianCategoryName;
        @ApiModelProperty("小类名称")
        private String smallCategoryName;
        @ApiModelProperty("明细项特殊处理字段，SI:销项,RI:退项,PA:正调整单,MA:负调整单")
        private String specialItemType;
        @ApiModelProperty("业务单明细号")
        private String billItemNo;
        @ApiModelProperty("商品编码")
        private String itemCode;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MatchingRule {
        @ApiModelProperty("找票规则")
        private List<FindRuleItem> findRule;
        @ApiModelProperty("打分规则")
        private List<CalScoreRuleItem> calScoreRule;
        @ApiModelProperty("红冲原因，只影响批量智能组合（因为不能选原因），其他可选原因场景则忽略")
        private String redReason;
        @ApiModelProperty("匹配算法")
        private Integer matchAlgorithm;
        /**
         * 销货退回，哪一侧字段保持一致
         */
        private Integer salesReturnFieldSameRule;
        /**
         * 规则名称
         */
        private String ruleName;
        /**
         * 金额校验
         */
        private Integer amountCheckRule;
        /**
         * 税额适配范围
         */
        private BigDecimal taxAmountMaxAdjust;
        /**
         * 找票方式
         */
        private Integer findAlgorithm;

        /**
         * order 
         */
        private int order;

        @Data
        @AllArgsConstructor
        @NoArgsConstructor
        public static class FindRuleItem {
            private String field;
            @ApiModelProperty("操作符")
            private String op;
            @ApiModelProperty("字段类型")
            private String type;
            private String value;
            private List<String> valueList;
            @ApiModelProperty("字段种类，对应 SmartMatchFieldKind 枚举")
            private Integer fieldKind = 0;
        }

        @Data
        @AllArgsConstructor
        @NoArgsConstructor
        public static class CalScoreRuleItem {
            private String field;
            @ApiModelProperty("字段类型")
            private String type;
            @ApiModelProperty("匹配类型")
            private String matchType;
            @ApiModelProperty("容差，仅当type为BigDecimal时有效")
            private BigDecimal tolerance;
            @ApiModelProperty("是否要求强一致，强一致也遵循容差配置")
            private Boolean force;
            @ApiModelProperty("值类型，当type为String或BigDecimal时有效")
            private Integer valueMode;
            @ApiModelProperty("值")
            private String value;
        }
    }

}
