package com.xforceplus.smart.match.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;


@ApiModel(description = "智能匹配查询返回结果信息")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SmartMatchInvoiceResult implements Serializable {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @ApiModelProperty("预制发票或单据明细合并后明细和原明细关系Map")
    private Map<Long,List<ItemIdToAmountInfo>> mergedItemRelationMap = Maps.newHashMap();

    @ApiModelProperty("红冲原因")
    private String makingReason;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @ApiModelProperty("发票匹配列表")
    private List<SmartMatchedInvoice> invoiceMatchList;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @ApiModelProperty("智能匹配组合列表")
    private List<SmartMatchedInvoiceGroup> invoiceSmartMatchGroupList;

    @ApiModelProperty("是否已经处理完成")
    private int isDone = 0;

    @ApiModelProperty("已处理数据")
    private int processNum;

    @ApiModelProperty("总数")
    private int total;

    @ApiModelProperty("最新的消息处理时间戳")
    private Long msgTime;

    @ApiModelProperty("失败信息")
    private List<QueryRecommendDetailFailDto> detailFailList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SmartMatchedInvoice implements Serializable {
        @ApiModelProperty("发票id")
        private Long id;
        @ApiModelProperty("销方租户Id")
        private Long sellerGroupId;
        @ApiModelProperty("销方名称")
        private String sellerName;
        @ApiModelProperty("购方名称")
        private String purchaserName;
        @ApiModelProperty("购方租户Id")
        private Long purchaserGroupId;
        @ApiModelProperty("发票号码")
        private String invoiceNo;
        @ApiModelProperty("发票代码")
        private String invoiceCode;
        @ApiModelProperty("数电发票号码")
        private String allElectricInvoiceNo;
        @ApiModelProperty("国税发票来源")
        private String taxInvoiceSource;
        @ApiModelProperty("开票日期")
        private Date paperDrawDate;
        @ApiModelProperty("发票类型")
        private String invoiceType;
        @ApiModelProperty("红冲状态 0 - 正常  1-待红冲  2-待部分红冲 3-已红冲 4-已部分红冲 5-红冲票 10-不可申请红字信息表 ")
        private String redFlag;
        @ApiModelProperty("认证状态 0-默认 1-不可认证 2-未认证 3-认证中 4-认证成功 5-认证失败 6-认证异常 7-已转出")
        private String identifyStatus;
        private String authTaxPeriod;

        @ApiModelProperty("税额")
        private String taxAmount;
        @ApiModelProperty("不含税金额")
        private BigDecimal amountWithoutTax;
        @ApiModelProperty("含税金额")
        private BigDecimal amountWithTax;
        @ApiModelProperty("特殊发票标记  0-默认  1-通行费   2-成品油 3-区块链发票 4-机动车专票 ")
        private Integer specialInvoiceFlag;
        @ApiModelProperty("匹配度")
        private BigDecimal matchingDegree;
        @ApiModelProperty("消息编号")
        private Long msgSeq;

        @ApiModelProperty("消息处理时间戳")
        private Long msgTime;

        @ApiModelProperty("累计剩余可红冲不含税金额")
        private BigDecimal sumPositiveAmountWithoutTax;
        @ApiModelProperty("累计剩余可红冲税额")
        private BigDecimal sumPositiveTaxAmount;
        @ApiModelProperty("累计剩余可红冲含税金额")
        private BigDecimal sumPositiveAmountWithTax;
        @ApiModelProperty("剩余可红冲含税金额占比")
        private BigDecimal sumPositiveAmountWithTaxRatio;

        @ApiModelProperty("是否存在未开的红字确认单")
        private Boolean hasNotIssuedRedConfirmation;

        @ApiModelProperty("合并后明细和原明细关系Map")
        private Map<Long, List<ItemIdToAmountInfo>> mergedInvoiceItemRelationMap = Maps.newHashMap();

        @ApiModelProperty("匹配单据明细和发票明细存在关联性")
        private List<InvoiceItemIdWithBillItemIdRelationData> targetItemRelationList = Lists.newArrayList();

        @ApiModelProperty("匹配单据明细和发票明细存在关联性")
        private List<InvoiceItemIdWithBillItemIdRelationData> sourceItemRelationList = Lists.newArrayList();

        /**
         * 前端发票明细填充信息；后端在智能组合结果获取里也可使用
         */
        private List<InvoiceItemFillDto> invoiceItemFillDtoList = Lists.newArrayList();
        /**
         * 红冲原因（此字段不为空时，以此字段优先；否则取外层的makingReason字段）
         */
        private String makingReason;
        /**
         * 原始单据明细，和原始发票明细的金额关系
         */
        private List<OriginalRelation> originalRelationList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SmartMatchedInvoiceGroup implements Serializable {
        @ApiModelProperty("组合编号")
        private Integer groupNo;
        @ApiModelProperty("发票匹配列表")
        private List<SmartMatchedInvoice> invoiceMatchList;
        @ApiModelProperty("组合金额占比关系")
        @Deprecated
        private Map<Long, List<SmartMatchInvoiceResult.InvoiceItemIdWithBillItemIdRelationData>> recommendInvoiceTargetRelationMap;
        @ApiModelProperty("组合金额占比原关系")
        private Map<Long, List<SmartMatchInvoiceResult.InvoiceItemIdWithBillItemIdRelationData>> recommendInvoiceRelationMap;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ItemIdToAmountInfo implements Serializable {
        @ApiModelProperty("原明细Id")
        private Long sourceItemId;
        @ApiModelProperty("原明细金额")
        private BigDecimal amount;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MatchingInvoiceItem implements Serializable {
        @ApiModelProperty("发票Id")
        private Long invoiceId;
        @ApiModelProperty("明细Id")
        private Long invoiceItemId;
        @ApiModelProperty("货物代码")
        private String itemCode;
        @ApiModelProperty("itemName")
        private String itemName;

        @ApiModelProperty("税收分类编码")
        private String goodsTaxNo;
        @ApiModelProperty("规格型号")
        private String itemSpec;
        @ApiModelProperty("税率")
        private BigDecimal taxRate;

        @ApiModelProperty("不含税单价")
        private BigDecimal unitPrice;
        @ApiModelProperty("不含税金额")
        private BigDecimal amountWithTax;
        @ApiModelProperty("含税金额")
        private BigDecimal amountWithoutTax;
        @ApiModelProperty("数量")
        private BigDecimal quantity;
        @ApiModelProperty("数量单位")
        private String quantityUnit;
        @ApiModelProperty("剩余可红冲数量（扣除预申请）")
        private BigDecimal residueQuantity;
        @ApiModelProperty("剩余可红冲含税金额（扣除预申请，扣除按红冲比例计算的不可申请部分）")
        private BigDecimal residueAmountWithTax;
        @ApiModelProperty("剩余可红冲不含税金额（扣除预申请，扣除按红冲比例计算的不可申请部分）")
        private BigDecimal residueAmountWithoutTax;
        @ApiModelProperty("剩余可红冲单价（不扣除预申请）")
        private BigDecimal residueUnitPrice;

        @ApiModelProperty("根据红冲比例，计算不可红冲的含税金额")
        private BigDecimal forbidReverseAmountWithTax;
        @ApiModelProperty("根据红冲比例，计算不可红冲的不含税金额")
        private BigDecimal forbidReverseAmountWithoutTax;
        /**
         * 根据红冲比例，计算不可红冲的数量
         */
        private BigDecimal forbidReverseQuantity;

        @ApiModelProperty("明细行号")
        private Integer rowNum;
        @ApiModelProperty("折扣行标识")
        private String discountFlag;
        @ApiModelProperty("是否享受税收优惠政策0-不1-享受")
        private String taxPre;
        @ApiModelProperty("享受税收优惠政策内容")
        private String taxPreCon;
        @ApiModelProperty("零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率")
        private String zeroTax;

        @ApiModelProperty("单据Id")
        private Long billId;
        @ApiModelProperty("单据ItemId")
        private Long billItemId;
        @ApiModelProperty("行匹配得分")
        private BigDecimal matchingScore = BigDecimal.ZERO;
        @ApiModelProperty("行总分")
        private BigDecimal totalScore = BigDecimal.ZERO;
        @ApiModelProperty("行匹配度")
        private BigDecimal matchingDegree = BigDecimal.ZERO;
        @ApiModelProperty("是否推荐明细")
        private boolean isRecommendItem = false;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class InvoiceItemIdWithBillItemIdRelationData implements Serializable {
        @ApiModelProperty("合并后（或原）单据、预制发票明细ItemId")
        private Long itemId;
        @ApiModelProperty("合并后（或原）发票明细ItemId")
        private Long invoiceItemId;
        @ApiModelProperty("匹配的发票明细金额")
        private BigDecimal matchedAmount;
        @ApiModelProperty("表示这条明细是否是仅金额字段不一致，其他条件都一致的明细")
        private Boolean isRecommendItem = false;

    }

    /**
     * 发票明细前端填充信息对象
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class InvoiceItemFillDto implements Serializable {
        /**
         * 原发票明细ItemId
         */
        private Long invoiceItemId;
        /**
         * 表示这条明细是否是仅金额字段不一致，其他条件都一致的明细
         */
        private Boolean isRecommendItem = false;
        /**
         * 匹配的发票明细数量
         */
        private BigDecimal matchedQuantity;
        /**
         * 匹配的发票明细不含税金额
         */
        private BigDecimal matchedAmountWithoutTax;
        /**
         * 匹配的发票明细税额
         */
        private BigDecimal matchedTaxAmount;
        /**
         * 匹配的发票明细含税金额
         */
        private BigDecimal matchedAmountWithTax;
    }

    /**
     * 发票明细前端填充信息对象
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class OriginalRelation implements Serializable {
        /**
         * 原业务单明细id
         */
        private Long billItemId;
        /**
         * 原发票明细ItemId
         */
        private Long invoiceItemId;
        /**
         * 表示这条明细是否是仅金额字段不一致，其他条件都一致的明细
         */
        private Boolean isRecommendItem = false;
        /**
         * 匹配的发票明细数量
         */
        private BigDecimal matchedQuantity;
        /**
         * 匹配的发票明细不含税金额
         */
        private BigDecimal matchedAmountWithoutTax;
        /**
         * 匹配的发票明细税额
         */
        private BigDecimal matchedTaxAmount;
        /**
         * 匹配的发票明细含税金额
         */
        private BigDecimal matchedAmountWithTax;
    }
}
