package com.xforceplus.smart.match.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@ApiModel(description = "智能匹配任务信息")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SmartMatchTask implements Serializable {
    @ApiModelProperty("任务id")
    private Long taskId;

    @ApiModelProperty("匹配对象Id 业务单id 或 预制发票id")
    private Long matchId;

    @ApiModelProperty("任务状态 0-处理中 1-处理成功 2-处理失败")
    private Integer status;

    @ApiModelProperty("完成时间")
    private Date finishTime;
}
