package com.xforceplus.smart.match.invoice.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class UpdateInvoiceItemPreReverseAmountRequest implements Serializable {
    @ApiModelProperty("操作类型 1-增加 2-减少")
    private Integer operationType;
    private List<InvoiceAmountInfo> invoiceList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class InvoiceAmountInfo implements Serializable {
        private String invoiceNo;
        private String invoiceCode;
        private String allElectricInvoiceNo;
        private Long paperDrawDate;
        private List<ItemAmountInfo> itemList;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ItemAmountInfo implements Serializable {
        private Integer rowNum;
        private String cargoName;
        private String goodsTaxNo;
        private BigDecimal taxRate;
        private BigDecimal mergedQuantity;
        private BigDecimal mergedAmountWithoutTax;
        private BigDecimal mergedTaxAmount;
        private BigDecimal mergedAmountWithTax;
        private BigDecimal preQuantity;
        private BigDecimal preAmountWithoutTax;
        private BigDecimal preTaxAmount;
        private BigDecimal preAmountWithTax;
    }
}
