package com.xforceplus.phoenix.split.model;

import java.math.BigDecimal;
import java.util.Date;

public class PreInvoiceItem {

    /**
     * 预制发票id
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : pre_invoice_id
     */
    private Long preInvoiceId;

    /**
     * 税收分类编码
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : goods_tax_no
     */
    private String goodsTaxNo;

    /**
     * 货物或应税劳务名称
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : cargo_name
     */
    private String cargoName;

    /**
     * 货物或应税劳务代码
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : cargo_code
     */
    private String cargoCode;

    /**
     * 规格型号
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : item_spec
     */
    private String itemSpec;

    /**
     * 单价不含税
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : unit_price
     */
    private BigDecimal unitPrice;

    /**
     * 数量
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : quantity
     */
    private BigDecimal quantity;

    /**
     * 单位
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : quantity_unit
     */
    private String quantityUnit;

    /**
     * 税率
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : tax_rate
     */
    private BigDecimal taxRate;

    /**
     * 不含税金额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : amount_without_tax
     */
    private BigDecimal amountWithoutTax;

    /**
     * 税额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : tax_amount
     */
    private BigDecimal taxAmount;

    /**
     * 含税金额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : amount_with_tax
     */
    private BigDecimal amountWithTax;

    /**
     * 折扣率
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : discount_rate
     */
    private BigDecimal discountRate;

    /**
     * 折扣不含税金额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : discount_without_tax
     */
    private BigDecimal discountWithoutTax;

    /**
     * 折扣含税金额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : discount_with_tax
     */
    private BigDecimal discountWithTax;

    /**
     * 折扣税额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : discount_tax
     */
    private BigDecimal discountTax;

    /**
     * 浮动金额(调整的容差金额)
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : floating_amount
     */
    private BigDecimal floatingAmount;

    /**
     * 商品税目
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : tax_item
     */
    private String taxItem;

    /**
     * 编码版本号
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : goods_no_ver
     */
    private String goodsNoVer;

    /**
     * 是否享受税收优惠政策
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : tax_pre
     */
    private String taxPre;

    /**
     * 是否享受税收优惠政策
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : tax_pre_con
     */
    private String taxPreCon;

    /**
     * 零税率标识
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : zero_tax
     */
    private String zeroTax;

    /**
     * 扣除额
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : deduction
     */
    private BigDecimal deduction;

    /**
     * 扣除行标记
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : discount_flag
     */
    private String discountFlag;

    /**
     * 价格方式
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : price_method
     */
    private String priceMethod;

    /**
     * 是否打印单价数量
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : print_content_flag
     */
    private String printContentFlag;

    /**
     * 分类码
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : item_type_code
     */
    private String itemTypeCode;

    /**
     * 创建时间
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : create_time
     */
    private Date createTime;

    /**
     * 更新时间
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : update_time
     */
    private Date updateTime;

    /**
     * 创建用户id
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : create_user_id
     */
    private String createUserId;

    /**
     * 更新用户id
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : update_user_id
     */
    private String updateUserId;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext1
     */
    private String ext1;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext2
     */
    private String ext2;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext3
     */
    private String ext3;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext4
     */
    private String ext4;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext5
     */
    private String ext5;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext6
     */
    private String ext6;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext7
     */
    private String ext7;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext8
     */
    private String ext8;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext9
     */
    private String ext9;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext10
     */
    private String ext10;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext11
     */
    private String ext11;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext12
     */
    private String ext12;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext13
     */
    private String ext13;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext14
     */
    private String ext14;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext15
     */
    private String ext15;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext16
     */
    private String ext16;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext17
     */
    private String ext17;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext18
     */
    private String ext18;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext19
     */
    private String ext19;

    /**
     *
     * 表 : inv_seller_pre_invoice_item
     * 对应字段 : ext20
     */
    private String ext20;


    private int origin;

    private Long salesbillId;

    private Long salesbillItemId;

    private String salesbillNo;

    private String salesbillItemNo;

    private BigDecimal outterDiscountWithTax;

    private BigDecimal outterDiscountWithoutTax;

    private BigDecimal outterDiscountTax;

    private BigDecimal innerDiscountWithTax;

    private BigDecimal innerDiscountWithoutTax;

    private BigDecimal innerDiscountTax;

    private BigDecimal innerPrepayAmountWithTax;

    private BigDecimal innerPrepayAmountWithoutTax;

    private BigDecimal innerPrepayAmountTax;

    private BigDecimal outterPrepayAmountWithTax;

    private BigDecimal outterPrepayAmountWithoutTax;

    private BigDecimal outterPrepayAmountTax;

    public BigDecimal getOutterDiscountWithTax() {
        return outterDiscountWithTax;
    }

    public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
        this.outterDiscountWithTax = outterDiscountWithTax;
    }

    public BigDecimal getOutterDiscountWithoutTax() {
        return outterDiscountWithoutTax;
    }

    public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
        this.outterDiscountWithoutTax = outterDiscountWithoutTax;
    }

    public BigDecimal getOutterDiscountTax() {
        return outterDiscountTax;
    }

    public void setOutterDiscountTax(BigDecimal outterDiscountTax) {
        this.outterDiscountTax = outterDiscountTax;
    }

    public BigDecimal getInnerDiscountWithTax() {
        return innerDiscountWithTax;
    }

    public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
        this.innerDiscountWithTax = innerDiscountWithTax;
    }

    public BigDecimal getInnerDiscountWithoutTax() {
        return innerDiscountWithoutTax;
    }

    public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
        this.innerDiscountWithoutTax = innerDiscountWithoutTax;
    }

    public BigDecimal getInnerDiscountTax() {
        return innerDiscountTax;
    }

    public void setInnerDiscountTax(BigDecimal innerDiscountTax) {
        this.innerDiscountTax = innerDiscountTax;
    }

    public BigDecimal getInnerPrepayAmountWithTax() {
        return innerPrepayAmountWithTax;
    }

    public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
        this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
    }

    public BigDecimal getInnerPrepayAmountWithoutTax() {
        return innerPrepayAmountWithoutTax;
    }

    public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
        this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
    }

    public BigDecimal getInnerPrepayAmountTax() {
        return innerPrepayAmountTax;
    }

    public void setInnerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
        this.innerPrepayAmountTax = innerPrepayAmountTax;
    }

    public BigDecimal getOutterPrepayAmountWithTax() {
        return outterPrepayAmountWithTax;
    }

    public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
        this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
    }

    public BigDecimal getOutterPrepayAmountWithoutTax() {
        return outterPrepayAmountWithoutTax;
    }

    public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
        this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
    }

    public BigDecimal getOutterPrepayAmountTax() {
        return outterPrepayAmountTax;
    }

    public void setOutterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
        this.outterPrepayAmountTax = outterPrepayAmountTax;
    }




    public Long getPreInvoiceId() {
        return preInvoiceId;
    }

    public void setPreInvoiceId(Long preInvoiceId) {
        this.preInvoiceId = preInvoiceId;
    }

    public String getGoodsTaxNo() {
        return goodsTaxNo;
    }

    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getItemSpec() {
        return itemSpec;
    }

    public void setItemSpec(String itemSpec) {
        this.itemSpec = itemSpec;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getQuantityUnit() {
        return quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    public BigDecimal getDiscountWithoutTax() {
        return discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    public BigDecimal getDiscountWithTax() {
        return discountWithTax;
    }

    public void setDiscountWithTax(BigDecimal discountWithTax) {
        this.discountWithTax = discountWithTax;
    }

    public BigDecimal getDiscountTax() {
        return discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    public BigDecimal getFloatingAmount() {
        return floatingAmount;
    }

    public void setFloatingAmount(BigDecimal floatingAmount) {
        this.floatingAmount = floatingAmount;
    }

    public String getTaxItem() {
        return taxItem;
    }

    public void setTaxItem(String taxItem) {
        this.taxItem = taxItem;
    }

    public String getGoodsNoVer() {
        return goodsNoVer;
    }

    public void setGoodsNoVer(String goodsNoVer) {
        this.goodsNoVer = goodsNoVer;
    }

    public String getTaxPre() {
        return taxPre;
    }

    public void setTaxPre(String taxPre) {
        this.taxPre = taxPre;
    }

    public String getTaxPreCon() {
        return taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    public String getZeroTax() {
        return zeroTax;
    }

    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
    }

    public BigDecimal getDeduction() {
        return deduction;
    }

    public void setDeduction(BigDecimal deduction) {
        this.deduction = deduction;
    }

    public String getDiscountFlag() {
        return discountFlag;
    }

    public void setDiscountFlag(String discountFlag) {
        this.discountFlag = discountFlag;
    }

    public String getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(String priceMethod) {
        this.priceMethod = priceMethod;
    }

    public String getPrintContentFlag() {
        return printContentFlag;
    }

    public void setPrintContentFlag(String printContentFlag) {
        this.printContentFlag = printContentFlag;
    }

    public String getItemTypeCode() {
        return itemTypeCode;
    }

    public void setItemTypeCode(String itemTypeCode) {
        this.itemTypeCode = itemTypeCode;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    public void setSalesbillId(Long salesbillId) {
        this.salesbillId = salesbillId;
    }

    public void setSalesbillItemId(Long salesbillItemId) {
        this.salesbillItemId = salesbillItemId;
    }

    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    public String getSalesbillItemNo() {
        return salesbillItemNo;
    }

    public void setSalesbillItemNo(String salesbillItemNo) {
        this.salesbillItemNo = salesbillItemNo;
    }

    public int getOrigin() {
        return origin;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public Long getSalesbillId() {
        return salesbillId;
    }

    public Long getSalesbillItemId() {
        return salesbillItemId;
    }

    @Override
    public String toString() {
        return "PreInvoiceItem{" +
                "preInvoiceId=" + preInvoiceId +
                ", goodsTaxNo='" + goodsTaxNo + '\'' +
                ", cargoName='" + cargoName + '\'' +
                ", cargoCode='" + cargoCode + '\'' +
                ", itemSpec='" + itemSpec + '\'' +
                ", unitPrice=" + unitPrice +
                ", quantity=" + quantity +
                ", quantityUnit='" + quantityUnit + '\'' +
                ", taxRate=" + taxRate +
                ", amountWithoutTax=" + amountWithoutTax +
                ", taxAmount=" + taxAmount +
                ", amountWithTax=" + amountWithTax +
                ", discountRate=" + discountRate +
                ", discountWithoutTax=" + discountWithoutTax +
                ", discountWithTax=" + discountWithTax +
                ", discountTax=" + discountTax +
                ", floatingAmount=" + floatingAmount +
                ", taxItem='" + taxItem + '\'' +
                ", goodsNoVer='" + goodsNoVer + '\'' +
                ", taxPre='" + taxPre + '\'' +
                ", taxPreCon='" + taxPreCon + '\'' +
                ", zeroTax='" + zeroTax + '\'' +
                ", deduction=" + deduction +
                ", discountFlag='" + discountFlag + '\'' +
                ", priceMethod='" + priceMethod + '\'' +
                ", printContentFlag='" + printContentFlag + '\'' +
                ", itemTypeCode='" + itemTypeCode + '\'' +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", createUserId='" + createUserId + '\'' +
                ", updateUserId='" + updateUserId + '\'' +
                ", ext1='" + ext1 + '\'' +
                ", ext2='" + ext2 + '\'' +
                ", ext3='" + ext3 + '\'' +
                ", ext4='" + ext4 + '\'' +
                ", ext5='" + ext5 + '\'' +
                ", ext6='" + ext6 + '\'' +
                ", ext7='" + ext7 + '\'' +
                ", ext8='" + ext8 + '\'' +
                ", ext9='" + ext9 + '\'' +
                ", ext10='" + ext10 + '\'' +
                ", ext11='" + ext11 + '\'' +
                ", ext12='" + ext12 + '\'' +
                ", ext13='" + ext13 + '\'' +
                ", ext14='" + ext14 + '\'' +
                ", ext15='" + ext15 + '\'' +
                ", ext16='" + ext16 + '\'' +
                ", ext17='" + ext17 + '\'' +
                ", ext18='" + ext18 + '\'' +
                ", ext19='" + ext19 + '\'' +
                ", ext20='" + ext20 + '\'' +
                ", origin=" + origin +
                ", salesbillId=" + salesbillId +
                ", salesbillItemId=" + salesbillItemId +
                ", salesbillNo='" + salesbillNo + '\'' +
                ", salesbillItemNo='" + salesbillItemNo + '\'' +
                ", outterDiscountWithTax=" + outterDiscountWithTax +
                ", outterDiscountWithoutTax=" + outterDiscountWithoutTax +
                ", outterDiscountTax=" + outterDiscountTax +
                ", innerDiscountWithTax=" + innerDiscountWithTax +
                ", innerDiscountWithoutTax=" + innerDiscountWithoutTax +
                ", innerDiscountTax=" + innerDiscountTax +
                ", innerPrepayAmountWithTax=" + innerPrepayAmountWithTax +
                ", innerPrepayAmountWithoutTax=" + innerPrepayAmountWithoutTax +
                ", innerPrepayAmountTax=" + innerPrepayAmountTax +
                ", outterPrepayAmountWithTax=" + outterPrepayAmountWithTax +
                ", outterPrepayAmountWithoutTax=" + outterPrepayAmountWithoutTax +
                ", outterPrepayAmountTax=" + outterPrepayAmountTax +
                '}';
    }
}
