package com.xforceplus.phoenix.split.model;

import java.math.BigDecimal;
import java.util.Date;

public class PreInvoiceMain{
    /**
     * 批次号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : batch_no
     */
    private Long batchNo;

    /**
     * 系统外批次号  默认batch_no的值
     * 表 : inv_seller_pre_invoice
     * 对应字段 : out_batch_no
     */
    private Long outBatchNo;

    /**
     * 用户Id 下发数据需要  由属地直接传过来
     * 表 : inv_seller_pre_invoice
     * 对应字段 : customer_no
     */
    private String customerNo;

    /**
     * 系统来源  下发数据需要  由属地直接传过来
     * 表 : inv_seller_pre_invoice
     * 对应字段 : system_orig
     */
    private String systemOrig;

    /**
     * 购方集团id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_tenant_id
     */
    private Long purchaserTenantId;

    /**
     * 购方租户ID
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_group_id
     */
    private Long purchaserGroupId;

    /**
     * 购方公司id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_id
     */
    private Long purchaserId;

    /**
     * 购方编号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_no
     */
    private String purchaserNo;

    /**
     * 购方名称
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_name
     */
    private String purchaserName;

    /**
     * 购方税号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_tax_no
     */
    private String purchaserTaxNo;

    /**
     * 购方电话
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_tel
     */
    private String purchaserTel;

    /**
     * 购方地址
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_address
     */
    private String purchaserAddress;

    /**
     * 购方开户行
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_bank_name
     */
    private String purchaserBankName;

    /**
     * 购方银行账号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_bank_account
     */
    private String purchaserBankAccount;

    /**
     * 销方集团id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_tenant_id
     */
    private Long sellerTenantId;

    /**
     * 销方租户id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_group_id
     */
    private Long sellerGroupId;

    /**
     * 销方编号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_no
     */
    private String sellerNo;

    /**
     * 销方税号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_tax_no
     */
    private String sellerTaxNo;

    /**
     * 销方名称
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_name
     */
    private String sellerName;

    /**
     * 销方电话
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_tel
     */
    private String sellerTel;

    /**
     * 销方地址
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_address
     */
    private String sellerAddress;

    /**
     * 销方开户行
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_bank_name
     */
    private String sellerBankName;

    /**
     * 销方银行账号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_bank_account
     */
    private String sellerBankAccount;

    /**
     * 销方公司id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_id
     */
    private Long sellerId;

    /**
     * 发票类型
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoice_type
     */
    private String invoiceType;

    /**
     * 业务单据类型
     * 表 : inv_seller_pre_invoice
     * 对应字段 : business_bill_type
     */
    private String businessBillType;

    /**
     * 单据类型
     * 表 : inv_seller_pre_invoice
     * 对应字段 : salesbill_type
     */
    private String salesbillType;

    /**
     * 发票号码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoice_no
     */
    private String invoiceNo;

    /**
     * 发票代码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoice_code
     */
    private String invoiceCode;

    /**
     * 开票日期
     * 表 : inv_seller_pre_invoice
     * 对应字段 : paper_draw_date
     */
    private String paperDrawDate;

    /**
     * 机器编码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : machine_code
     */
    private String machineCode;

    /**
     * 校验码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : check_code
     */
    private String checkCode;

    /**
     * 不含税金额
     * 表 : inv_seller_pre_invoice
     * 对应字段 : amount_without_tax
     */
    private BigDecimal amountWithoutTax;

    /**
     * 税额
     * 表 : inv_seller_pre_invoice
     * 对应字段 : tax_amount
     */
    private BigDecimal taxAmount;

    /**
     * 价税合计
     * 表 : inv_seller_pre_invoice
     * 对应字段 : amount_with_tax
     */
    private BigDecimal amountWithTax;

    /**
     * 备注
     * 表 : inv_seller_pre_invoice
     * 对应字段 : remark
     */
    private String remark;

    /**
     * 收款人
     * 表 : inv_seller_pre_invoice
     * 对应字段 : cashier_name
     */
    private String cashierName;

    /**
     * 复核人
     * 表 : inv_seller_pre_invoice
     * 对应字段 : checker_name
     */
    private String checkerName;

    /**
     * 开票人
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoicer_name
     */
    private String invoicerName;

    /**
     * 电子签章
     * 表 : inv_seller_pre_invoice
     * 对应字段 : electronic_signature
     */
    private String electronicSignature;

    /**
     * 预制发票状态，0=删除，1=待确认,2=有变更,3=购方确认中(销方待确认),4=销方确认中(购方待确认),5=待开票,6=开票中,7已开票
     * 表 : inv_seller_pre_invoice
     * 对应字段 : status
     */
    private Byte status;

    /**
     * 预制发票是否锁定,0=未锁,1=锁定
     * 表 : inv_seller_pre_invoice
     * 对应字段 : is_lock
     */
    private Byte isLock;

    /**
     * 规则id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : rule_id
     */
    private Long ruleId;

    /**
     * 组织机构id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : sys_org_id
     */
    private Long sysOrgId;

    /**
     * 原发票号码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : origin_invoice_no
     */
    private String originInvoiceNo;

    /**
     * 原发票代码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : origin_invoice_code
     */
    private String originInvoiceCode;

    /**
     * 红字信息表编号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : red_notification_no
     */
    private String redNotificationNo;

    /**
     * 接收方邮箱
     * 表 : inv_seller_pre_invoice
     * 对应字段 : receive_user_email
     */
    private String receiveUserEmail;

    /**
     * 接收方电话
     * 表 : inv_seller_pre_invoice
     * 对应字段 : receive_user_tel
     */
    private String receiveUserTel;

    /**
     * 发票签名 用于抽取匹配
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoice_signature
     */
    private String invoiceSignature;

    /**
     * 创建时间
     * 表 : inv_seller_pre_invoice
     * 对应字段 : create_time
     */
    private Date createTime;

    /**
     * 更新时间
     * 表 : inv_seller_pre_invoice
     * 对应字段 : update_time
     */
    private Date updateTime;

    /**
     * 更新用户id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : create_user_id
     */
    private String createUserId;

    /**
     * 更新用户id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : update_user_id
     */
    private String updateUserId;

    /**
     * 打印内容标志 (0-打印单价和数量, 1-不打印单价和数量)
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : display_price_quality
     */
    private Byte displayPriceQuality;

    /**
     * 销货清单文件打印标志 (0-否, 1-是)
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : sale_list_file_flag
     */
    private Byte saleListFileFlag;

    /**
     * 版式文件版本 (0-使用5行模版, 1-使用8行模版)(仅服务器开电票使用)
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : template_version
     */
    private Byte templateVersion;

    /**
     * 销货清单备注
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : list_goods_name
     */
    private String listGoodsName;

    /**
     * 特殊发票标记  0-默认  1-通行费   2-成品油
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : special_invoice_flag
     */
    private String specialInvoiceFlag;
    /**
     *
     * 税率，明细税率去重后逗号分隔
     */
    private String taxRate;

    /**
     * 扩展字段1
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext1
     */
    private String ext1;

    /**
     * 扩展字段2
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext2
     */
    private String ext2;

    /**
     * 扩展字段3
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext3
     */
    private String ext3;

    /**
     * 扩展字段4
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext4
     */
    private String ext4;

    /**
     * 扩展字段5
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext5
     */
    private String ext5;

    /**
     * 扩展字段6
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext6
     */
    private String ext6;

    /**
     * 扩展字段7
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext7
     */
    private String ext7;

    /**
     * 扩展字段8
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext8
     */
    private String ext8;

    /**
     * 扩展字段9
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext9
     */
    private String ext9;

    /**
     * 扩展字段10
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext10
     */
    private String ext10;

    /**
     * 扩展字段11
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext11
     */
    private String ext11;

    /**
     * 扩展字段12
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext12
     */
    private String ext12;

    /**
     * 扩展字段13
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext13
     */
    private String ext13;

    /**
     * 扩展字段14
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext14
     */
    private String ext14;

    /**
     * 扩展字段15
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext15
     */
    private String ext15;

    /**
     * 扩展字段16
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext16
     */
    private String ext16;

    /**
     * 扩展字段17
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext17
     */
    private String ext17;

    /**
     * 扩展字段18
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext18
     */
    private String ext18;

    /**
     * 扩展字段19
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext19
     */
    private String ext19;

    /**
     * 扩展字段20
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext20
     */
    private String ext20;

    /**
     * 扩展字段21
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext21
     */
    private String ext21;

    /**
     * 扩展字段22
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext22
     */
    private String ext22;

    /**
     * 扩展字段23
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext23
     */
    private String ext23;

    /**
     * 扩展字段24
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext24
     */
    private String ext24;

    /**
     * 扩展字段25
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext25
     */
    private String ext25;

    /**
     * 业务单号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : salesbill_no
     */
    private String salesbillNo;

    public String getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    public Long getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    public Long getOutBatchNo() {
        return outBatchNo;
    }

    public void setOutBatchNo(Long outBatchNo) {
        this.outBatchNo = outBatchNo;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    public Long getPurchaserTenantId() {
        return purchaserTenantId;
    }

    public void setPurchaserTenantId(Long purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }

    public Long getPurchaserGroupId() {
        return purchaserGroupId;
    }

    public void setPurchaserGroupId(Long purchaserGroupId) {
        this.purchaserGroupId = purchaserGroupId;
    }

    public Long getPurchaserId() {
        return purchaserId;
    }

    public void setPurchaserId(Long purchaserId) {
        this.purchaserId = purchaserId;
    }

    public String getPurchaserNo() {
        return purchaserNo;
    }

    public void setPurchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    public String getPurchaserTel() {
        return purchaserTel;
    }

    public void setPurchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
    }

    public String getPurchaserAddress() {
        return purchaserAddress;
    }

    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
    }

    public String getPurchaserBankName() {
        return purchaserBankName;
    }

    public void setPurchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
    }

    public String getPurchaserBankAccount() {
        return purchaserBankAccount;
    }

    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
    }

    public Long getSellerTenantId() {
        return sellerTenantId;
    }

    public void setSellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    public Long getSellerGroupId() {
        return sellerGroupId;
    }

    public void setSellerGroupId(Long sellerGroupId) {
        this.sellerGroupId = sellerGroupId;
    }

    public String getSellerNo() {
        return sellerNo;
    }

    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
    }

    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getSellerTel() {
        return sellerTel;
    }

    public void setSellerTel(String sellerTel) {
        this.sellerTel = sellerTel;
    }

    public String getSellerAddress() {
        return sellerAddress;
    }

    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
    }

    public String getSellerBankName() {
        return sellerBankName;
    }

    public void setSellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName;
    }

    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getBusinessBillType() {
        return businessBillType;
    }

    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
    }

    public String getSalesbillType() {
        return salesbillType;
    }

    public void setSalesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getPaperDrawDate() {
        return paperDrawDate;
    }

    public void setPaperDrawDate(String paperDrawDate) {
        this.paperDrawDate = paperDrawDate;
    }

    public String getMachineCode() {
        return machineCode;
    }

    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCashierName() {
        return cashierName;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    public String getCheckerName() {
        return checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }

    public String getInvoicerName() {
        return invoicerName;
    }

    public void setInvoicerName(String invoicerName) {
        this.invoicerName = invoicerName;
    }

    public String getElectronicSignature() {
        return electronicSignature;
    }

    public void setElectronicSignature(String electronicSignature) {
        this.electronicSignature = electronicSignature;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Byte getIsLock() {
        return isLock;
    }

    public void setIsLock(Byte isLock) {
        this.isLock = isLock;
    }

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public Long getSysOrgId() {
        return sysOrgId;
    }

    public void setSysOrgId(Long sysOrgId) {
        this.sysOrgId = sysOrgId;
    }

    public String getOriginInvoiceNo() {
        return originInvoiceNo;
    }

    public void setOriginInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo;
    }

    public String getOriginInvoiceCode() {
        return originInvoiceCode;
    }

    public void setOriginInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode;
    }

    public String getRedNotificationNo() {
        return redNotificationNo;
    }

    public void setRedNotificationNo(String redNotificationNo) {
        this.redNotificationNo = redNotificationNo;
    }

    public String getReceiveUserEmail() {
        return receiveUserEmail;
    }

    public void setReceiveUserEmail(String receiveUserEmail) {
        this.receiveUserEmail = receiveUserEmail;
    }

    public String getReceiveUserTel() {
        return receiveUserTel;
    }

    public void setReceiveUserTel(String receiveUserTel) {
        this.receiveUserTel = receiveUserTel;
    }

    public String getInvoiceSignature() {
        return invoiceSignature;
    }

    public void setInvoiceSignature(String invoiceSignature) {
        this.invoiceSignature = invoiceSignature;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    public String getExt21() {
        return ext21;
    }

    public void setExt21(String ext21) {
        this.ext21 = ext21;
    }

    public String getExt22() {
        return ext22;
    }

    public void setExt22(String ext22) {
        this.ext22 = ext22;
    }

    public String getExt23() {
        return ext23;
    }

    public void setExt23(String ext23) {
        this.ext23 = ext23;
    }

    public String getExt24() {
        return ext24;
    }

    public void setExt24(String ext24) {
        this.ext24 = ext24;
    }

    public String getExt25() {
        return ext25;
    }

    public void setExt25(String ext25) {
        this.ext25 = ext25;
    }

    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    public Byte getDisplayPriceQuality() {
        return displayPriceQuality;
    }

    public void setDisplayPriceQuality(Byte displayPriceQuality) {
        this.displayPriceQuality = displayPriceQuality;
    }

    public Byte getSaleListFileFlag() {
        return saleListFileFlag;
    }

    public void setSaleListFileFlag(Byte saleListFileFlag) {
        this.saleListFileFlag = saleListFileFlag;
    }

    public Byte getTemplateVersion() {
        return templateVersion;
    }

    public void setTemplateVersion(Byte templateVersion) {
        this.templateVersion = templateVersion;
    }

    public String getListGoodsName() {
        return listGoodsName;
    }

    public void setListGoodsName(String listGoodsName) {
        this.listGoodsName = listGoodsName;
    }

    public String getSpecialInvoiceFlag() {
        return specialInvoiceFlag;
    }

    public void setSpecialInvoiceFlag(String specialInvoiceFlag) {
        this.specialInvoiceFlag = specialInvoiceFlag;
    }


    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("PreInvoiceMain{");
        sb.append("batchNo=").append(batchNo);
        sb.append(", outBatchNo=").append(outBatchNo);
        sb.append(", customerNo='").append(customerNo).append('\'');
        sb.append(", systemOrig='").append(systemOrig).append('\'');
        sb.append(", purchaserTenantId=").append(purchaserTenantId);
        sb.append(", purchaserGroupId=").append(purchaserGroupId);
        sb.append(", purchaserId=").append(purchaserId);
        sb.append(", purchaserNo='").append(purchaserNo).append('\'');
        sb.append(", purchaserName='").append(purchaserName).append('\'');
        sb.append(", purchaserTaxNo='").append(purchaserTaxNo).append('\'');
        sb.append(", purchaserTel='").append(purchaserTel).append('\'');
        sb.append(", purchaserAddress='").append(purchaserAddress).append('\'');
        sb.append(", purchaserBankName='").append(purchaserBankName).append('\'');
        sb.append(", purchaserBankAccount='").append(purchaserBankAccount).append('\'');
        sb.append(", sellerTenantId=").append(sellerTenantId);
        sb.append(", sellerGroupId=").append(sellerGroupId);
        sb.append(", sellerNo='").append(sellerNo).append('\'');
        sb.append(", sellerTaxNo='").append(sellerTaxNo).append('\'');
        sb.append(", sellerName='").append(sellerName).append('\'');
        sb.append(", sellerTel='").append(sellerTel).append('\'');
        sb.append(", sellerAddress='").append(sellerAddress).append('\'');
        sb.append(", sellerBankName='").append(sellerBankName).append('\'');
        sb.append(", sellerBankAccount='").append(sellerBankAccount).append('\'');
        sb.append(", sellerId=").append(sellerId);
        sb.append(", invoiceType='").append(invoiceType).append('\'');
        sb.append(", businessBillType='").append(businessBillType).append('\'');
        sb.append(", salesbillType='").append(salesbillType).append('\'');
        sb.append(", invoiceNo='").append(invoiceNo).append('\'');
        sb.append(", invoiceCode='").append(invoiceCode).append('\'');
        sb.append(", paperDrawDate='").append(paperDrawDate).append('\'');
        sb.append(", machineCode='").append(machineCode).append('\'');
        sb.append(", checkCode='").append(checkCode).append('\'');
        sb.append(", amountWithoutTax=").append(amountWithoutTax);
        sb.append(", taxAmount=").append(taxAmount);
        sb.append(", amountWithTax=").append(amountWithTax);
        sb.append(", remark='").append(remark).append('\'');
        sb.append(", cashierName='").append(cashierName).append('\'');
        sb.append(", checkerName='").append(checkerName).append('\'');
        sb.append(", invoicerName='").append(invoicerName).append('\'');
        sb.append(", electronicSignature='").append(electronicSignature).append('\'');
        sb.append(", status=").append(status);
        sb.append(", isLock=").append(isLock);
        sb.append(", ruleId=").append(ruleId);
        sb.append(", sysOrgId=").append(sysOrgId);
        sb.append(", originInvoiceNo='").append(originInvoiceNo).append('\'');
        sb.append(", originInvoiceCode='").append(originInvoiceCode).append('\'');
        sb.append(", redNotificationNo='").append(redNotificationNo).append('\'');
        sb.append(", receiveUserEmail='").append(receiveUserEmail).append('\'');
        sb.append(", receiveUserTel='").append(receiveUserTel).append('\'');
        sb.append(", invoiceSignature='").append(invoiceSignature).append('\'');
        sb.append(", createTime=").append(createTime);
        sb.append(", updateTime=").append(updateTime);
        sb.append(", createUserId='").append(createUserId).append('\'');
        sb.append(", updateUserId='").append(updateUserId).append('\'');
        sb.append(", displayPriceQuality=").append(displayPriceQuality);
        sb.append(", saleListFileFlag=").append(saleListFileFlag);
        sb.append(", templateVersion=").append(templateVersion);
        sb.append(", listGoodsName='").append(listGoodsName).append('\'');
        sb.append(", specialInvoiceFlag='").append(specialInvoiceFlag).append('\'');
        sb.append(", taxRate='").append(taxRate).append('\'');
        sb.append(", ext1='").append(ext1).append('\'');
        sb.append(", ext2='").append(ext2).append('\'');
        sb.append(", ext3='").append(ext3).append('\'');
        sb.append(", ext4='").append(ext4).append('\'');
        sb.append(", ext5='").append(ext5).append('\'');
        sb.append(", ext6='").append(ext6).append('\'');
        sb.append(", ext7='").append(ext7).append('\'');
        sb.append(", ext8='").append(ext8).append('\'');
        sb.append(", ext9='").append(ext9).append('\'');
        sb.append(", ext10='").append(ext10).append('\'');
        sb.append(", ext11='").append(ext11).append('\'');
        sb.append(", ext12='").append(ext12).append('\'');
        sb.append(", ext13='").append(ext13).append('\'');
        sb.append(", ext14='").append(ext14).append('\'');
        sb.append(", ext15='").append(ext15).append('\'');
        sb.append(", ext16='").append(ext16).append('\'');
        sb.append(", ext17='").append(ext17).append('\'');
        sb.append(", ext18='").append(ext18).append('\'');
        sb.append(", ext19='").append(ext19).append('\'');
        sb.append(", ext20='").append(ext20).append('\'');
        sb.append(", ext21='").append(ext21).append('\'');
        sb.append(", ext22='").append(ext22).append('\'');
        sb.append(", ext23='").append(ext23).append('\'');
        sb.append(", ext24='").append(ext24).append('\'');
        sb.append(", ext25='").append(ext25).append('\'');
        sb.append(", salesbillNo='").append(salesbillNo).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
