package com.xforceplus.phoenix.split.model;

/**
 * 价格方式
 */
public enum PriceMethod {
    WITH_TAX(1), WITHOUT_TAX(0);

    private int value;


    PriceMethod(int value) {
        this.value = value;
    }


    public static PriceMethod value(Integer value) {
        for (PriceMethod priceMethod : PriceMethod.values()) {
            if (priceMethod.value == value) {
                return priceMethod;
            }
        }
        throw new IllegalArgumentException(String.format("value = %s is illegal for PriceMethod", value));
    }
}
