package com.xforceplus.phoenix.split.model;

import com.alibaba.fastjson.JSON;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * 拆票规则
 */
public class SplitRule {

    //拆票限额
    @NotNull(message = "拆票限额不能为空")
    private BigDecimal invoiceLimit;

    //可拆票字段
    private List<String> splitFiledList;

    //设备类型
    private String taxDeviceType;

    //明细顺序
    @NotNull(message = "明细顺序不能为空")
    private String itemSort;

    //销货清单最大行数
    private Integer salesListMaxRow;

    //单价数量选项
    private String unitPriceAmountOps;

    //金额拆分规则
    @NotNull(message = "金额拆分规则不能为空")
    private String amountSplitRule;

    //是否支持整形
    private boolean integerOps;

    //发票票面明细最大数
    private Integer invoiceItemMaxRow;

    //折扣模式
    private String discountMode;

    //销货清单选项
    @NotNull(message = "销货清单选项不能为空")
    private String saleListOption;

    //发票规格
    private String invoiceSpec;

    //发票类型
    private String invoiceType;

    //价格方式
    private PriceMethod priceMethod;

    //规则Id
    @NotNull(message = "规则Id不能为空")
    private Long ruleId;

    //补充备注
    private String extRemark;

    //备注列表元数据
    private List<RemarkFieldMetadata> remarkFiledMetadataBeanList;

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public String getExtRemark() {
        return extRemark;
    }

    public void setExtRemark(String extRemark) {
        this.extRemark = extRemark;
    }

    public List<RemarkFieldMetadata> getRemarkFiledMetadataBeanList() {
        return remarkFiledMetadataBeanList;
    }

    public void setRemarkFiledMetadataBeanList(List<RemarkFieldMetadata> remarkFiledMetadataBeanList) {
        this.remarkFiledMetadataBeanList = remarkFiledMetadataBeanList;
    }

    public BigDecimal getInvoiceLimit() {
        return invoiceLimit;
    }

    public void setInvoiceLimit(BigDecimal invoiceLimit) {
        this.invoiceLimit = invoiceLimit;
    }

    public List<String> getSplitFiledList() {
        return splitFiledList;
    }

    public void setSplitFiledList(List<String> splitFiledList) {
        this.splitFiledList = splitFiledList;
    }

    public String getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceType(String taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    public String getItemSort() {
        return itemSort;
    }

    public void setItemSort(String itemSort) {
        this.itemSort = itemSort;
    }

    public Integer getSalesListMaxRow() {
        return salesListMaxRow;
    }

    public void setSalesListMaxRow(Integer salesListMaxRow) {
        this.salesListMaxRow = salesListMaxRow;
    }

    public String getUnitPriceAmountOps() {
        return unitPriceAmountOps;
    }

    public void setUnitPriceAmountOps(String unitPriceAmountOps) {
        this.unitPriceAmountOps = unitPriceAmountOps;
    }

    public String getAmountSplitRule() {
        return amountSplitRule;
    }

    public void setAmountSplitRule(String amountSplitRule) {
        this.amountSplitRule = amountSplitRule;
    }

    public boolean isIntegerOps() {
        return integerOps;
    }

    public void setIntegerOps(boolean integerOps) {
        this.integerOps = integerOps;
    }

    public Integer getInvoiceItemMaxRow() {
        return invoiceItemMaxRow;
    }

    public void setInvoiceItemMaxRow(Integer invoiceItemMaxRow) {
        this.invoiceItemMaxRow = invoiceItemMaxRow;
    }


    public String getDiscountMode() {
        return discountMode;
    }

    public void setDiscountMode(String discountMode) {
        this.discountMode = discountMode;
    }

    public String getSaleListOption() {
        return saleListOption;
    }

    public void setSaleListOption(String saleListOption) {
        this.saleListOption = saleListOption;
    }

    public String getInvoiceSpec() {
        return invoiceSpec;
    }

    public void setInvoiceSpec(String invoiceSpec) {
        this.invoiceSpec = invoiceSpec;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public PriceMethod getPriceMethod() {
        return priceMethod;
    }

    public void setPriceMethod(PriceMethod priceMethod) {
        this.priceMethod = priceMethod;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
