package com.xforceplus.phoenix.split.api;

import com.xforceplus.phoenix.split.model.CreatePreInvoiceParam;
import com.xforceplus.phoenix.split.model.CreatePreInvoiceResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "pre_invoice", description = "the pre invoice generate API")
public interface PreInvoiceGenerateApi {

    @ApiOperation(value = "发送拆票请求", notes = "", response = CreatePreInvoiceResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"PreInvoiceGenerateApi"})
    @RequestMapping(value = "/preInvoice/sendMsg", produces = {"application/json"}, method = RequestMethod.POST)
    CreatePreInvoiceResponse sendMsg(@ApiParam(required = true, value = "单据规则信息") @RequestBody CreatePreInvoiceParam createPreInvoiceParam);

}
