package com.xforceplus.phoenix.split.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel
public class CreatePreInvoiceParam {

    @ApiModelProperty("单据信息")
    @NotNull(message = "单据信息不能为空")
    @Valid
    private BillInfo billInfo;

    @ApiModelProperty("规则信息")
    @NotNull(message = "规则信息不能为空")
    @Valid
    private SplitRule rule;

    public BillInfo getBillInfo() {
        return billInfo;
    }

    public void setBillInfo(BillInfo billInfo) {
        this.billInfo = billInfo;
    }

    public SplitRule getRule() {
        return rule;
    }

    public void setRule(SplitRule rule) {
        this.rule = rule;
    }

    @Override
    public String toString() {
        return "CreatePreInvoiceParam{" +
                "billInfo=" + billInfo +
                ", rule=" + rule +
                '}';
    }
}
