package com.xforceplus.phoenix.split.model;

import java.math.BigDecimal;
import java.util.Date;

public class PreInvoiceMain{
    /**
     * 批次号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : batch_no
     */
    private Long batchNo;

    /**
     * 业务单号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : salesbill_no
     */
    private String salesbillNo;

    /**
     * 业务单号Id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : salesbill_id
     */
    private String salesbillId;


    /**
     * 系统外批次号  默认batch_no的值
     * 表 : inv_seller_pre_invoice
     * 对应字段 : out_batch_no
     */
    private Long outBatchNo;

    /**
     * 用户Id 下发数据需要  由属地直接传过来
     * 表 : inv_seller_pre_invoice
     * 对应字段 : customer_no
     */
    private String customerNo;

    /**
     * 发票号码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoice_no
     */
    private String invoiceNo;

    /**
     * 发票代码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoice_code
     */
    private String invoiceCode;

    /**
     * 系统来源  下发数据需要  由属地直接传过来
     * 表 : inv_seller_pre_invoice
     * 对应字段 : system_orig
     */
    private String systemOrig;

    /**
     * 购方集团id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_tenant_id
     */
    private Long purchaserTenantId;

    /**
     * 购方租户ID
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_group_id
     */
    private Long purchaserGroupId;

    /**
     * 购方公司id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_id
     */
    private Long purchaserId;

    /**
     * 购方编号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_no
     */
    private String purchaserNo;

    /**
     * 购方名称
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_name
     */
    private String purchaserName;

    /**
     * 购方税号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_tax_no
     */
    private String purchaserTaxNo;

    /**
     * 购方电话
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_tel
     */
    private String purchaserTel;

    /**
     * 购方地址
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_address
     */
    private String purchaserAddress;

    /**
     * 购方开户行
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_bank_name
     */
    private String purchaserBankName;

    /**
     * 购方银行账号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : purchaser_bank_account
     */
    private String purchaserBankAccount;

    /**
     * 销方集团id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_tenant_id
     */
    private Long sellerTenantId;

    /**
     * 销方租户id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_group_id
     */
    private Long sellerGroupId;

    /**
     * 销方编号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_no
     */
    private String sellerNo;

    /**
     * 销方税号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_tax_no
     */
    private String sellerTaxNo;

    /**
     * 销方名称
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_name
     */
    private String sellerName;

    /**
     * 销方电话
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_tel
     */
    private String sellerTel;

    /**
     * 销方地址
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_address
     */
    private String sellerAddress;

    /**
     * 销方开户行
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_bank_name
     */
    private String sellerBankName;

    /**
     * 销方银行账号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_bank_account
     */
    private String sellerBankAccount;

    /**
     * 销方公司id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : seller_id
     */
    private Long sellerId;

    /**
     * 发票类型
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoice_type
     */
    private String invoiceType;

    /**
     * 业务单据类型
     * 表 : inv_seller_pre_invoice
     * 对应字段 : business_bill_type
     */
    private String businessBillType;

    /**
     * 单据类型
     * 表 : inv_seller_pre_invoice
     * 对应字段 : salesbill_type
     */
    private String salesbillType;

    /**
     * 开票日期
     * 表 : inv_seller_pre_invoice
     * 对应字段 : paper_draw_date
     */
    private String paperDrawDate;

    /**
     * 机器编码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : machine_code
     */
    private String machineCode;

    /**
     * 校验码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : check_code
     */
    private String checkCode;

    /**
     * 不含税金额
     * 表 : inv_seller_pre_invoice
     * 对应字段 : amount_without_tax
     */
    private BigDecimal amountWithoutTax;

    /**
     * 税额
     * 表 : inv_seller_pre_invoice
     * 对应字段 : tax_amount
     */
    private BigDecimal taxAmount;

    /**
     * 价税合计
     * 表 : inv_seller_pre_invoice
     * 对应字段 : amount_with_tax
     */
    private BigDecimal amountWithTax;

    /**
     *
     * 税率，明细税率去重后逗号分隔
     */
    private String taxRate;

    /**
     * 备注
     * 表 : inv_seller_pre_invoice
     * 对应字段 : remark
     */
    private String remark;

    /**
     * 收款人
     * 表 : inv_seller_pre_invoice
     * 对应字段 : cashier_name
     */
    private String cashierName;

    /**
     * 复核人
     * 表 : inv_seller_pre_invoice
     * 对应字段 : checker_name
     */
    private String checkerName;

    /**
     * 开票人
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoicer_name
     */
    private String invoicerName;

    /**
     * 电子签章
     * 表 : inv_seller_pre_invoice
     * 对应字段 : electronic_signature
     */
    private String electronicSignature;

    /**
     * 预制发票状态，0=删除，1=待确认,2=有变更,3=购方确认中(销方待确认),4=销方确认中(购方待确认),5=待开票,6=开票中,7已开票
     * 表 : inv_seller_pre_invoice
     * 对应字段 : status
     */
    private Byte status;

    /**
     * 预制发票是否锁定,0=未锁,1=锁定,2=开票锁',
     * 表 : inv_seller_pre_invoice
     * 对应字段 : lock_flag
     */
    private Byte lockFlag;

    /**
     * 规则id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : rule_id
     */
    private Long ruleId;

    /**
     * 组织机构id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : sys_org_id
     */
    private Long sysOrgId;

    /**
     * 原发票号码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : origin_invoice_no
     */
    private String originInvoiceNo;

    /**
     * 原发票代码
     * 表 : inv_seller_pre_invoice
     * 对应字段 : origin_invoice_code
     */
    private String originInvoiceCode;

    /**
     * 红字信息表编号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : red_notification_no
     */
    private String redNotificationNo;

    /**
     * 接收方邮箱
     * 表 : inv_seller_pre_invoice
     * 对应字段 : receive_user_email
     */
    private String receiveUserEmail;

    /**
     * 接收方电话
     * 表 : inv_seller_pre_invoice
     * 对应字段 : receive_user_tel
     */
    private String receiveUserTel;

    /**
     * 发票签名 用于抽取匹配
     * 表 : inv_seller_pre_invoice
     * 对应字段 : invoice_signature
     */
    private String invoiceSignature;

    /**
     * 创建时间
     * 表 : inv_seller_pre_invoice
     * 对应字段 : create_time
     */
    private Date createTime;

    /**
     * 更新时间
     * 表 : inv_seller_pre_invoice
     * 对应字段 : update_time
     */
    private Date updateTime;

    /**
     * 更新用户id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : create_user_id
     */
    private Long createUserId;

    /**
     * 更新用户id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : update_user_id
     */
    private Long updateUserId;

    /**
     * 特殊发票标记  0-默认  1-通行费   2-成品油
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : special_invoice_flag
     */
    private String specialInvoiceFlag;

    /**
     * 打印内容标志 (0-打印单价和数量, 1-不打印单价和数量)
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : display_price_quality
     */
    private Byte displayPriceQuality;

    /**
     * 销货清单文件打印标志 (0-否, 1-是)
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : sale_list_file_flag
     */
    private Byte saleListFileFlag;

    /**
     * 版式文件版本 (0-使用5行模版, 1-使用8行模版)(仅服务器开电票使用)
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : template_version
     */
    private Byte templateVersion;

    /**
     * 销货清单备注
     * 表 : inv_seller_pre_invoice_ext
     * 对应字段 : list_goods_name
     */
    private String listGoodsName;

    /**
     * 扩展字段1
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext1
     */
    private String ext1;

    /**
     * 扩展字段2
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext2
     */
    private String ext2;

    /**
     * 扩展字段3
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext3
     */
    private String ext3;

    /**
     * 扩展字段4
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext4
     */
    private String ext4;

    /**
     * 扩展字段5
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext5
     */
    private String ext5;

    /**
     * 扩展字段6
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext6
     */
    private String ext6;

    /**
     * 扩展字段7
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext7
     */
    private String ext7;

    /**
     * 扩展字段8
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext8
     */
    private String ext8;

    /**
     * 扩展字段9
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext9
     */
    private String ext9;

    /**
     * 扩展字段10
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext10
     */
    private String ext10;

    /**
     * 扩展字段11
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext11
     */
    private String ext11;

    /**
     * 扩展字段12
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext12
     */
    private String ext12;

    /**
     * 扩展字段13
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext13
     */
    private String ext13;

    /**
     * 扩展字段14
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext14
     */
    private String ext14;

    /**
     * 扩展字段15
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext15
     */
    private String ext15;

    /**
     * 扩展字段16
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext16
     */
    private String ext16;

    /**
     * 扩展字段17
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext17
     */
    private String ext17;

    /**
     * 扩展字段18
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext18
     */
    private String ext18;

    /**
     * 扩展字段19
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext19
     */
    private String ext19;

    /**
     * 扩展字段20
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext20
     */
    private String ext20;

    /**
     * 扩展字段21
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext21
     */
    private String ext21;

    /**
     * 扩展字段22
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext22
     */
    private String ext22;

    /**
     * 扩展字段23
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext23
     */
    private String ext23;

    /**
     * 扩展字段24
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext24
     */
    private String ext24;

    /**
     * 扩展字段25
     * 表 : inv_seller_pre_invoice
     * 对应字段 : ext25
     */
    private String ext25;

    public Long getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    public String getSalesbillId() {
        return salesbillId;
    }

    public void setSalesbillId(String salesbillId) {
        this.salesbillId = salesbillId;
    }

    public Long getOutBatchNo() {
        return outBatchNo;
    }

    public void setOutBatchNo(Long outBatchNo) {
        this.outBatchNo = outBatchNo;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    public Long getPurchaserTenantId() {
        return purchaserTenantId;
    }

    public void setPurchaserTenantId(Long purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }

    public Long getPurchaserGroupId() {
        return purchaserGroupId;
    }

    public void setPurchaserGroupId(Long purchaserGroupId) {
        this.purchaserGroupId = purchaserGroupId;
    }

    public Long getPurchaserId() {
        return purchaserId;
    }

    public void setPurchaserId(Long purchaserId) {
        this.purchaserId = purchaserId;
    }

    public String getPurchaserNo() {
        return purchaserNo;
    }

    public void setPurchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    public String getPurchaserTel() {
        return purchaserTel;
    }

    public void setPurchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
    }

    public String getPurchaserAddress() {
        return purchaserAddress;
    }

    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
    }

    public String getPurchaserBankName() {
        return purchaserBankName;
    }

    public void setPurchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
    }

    public String getPurchaserBankAccount() {
        return purchaserBankAccount;
    }

    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
    }

    public Long getSellerTenantId() {
        return sellerTenantId;
    }

    public void setSellerTenantId(Long sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    public Long getSellerGroupId() {
        return sellerGroupId;
    }

    public void setSellerGroupId(Long sellerGroupId) {
        this.sellerGroupId = sellerGroupId;
    }

    public String getSellerNo() {
        return sellerNo;
    }

    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
    }

    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getSellerTel() {
        return sellerTel;
    }

    public void setSellerTel(String sellerTel) {
        this.sellerTel = sellerTel;
    }

    public String getSellerAddress() {
        return sellerAddress;
    }

    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
    }

    public String getSellerBankName() {
        return sellerBankName;
    }

    public void setSellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName;
    }

    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getBusinessBillType() {
        return businessBillType;
    }

    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
    }

    public String getSalesbillType() {
        return salesbillType;
    }

    public void setSalesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
    }

    public String getPaperDrawDate() {
        return paperDrawDate;
    }

    public void setPaperDrawDate(String paperDrawDate) {
        this.paperDrawDate = paperDrawDate;
    }

    public String getMachineCode() {
        return machineCode;
    }

    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public String getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCashierName() {
        return cashierName;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    public String getCheckerName() {
        return checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }

    public String getInvoicerName() {
        return invoicerName;
    }

    public void setInvoicerName(String invoicerName) {
        this.invoicerName = invoicerName;
    }

    public String getElectronicSignature() {
        return electronicSignature;
    }

    public void setElectronicSignature(String electronicSignature) {
        this.electronicSignature = electronicSignature;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Byte getLockFlag() {
        return lockFlag;
    }

    public void setLockFlag(Byte lockFlag) {
        this.lockFlag = lockFlag;
    }

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public Long getSysOrgId() {
        return sysOrgId;
    }

    public void setSysOrgId(Long sysOrgId) {
        this.sysOrgId = sysOrgId;
    }

    public String getOriginInvoiceNo() {
        return originInvoiceNo;
    }

    public void setOriginInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo;
    }

    public String getOriginInvoiceCode() {
        return originInvoiceCode;
    }

    public void setOriginInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode;
    }

    public String getRedNotificationNo() {
        return redNotificationNo;
    }

    public void setRedNotificationNo(String redNotificationNo) {
        this.redNotificationNo = redNotificationNo;
    }

    public String getReceiveUserEmail() {
        return receiveUserEmail;
    }

    public void setReceiveUserEmail(String receiveUserEmail) {
        this.receiveUserEmail = receiveUserEmail;
    }

    public String getReceiveUserTel() {
        return receiveUserTel;
    }

    public void setReceiveUserTel(String receiveUserTel) {
        this.receiveUserTel = receiveUserTel;
    }

    public String getInvoiceSignature() {
        return invoiceSignature;
    }

    public void setInvoiceSignature(String invoiceSignature) {
        this.invoiceSignature = invoiceSignature;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    public String getSpecialInvoiceFlag() {
        return specialInvoiceFlag;
    }

    public void setSpecialInvoiceFlag(String specialInvoiceFlag) {
        this.specialInvoiceFlag = specialInvoiceFlag;
    }

    public Byte getDisplayPriceQuality() {
        return displayPriceQuality;
    }

    public void setDisplayPriceQuality(Byte displayPriceQuality) {
        this.displayPriceQuality = displayPriceQuality;
    }

    public Byte getSaleListFileFlag() {
        return saleListFileFlag;
    }

    public void setSaleListFileFlag(Byte saleListFileFlag) {
        this.saleListFileFlag = saleListFileFlag;
    }

    public Byte getTemplateVersion() {
        return templateVersion;
    }

    public void setTemplateVersion(Byte templateVersion) {
        this.templateVersion = templateVersion;
    }

    public String getListGoodsName() {
        return listGoodsName;
    }

    public void setListGoodsName(String listGoodsName) {
        this.listGoodsName = listGoodsName;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    public String getExt21() {
        return ext21;
    }

    public void setExt21(String ext21) {
        this.ext21 = ext21;
    }

    public String getExt22() {
        return ext22;
    }

    public void setExt22(String ext22) {
        this.ext22 = ext22;
    }

    public String getExt23() {
        return ext23;
    }

    public void setExt23(String ext23) {
        this.ext23 = ext23;
    }

    public String getExt24() {
        return ext24;
    }

    public void setExt24(String ext24) {
        this.ext24 = ext24;
    }

    public String getExt25() {
        return ext25;
    }

    public void setExt25(String ext25) {
        this.ext25 = ext25;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PreInvoiceMain that = (PreInvoiceMain) o;

        if (batchNo != null ? !batchNo.equals(that.batchNo) : that.batchNo != null) return false;
        if (salesbillNo != null ? !salesbillNo.equals(that.salesbillNo) : that.salesbillNo != null) return false;
        if (salesbillId != null ? !salesbillId.equals(that.salesbillId) : that.salesbillId != null) return false;
        if (outBatchNo != null ? !outBatchNo.equals(that.outBatchNo) : that.outBatchNo != null) return false;
        if (customerNo != null ? !customerNo.equals(that.customerNo) : that.customerNo != null) return false;
        if (invoiceNo != null ? !invoiceNo.equals(that.invoiceNo) : that.invoiceNo != null) return false;
        if (invoiceCode != null ? !invoiceCode.equals(that.invoiceCode) : that.invoiceCode != null) return false;
        if (systemOrig != null ? !systemOrig.equals(that.systemOrig) : that.systemOrig != null) return false;
        if (purchaserTenantId != null ? !purchaserTenantId.equals(that.purchaserTenantId) : that.purchaserTenantId != null)
            return false;
        if (purchaserGroupId != null ? !purchaserGroupId.equals(that.purchaserGroupId) : that.purchaserGroupId != null)
            return false;
        if (purchaserId != null ? !purchaserId.equals(that.purchaserId) : that.purchaserId != null) return false;
        if (purchaserNo != null ? !purchaserNo.equals(that.purchaserNo) : that.purchaserNo != null) return false;
        if (purchaserName != null ? !purchaserName.equals(that.purchaserName) : that.purchaserName != null)
            return false;
        if (purchaserTaxNo != null ? !purchaserTaxNo.equals(that.purchaserTaxNo) : that.purchaserTaxNo != null)
            return false;
        if (purchaserTel != null ? !purchaserTel.equals(that.purchaserTel) : that.purchaserTel != null) return false;
        if (purchaserAddress != null ? !purchaserAddress.equals(that.purchaserAddress) : that.purchaserAddress != null)
            return false;
        if (purchaserBankName != null ? !purchaserBankName.equals(that.purchaserBankName) : that.purchaserBankName != null)
            return false;
        if (purchaserBankAccount != null ? !purchaserBankAccount.equals(that.purchaserBankAccount) : that.purchaserBankAccount != null)
            return false;
        if (sellerTenantId != null ? !sellerTenantId.equals(that.sellerTenantId) : that.sellerTenantId != null)
            return false;
        if (sellerGroupId != null ? !sellerGroupId.equals(that.sellerGroupId) : that.sellerGroupId != null)
            return false;
        if (sellerNo != null ? !sellerNo.equals(that.sellerNo) : that.sellerNo != null) return false;
        if (sellerTaxNo != null ? !sellerTaxNo.equals(that.sellerTaxNo) : that.sellerTaxNo != null) return false;
        if (sellerName != null ? !sellerName.equals(that.sellerName) : that.sellerName != null) return false;
        if (sellerTel != null ? !sellerTel.equals(that.sellerTel) : that.sellerTel != null) return false;
        if (sellerAddress != null ? !sellerAddress.equals(that.sellerAddress) : that.sellerAddress != null)
            return false;
        if (sellerBankName != null ? !sellerBankName.equals(that.sellerBankName) : that.sellerBankName != null)
            return false;
        if (sellerBankAccount != null ? !sellerBankAccount.equals(that.sellerBankAccount) : that.sellerBankAccount != null)
            return false;
        if (sellerId != null ? !sellerId.equals(that.sellerId) : that.sellerId != null) return false;
        if (invoiceType != null ? !invoiceType.equals(that.invoiceType) : that.invoiceType != null) return false;
        if (businessBillType != null ? !businessBillType.equals(that.businessBillType) : that.businessBillType != null)
            return false;
        if (salesbillType != null ? !salesbillType.equals(that.salesbillType) : that.salesbillType != null)
            return false;
        if (paperDrawDate != null ? !paperDrawDate.equals(that.paperDrawDate) : that.paperDrawDate != null)
            return false;
        if (machineCode != null ? !machineCode.equals(that.machineCode) : that.machineCode != null) return false;
        if (checkCode != null ? !checkCode.equals(that.checkCode) : that.checkCode != null) return false;
        if (amountWithoutTax != null ? !amountWithoutTax.equals(that.amountWithoutTax) : that.amountWithoutTax != null)
            return false;
        if (taxAmount != null ? !taxAmount.equals(that.taxAmount) : that.taxAmount != null) return false;
        if (amountWithTax != null ? !amountWithTax.equals(that.amountWithTax) : that.amountWithTax != null)
            return false;
        if (taxRate != null ? !taxRate.equals(that.taxRate) : that.taxRate != null) return false;
        if (remark != null ? !remark.equals(that.remark) : that.remark != null) return false;
        if (cashierName != null ? !cashierName.equals(that.cashierName) : that.cashierName != null) return false;
        if (checkerName != null ? !checkerName.equals(that.checkerName) : that.checkerName != null) return false;
        if (invoicerName != null ? !invoicerName.equals(that.invoicerName) : that.invoicerName != null) return false;
        if (electronicSignature != null ? !electronicSignature.equals(that.electronicSignature) : that.electronicSignature != null)
            return false;
        if (status != null ? !status.equals(that.status) : that.status != null) return false;
        if (lockFlag != null ? !lockFlag.equals(that.lockFlag) : that.lockFlag != null) return false;
        if (ruleId != null ? !ruleId.equals(that.ruleId) : that.ruleId != null) return false;
        if (sysOrgId != null ? !sysOrgId.equals(that.sysOrgId) : that.sysOrgId != null) return false;
        if (originInvoiceNo != null ? !originInvoiceNo.equals(that.originInvoiceNo) : that.originInvoiceNo != null)
            return false;
        if (originInvoiceCode != null ? !originInvoiceCode.equals(that.originInvoiceCode) : that.originInvoiceCode != null)
            return false;
        if (redNotificationNo != null ? !redNotificationNo.equals(that.redNotificationNo) : that.redNotificationNo != null)
            return false;
        if (receiveUserEmail != null ? !receiveUserEmail.equals(that.receiveUserEmail) : that.receiveUserEmail != null)
            return false;
        if (receiveUserTel != null ? !receiveUserTel.equals(that.receiveUserTel) : that.receiveUserTel != null)
            return false;
        if (invoiceSignature != null ? !invoiceSignature.equals(that.invoiceSignature) : that.invoiceSignature != null)
            return false;
        if (createTime != null ? !createTime.equals(that.createTime) : that.createTime != null) return false;
        if (updateTime != null ? !updateTime.equals(that.updateTime) : that.updateTime != null) return false;
        if (createUserId != null ? !createUserId.equals(that.createUserId) : that.createUserId != null) return false;
        if (updateUserId != null ? !updateUserId.equals(that.updateUserId) : that.updateUserId != null) return false;
        if (specialInvoiceFlag != null ? !specialInvoiceFlag.equals(that.specialInvoiceFlag) : that.specialInvoiceFlag != null)
            return false;
        if (displayPriceQuality != null ? !displayPriceQuality.equals(that.displayPriceQuality) : that.displayPriceQuality != null)
            return false;
        if (saleListFileFlag != null ? !saleListFileFlag.equals(that.saleListFileFlag) : that.saleListFileFlag != null)
            return false;
        if (templateVersion != null ? !templateVersion.equals(that.templateVersion) : that.templateVersion != null)
            return false;
        if (listGoodsName != null ? !listGoodsName.equals(that.listGoodsName) : that.listGoodsName != null)
            return false;
        if (ext1 != null ? !ext1.equals(that.ext1) : that.ext1 != null) return false;
        if (ext2 != null ? !ext2.equals(that.ext2) : that.ext2 != null) return false;
        if (ext3 != null ? !ext3.equals(that.ext3) : that.ext3 != null) return false;
        if (ext4 != null ? !ext4.equals(that.ext4) : that.ext4 != null) return false;
        if (ext5 != null ? !ext5.equals(that.ext5) : that.ext5 != null) return false;
        if (ext6 != null ? !ext6.equals(that.ext6) : that.ext6 != null) return false;
        if (ext7 != null ? !ext7.equals(that.ext7) : that.ext7 != null) return false;
        if (ext8 != null ? !ext8.equals(that.ext8) : that.ext8 != null) return false;
        if (ext9 != null ? !ext9.equals(that.ext9) : that.ext9 != null) return false;
        if (ext10 != null ? !ext10.equals(that.ext10) : that.ext10 != null) return false;
        if (ext11 != null ? !ext11.equals(that.ext11) : that.ext11 != null) return false;
        if (ext12 != null ? !ext12.equals(that.ext12) : that.ext12 != null) return false;
        if (ext13 != null ? !ext13.equals(that.ext13) : that.ext13 != null) return false;
        if (ext14 != null ? !ext14.equals(that.ext14) : that.ext14 != null) return false;
        if (ext15 != null ? !ext15.equals(that.ext15) : that.ext15 != null) return false;
        if (ext16 != null ? !ext16.equals(that.ext16) : that.ext16 != null) return false;
        if (ext17 != null ? !ext17.equals(that.ext17) : that.ext17 != null) return false;
        if (ext18 != null ? !ext18.equals(that.ext18) : that.ext18 != null) return false;
        if (ext19 != null ? !ext19.equals(that.ext19) : that.ext19 != null) return false;
        if (ext20 != null ? !ext20.equals(that.ext20) : that.ext20 != null) return false;
        if (ext21 != null ? !ext21.equals(that.ext21) : that.ext21 != null) return false;
        if (ext22 != null ? !ext22.equals(that.ext22) : that.ext22 != null) return false;
        if (ext23 != null ? !ext23.equals(that.ext23) : that.ext23 != null) return false;
        if (ext24 != null ? !ext24.equals(that.ext24) : that.ext24 != null) return false;
        return ext25 != null ? ext25.equals(that.ext25) : that.ext25 == null;
    }

    @Override
    public int hashCode() {
        int result = batchNo != null ? batchNo.hashCode() : 0;
        result = 31 * result + (salesbillNo != null ? salesbillNo.hashCode() : 0);
        result = 31 * result + (salesbillId != null ? salesbillId.hashCode() : 0);
        result = 31 * result + (outBatchNo != null ? outBatchNo.hashCode() : 0);
        result = 31 * result + (customerNo != null ? customerNo.hashCode() : 0);
        result = 31 * result + (invoiceNo != null ? invoiceNo.hashCode() : 0);
        result = 31 * result + (invoiceCode != null ? invoiceCode.hashCode() : 0);
        result = 31 * result + (systemOrig != null ? systemOrig.hashCode() : 0);
        result = 31 * result + (purchaserTenantId != null ? purchaserTenantId.hashCode() : 0);
        result = 31 * result + (purchaserGroupId != null ? purchaserGroupId.hashCode() : 0);
        result = 31 * result + (purchaserId != null ? purchaserId.hashCode() : 0);
        result = 31 * result + (purchaserNo != null ? purchaserNo.hashCode() : 0);
        result = 31 * result + (purchaserName != null ? purchaserName.hashCode() : 0);
        result = 31 * result + (purchaserTaxNo != null ? purchaserTaxNo.hashCode() : 0);
        result = 31 * result + (purchaserTel != null ? purchaserTel.hashCode() : 0);
        result = 31 * result + (purchaserAddress != null ? purchaserAddress.hashCode() : 0);
        result = 31 * result + (purchaserBankName != null ? purchaserBankName.hashCode() : 0);
        result = 31 * result + (purchaserBankAccount != null ? purchaserBankAccount.hashCode() : 0);
        result = 31 * result + (sellerTenantId != null ? sellerTenantId.hashCode() : 0);
        result = 31 * result + (sellerGroupId != null ? sellerGroupId.hashCode() : 0);
        result = 31 * result + (sellerNo != null ? sellerNo.hashCode() : 0);
        result = 31 * result + (sellerTaxNo != null ? sellerTaxNo.hashCode() : 0);
        result = 31 * result + (sellerName != null ? sellerName.hashCode() : 0);
        result = 31 * result + (sellerTel != null ? sellerTel.hashCode() : 0);
        result = 31 * result + (sellerAddress != null ? sellerAddress.hashCode() : 0);
        result = 31 * result + (sellerBankName != null ? sellerBankName.hashCode() : 0);
        result = 31 * result + (sellerBankAccount != null ? sellerBankAccount.hashCode() : 0);
        result = 31 * result + (sellerId != null ? sellerId.hashCode() : 0);
        result = 31 * result + (invoiceType != null ? invoiceType.hashCode() : 0);
        result = 31 * result + (businessBillType != null ? businessBillType.hashCode() : 0);
        result = 31 * result + (salesbillType != null ? salesbillType.hashCode() : 0);
        result = 31 * result + (paperDrawDate != null ? paperDrawDate.hashCode() : 0);
        result = 31 * result + (machineCode != null ? machineCode.hashCode() : 0);
        result = 31 * result + (checkCode != null ? checkCode.hashCode() : 0);
        result = 31 * result + (amountWithoutTax != null ? amountWithoutTax.hashCode() : 0);
        result = 31 * result + (taxAmount != null ? taxAmount.hashCode() : 0);
        result = 31 * result + (amountWithTax != null ? amountWithTax.hashCode() : 0);
        result = 31 * result + (taxRate != null ? taxRate.hashCode() : 0);
        result = 31 * result + (remark != null ? remark.hashCode() : 0);
        result = 31 * result + (cashierName != null ? cashierName.hashCode() : 0);
        result = 31 * result + (checkerName != null ? checkerName.hashCode() : 0);
        result = 31 * result + (invoicerName != null ? invoicerName.hashCode() : 0);
        result = 31 * result + (electronicSignature != null ? electronicSignature.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (lockFlag != null ? lockFlag.hashCode() : 0);
        result = 31 * result + (ruleId != null ? ruleId.hashCode() : 0);
        result = 31 * result + (sysOrgId != null ? sysOrgId.hashCode() : 0);
        result = 31 * result + (originInvoiceNo != null ? originInvoiceNo.hashCode() : 0);
        result = 31 * result + (originInvoiceCode != null ? originInvoiceCode.hashCode() : 0);
        result = 31 * result + (redNotificationNo != null ? redNotificationNo.hashCode() : 0);
        result = 31 * result + (receiveUserEmail != null ? receiveUserEmail.hashCode() : 0);
        result = 31 * result + (receiveUserTel != null ? receiveUserTel.hashCode() : 0);
        result = 31 * result + (invoiceSignature != null ? invoiceSignature.hashCode() : 0);
        result = 31 * result + (createTime != null ? createTime.hashCode() : 0);
        result = 31 * result + (updateTime != null ? updateTime.hashCode() : 0);
        result = 31 * result + (createUserId != null ? createUserId.hashCode() : 0);
        result = 31 * result + (updateUserId != null ? updateUserId.hashCode() : 0);
        result = 31 * result + (specialInvoiceFlag != null ? specialInvoiceFlag.hashCode() : 0);
        result = 31 * result + (displayPriceQuality != null ? displayPriceQuality.hashCode() : 0);
        result = 31 * result + (saleListFileFlag != null ? saleListFileFlag.hashCode() : 0);
        result = 31 * result + (templateVersion != null ? templateVersion.hashCode() : 0);
        result = 31 * result + (listGoodsName != null ? listGoodsName.hashCode() : 0);
        result = 31 * result + (ext1 != null ? ext1.hashCode() : 0);
        result = 31 * result + (ext2 != null ? ext2.hashCode() : 0);
        result = 31 * result + (ext3 != null ? ext3.hashCode() : 0);
        result = 31 * result + (ext4 != null ? ext4.hashCode() : 0);
        result = 31 * result + (ext5 != null ? ext5.hashCode() : 0);
        result = 31 * result + (ext6 != null ? ext6.hashCode() : 0);
        result = 31 * result + (ext7 != null ? ext7.hashCode() : 0);
        result = 31 * result + (ext8 != null ? ext8.hashCode() : 0);
        result = 31 * result + (ext9 != null ? ext9.hashCode() : 0);
        result = 31 * result + (ext10 != null ? ext10.hashCode() : 0);
        result = 31 * result + (ext11 != null ? ext11.hashCode() : 0);
        result = 31 * result + (ext12 != null ? ext12.hashCode() : 0);
        result = 31 * result + (ext13 != null ? ext13.hashCode() : 0);
        result = 31 * result + (ext14 != null ? ext14.hashCode() : 0);
        result = 31 * result + (ext15 != null ? ext15.hashCode() : 0);
        result = 31 * result + (ext16 != null ? ext16.hashCode() : 0);
        result = 31 * result + (ext17 != null ? ext17.hashCode() : 0);
        result = 31 * result + (ext18 != null ? ext18.hashCode() : 0);
        result = 31 * result + (ext19 != null ? ext19.hashCode() : 0);
        result = 31 * result + (ext20 != null ? ext20.hashCode() : 0);
        result = 31 * result + (ext21 != null ? ext21.hashCode() : 0);
        result = 31 * result + (ext22 != null ? ext22.hashCode() : 0);
        result = 31 * result + (ext23 != null ? ext23.hashCode() : 0);
        result = 31 * result + (ext24 != null ? ext24.hashCode() : 0);
        result = 31 * result + (ext25 != null ? ext25.hashCode() : 0);
        return result;
    }
}
