/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.aliyun.logservice;

import com.alibaba.ttl.TtlRunnable;
import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.Producer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.aliyun.openservices.aliyun.log.producer.errors.ProducerException;
import com.aliyun.openservices.log.common.LogItem;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogEvent;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogSender;
import com.xforceplus.taxware.architecture.g1.domain.util.ApplicationUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogServiceSender
implements LogSender {
    private static Logger logger = LoggerFactory.getLogger(LogServiceSender.class);
    private static AtomicInteger seqNo = new AtomicInteger(0);
    private final Producer logProducer;
    private final String project;
    private BlockingQueue<LogEvent> queue;

    public LogServiceSender(String project, ProjectConfig config, int queueSize, int threadSize) {
        this.project = project;
        this.queue = new LinkedBlockingDeque<LogEvent>(queueSize);
        this.logProducer = new LogProducer(new ProducerConfig());
        this.logProducer.putProjectConfig(this.createProjectConfig(config));
        for (int i = 0; i < threadSize; ++i) {
            this.addThread("AliYunLogSender-" + seqNo.addAndGet(1));
        }
    }

    private ProjectConfig createProjectConfig(ProjectConfig config) {
        if (StringUtils.isNotBlank((CharSequence)config.getEndpoint())) {
            return config;
        }
        return new ProjectConfig(config.getProject(), "dev".equals(ApplicationUtil.getEnv()) ? "cn-hangzhou.log.aliyuncs.com" : "cn-hangzhou-intranet.log.aliyuncs.com", config.getAccessKeyId(), config.getAccessKeySecret());
    }

    private void doSend(LogEvent event) throws ProducerException, InterruptedException {
        this.logProducer.send(this.project, String.format("%s-%s", event.getEnv(), event.getService()), this.createLogItem(event));
    }

    public void send(LogEvent event) {
        this.queue.offer(event);
    }

    private LogItem createLogItem(LogEvent event) {
        LogItem result = new LogItem();
        event.toMap().forEach((key, value) -> result.PushBack(key, value + ""));
        return result;
    }

    private void addThread(String threadName) {
        Thread thread = new Thread((Runnable)TtlRunnable.get(() -> {
            while (true) {
                try {
                    while (true) {
                        LogEvent log = this.queue.take();
                        this.doSend(log);
                    }
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u963f\u91cc\u4e91\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                break;
            }
        }));
        thread.setName(threadName);
        thread.start();
    }
}

