/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.client.dingding;

import com.xforceplus.taxware.architecture.g1.client.dingding.model.DingMessage;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.DingMessageFunction;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.MarkdownContent;
import com.xforceplus.taxware.architecture.g1.client.http.AbstractHttpClient;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class DingTalkClient
extends AbstractHttpClient {
    private final String path;
    private String secret;

    public DingTalkClient(String baseUrl, String path, long timeout) {
        super(baseUrl, timeout, null);
        this.path = path;
    }

    public String send(DingMessage request) {
        try {
            return this.execute("robot", "POST", this.calcPath(), request, String.class);
        }
        catch (Exception e) {
            System.err.println("DingdingTalk Exception = " + e.getMessage());
            return null;
        }
    }

    public String send(DingMessageFunction func) {
        try {
            DingMessage request = new DingMessage();
            MarkdownContent markdownContent = new MarkdownContent();
            request.setMarkdown(markdownContent);
            func.apply(request);
            return this.send(request);
        }
        catch (Exception e) {
            System.err.println("DingdingTalk Exception = " + e.getMessage());
            return Optional.ofNullable(e.getMessage()).orElse(e.getClass().getName());
        }
    }

    private String calcPath() {
        if (this.secret == null || this.secret.isEmpty()) {
            return this.path;
        }
        long timestamp = System.currentTimeMillis();
        String sign = this.calcSign(timestamp);
        if (sign == null) {
            return this.path;
        }
        return String.format("%s&timestamp=%s&sign=%s", this.path, timestamp, sign);
    }

    private String calcSign(long timestamp) {
        try {
            String stringToSign = timestamp + "\n" + this.secret;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            return URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), "UTF-8");
        }
        catch (Exception e) {
            System.err.println(String.format("\u8ba1\u7b97\u7b7e\u540d\u5931\u8d25! [%s][%s]", this.path, this.secret));
            return null;
        }
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getSecret() {
        return this.secret;
    }
}

