/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.client.dingding.model;

import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.Producer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.aliyun.openservices.log.common.LogItem;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.DingTalkMessage;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.DingTalkMessageFunction;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.MessageTemplate;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.SlsTraceEvent;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.TraceEvent;
import com.xforceplus.taxware.architecture.g1.domain.util.ApplicationUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingTalkRobot {
    private static final Logger log = LoggerFactory.getLogger(DingTalkRobot.class);
    private static AtomicInteger index = new AtomicInteger(0);
    private static final Producer logProducer;
    private String url;
    private String secret;
    private OkHttpClient client;
    private BlockingQueue<DingTalkMessage> queue = new ArrayBlockingQueue<DingTalkMessage>(1000);

    DingTalkRobot(String url, String secret) {
        this.url = url;
        this.secret = secret;
        this.client = new OkHttpClient.Builder().writeTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).connectTimeout(3L, TimeUnit.SECONDS).build();
        new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        DingTalkMessage message = this.queue.take();
                        this.doSend(message);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, "DingTalkRobot" + index.getAndAdd(1)).start();
    }

    private void send(MessageTemplate messageTemplate) {
        this.queue.offer(DingTalkMessage.builder().messageTemplate(messageTemplate).build());
    }

    private void send(MessageTemplate messageTemplate, TraceEvent traceEvent) {
        this.queue.offer(DingTalkMessage.builder().messageTemplate(messageTemplate).traceEvent(traceEvent).build());
    }

    public void send(DingTalkMessageFunction function) {
        try {
            DingTalkMessage message = DingTalkMessage.builder().build();
            function.apply(message);
            this.send(message.getMessageTemplate(), message.getTraceEvent());
        }
        catch (Exception ex) {
            log.warn(String.format("\u6267\u884c\u9489\u9489\u6d88\u606f\u53d1\u9001\u65f6\u53d1\u751f\u5f02\u5e38\uff01%s", ex.getMessage()), (Throwable)ex);
        }
    }

    private void doSend(DingTalkMessage message) {
        MessageTemplate messageTemplate = message.getMessageTemplate();
        TraceEvent traceEvent = message.getTraceEvent();
        if (messageTemplate == null) {
            log.warn("\u53d1\u9001\u9489\u9489\u6d88\u606f\u65f6\u5f02\u5e38\uff01\u539f\u56e0\uff1a\u6ca1\u6709MessageTemplate\u5b9e\u4f8b");
            return;
        }
        String messageStr = messageTemplate.createMessage();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)messageStr);
        Request request = new Request.Builder().url(String.format("%s&%s", this.url, this.calcSign())).post(requestBody).build();
        try (Response response = this.client.newCall(request).execute();){
            response.body().string();
        }
        catch (Exception ex) {
            System.err.println("\u53d1\u9001\u9489\u9489\u6d88\u606f\u5f02\u5e38");
            ex.printStackTrace();
        }
        if (traceEvent == null) {
            return;
        }
        traceEvent.setMessage(messageStr);
        if (traceEvent instanceof SlsTraceEvent) {
            SlsTraceEvent slsTraceEvent = (SlsTraceEvent)traceEvent;
            LogItem logItem = slsTraceEvent.createLogItem();
            try {
                logProducer.send("taxware-all", String.format("%s-ding-talk-log", ApplicationUtil.getEnv()), logItem);
            }
            catch (Exception e) {
                System.err.println("\u53d1\u9001\u963f\u91cc\u4e91\u57cb\u70b9\u5f02\u5e38");
                e.printStackTrace();
            }
        }
    }

    private String calcSign() {
        try {
            long timestamp = System.currentTimeMillis();
            String stringToSign = timestamp + "\n" + this.secret;
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            String sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), "UTF-8");
            return String.format("timestamp=%s&sign=%s", timestamp, sign);
        }
        catch (Exception e) {
            System.err.println(String.format("\u8ba1\u7b97\u7b7e\u540d\u5931\u8d25! [%s]", this.secret));
            e.printStackTrace();
            return "";
        }
    }

    public String getUrl() {
        return this.url;
    }

    static {
        ProducerConfig producerConfig = new ProducerConfig();
        logProducer = new LogProducer(producerConfig);
        String project = "taxware-all";
        String endpoint = "dev".equals(ApplicationUtil.getEnv()) ? "cn-hangzhou.log.aliyuncs.com" : "cn-hangzhou-intranet.log.aliyuncs.com";
        String accessKeyId = "LTAItBLjQCtRVJj6";
        String accessKeySecret = "BgfG4vGuKDGDI8TK3D04vNDr4KP7gq";
        ProjectConfig projectConfig = new ProjectConfig(project, endpoint, accessKeyId, accessKeySecret);
        logProducer.putProjectConfig(projectConfig);
    }
}

