/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.client.dingding.model;

import com.alibaba.fastjson.JSON;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.MarkdownContent;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.MarkdownMessage;
import com.xforceplus.taxware.architecture.g1.client.dingding.model.MessageTemplate;
import com.xforceplus.taxware.architecture.g1.domain.util.ApplicationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class MarkdownMessageTemplate
extends MessageTemplate {
    private String title = "";
    private List<String> data = new ArrayList<String>();

    public MarkdownMessageTemplate() {
    }

    public MarkdownMessageTemplate(String title) {
        this.title = Optional.ofNullable(title).orElse("");
    }

    @Override
    public String createMessage() {
        MarkdownMessage markdown = new MarkdownMessage();
        MarkdownContent content = new MarkdownContent();
        String theTitle = String.format("[%s]%s", ApplicationUtil.getEnv().toUpperCase(), this.title);
        content.setTitle(theTitle);
        content.setText(String.format("### %s\n%s", theTitle, String.join((CharSequence)"\n\n", this.data)));
        markdown.setMsgtype("markdown");
        markdown.setMarkdown(content);
        return JSON.toJSONString((Object)markdown);
    }

    public String createContent() {
        return String.join((CharSequence)"  \n", this.data);
    }

    public MarkdownMessageTemplate setTitle(String title) {
        this.title = title;
        return this;
    }

    public MarkdownMessageTemplate appendH1Line(String h1) {
        this.data.add(String.format("# %s", h1));
        return this;
    }

    public MarkdownMessageTemplate appendH2Line(String h2) {
        this.data.add(String.format("## %s", h2));
        return this;
    }

    public MarkdownMessageTemplate appendH3Line(String h3) {
        this.data.add(String.format("### %s", h3));
        return this;
    }

    public MarkdownMessageTemplate appendH4Line(String h4) {
        this.data.add(String.format("#### %s", h4));
        return this;
    }

    public MarkdownMessageTemplate appendH5Line(String h5) {
        this.data.add(String.format("##### %s", h5));
        return this;
    }

    public MarkdownMessageTemplate appendH6Line(String h6) {
        this.data.add(String.format("###### %s", h6));
        return this;
    }

    public MarkdownMessageTemplate appendQuoteLine(String quote) {
        this.data.add(String.format("> %s", quote));
        return this;
    }

    public MarkdownMessageTemplate appendLinkLine(String name, String url) {
        this.data.add(String.format("[%s](%s)", name, url));
        return this;
    }

    public MarkdownMessageTemplate appendImageLine(String url) {
        this.data.add(String.format("![](%s)", url));
        return this;
    }

    public MarkdownMessageTemplate appendOlLine(String ol) {
        this.data.add(String.format("1. %s", ol));
        return this;
    }

    public MarkdownMessageTemplate appendUlLine(String ul) {
        this.data.add(String.format("- %s", ul));
        return this;
    }

    public MarkdownMessageTemplate appendNewLine(String line) {
        this.data.add(line);
        return this;
    }

    public MarkdownMessageTemplate appendNewLine() {
        this.data.add("");
        return this;
    }
}

