/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.client.dingding.model;

import com.xforceplus.taxware.architecture.g1.domain.util.ApplicationUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TraceEvent {
    private String env = ApplicationUtil.getEnv();
    private String type = "default";
    private boolean successful = true;
    private String message;
    private long timeCost = -1L;
    private String traceId;
    private Map<String, Object> tracePointMap = new ConcurrentHashMap<String, Object>();

    void setMessage(String message) {
        this.message = message;
    }

    public void putTracePoint(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        this.tracePointMap.put(key, value);
    }

    public String getEnv() {
        return this.env;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTimeCost() {
        return this.timeCost;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Map<String, Object> getTracePointMap() {
        return this.tracePointMap;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public void setTimeCost(long timeCost) {
        this.timeCost = timeCost;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setTracePointMap(Map<String, Object> tracePointMap) {
        this.tracePointMap = tracePointMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceEvent)) {
            return false;
        }
        TraceEvent other = (TraceEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        if (this.getTimeCost() != other.getTimeCost()) {
            return false;
        }
        String this$env = this.getEnv();
        String other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        Map<String, Object> this$tracePointMap = this.getTracePointMap();
        Map<String, Object> other$tracePointMap = other.getTracePointMap();
        return !(this$tracePointMap == null ? other$tracePointMap != null : !((Object)this$tracePointMap).equals(other$tracePointMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TraceEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        long $timeCost = this.getTimeCost();
        result = result * 59 + (int)($timeCost >>> 32 ^ $timeCost);
        String $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        Map<String, Object> $tracePointMap = this.getTracePointMap();
        result = result * 59 + ($tracePointMap == null ? 43 : ((Object)$tracePointMap).hashCode());
        return result;
    }

    public String toString() {
        return "TraceEvent(env=" + this.getEnv() + ", type=" + this.getType() + ", successful=" + this.isSuccessful() + ", message=" + this.getMessage() + ", timeCost=" + this.getTimeCost() + ", traceId=" + this.getTraceId() + ", tracePointMap=" + this.getTracePointMap() + ")";
    }
}

