/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.client.http;

import com.alibaba.fastjson.JSON;
import com.xforceplus.taxware.architecture.g1.client.exception.ServiceClientException;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseErrorRestfulResponseDTO;
import com.xforceplus.taxware.architecture.g1.domain.listener.HttpClientListener;
import com.xforceplus.taxware.architecture.g1.domain.listener.HttpClientListenerArgument;
import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class AbstractHttpClient {
    private static final MediaType MEDIA_TYPE_JSON_UTF8 = MediaType.parse((String)"application/json; charset=UTF-8");
    private String baseUrl;
    private HttpClientListener listener;
    private String username;
    private String password;
    protected OkHttpClient client;

    protected AbstractHttpClient(String baseUrl, long timeout, HttpClientListener listener) {
        this.client = new OkHttpClient.Builder().connectTimeout(timeout, TimeUnit.MILLISECONDS).readTimeout(timeout, TimeUnit.MILLISECONDS).writeTimeout(timeout, TimeUnit.MILLISECONDS).build();
        this.baseUrl = baseUrl;
        this.listener = listener;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <ReqT, RepT> RepT execute(String name, String method, String path, ReqT request, Class<RepT> responseClass) {
        HttpClientListenerArgument argument = new HttpClientListenerArgument();
        argument.setName(name);
        try {
            String requestBodyText = this.getRequestBodyText(request);
            byte[] requestBodyBytes = this.getRequestBodyBytes(requestBodyText);
            String url = this.getUrl(path, requestBodyBytes);
            Request httpRequest = this.createRequest(method, requestBodyBytes, url);
            argument.setUrl(url);
            argument.setMethod(method);
            argument.setRequestText(requestBodyText);
            argument.setRequestSize(requestBodyBytes.length);
            argument.setUserAgent("OkHttp/" + name);
            if (this.listener != null) {
                this.listener.beforeSend(argument);
            }
            try (Response httpResponse = this.client.newCall(httpRequest).execute();){
                argument.setResponseStatus(String.format("%d:%s", httpResponse.code(), httpResponse.message()));
                argument.setResponseHeaders(JSON.toJSONString((Object)httpResponse.headers().toMultimap()));
                ResponseBody responseBody = httpResponse.body();
                byte[] responseBodyBytes = responseBody != null ? responseBody.bytes() : new byte[]{};
                String responseBodyText = new String(responseBodyBytes, StandardCharsets.UTF_8);
                argument.setResponseText(responseBodyText);
                argument.setResponseSize(responseBodyBytes.length);
                if (!httpResponse.isSuccessful()) {
                    try {
                        BaseErrorRestfulResponseDTO baseRestfulResponseDTO = (BaseErrorRestfulResponseDTO)JSON.parseObject((String)responseBodyText, BaseErrorRestfulResponseDTO.class);
                        throw new ServiceClientException(httpResponse.code(), baseRestfulResponseDTO.getCode(), Optional.ofNullable(baseRestfulResponseDTO.getMessage()).orElse(httpResponse.message()));
                    }
                    catch (ServiceClientException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        System.err.println(ex.getMessage());
                        throw new ServiceClientException(httpResponse.code(), null, httpResponse.message());
                    }
                }
                Object result = JSON.parseObject((String)responseBodyText, responseClass);
                this.verify(httpResponse, responseBodyBytes, result);
                if (this.listener != null) {
                    this.listener.sendComplete(argument);
                }
                Object object = result;
                return (RepT)object;
            }
        }
        catch (Exception ex) {
            argument.setThrowable((Throwable)ex);
            if (this.listener != null) {
                this.listener.sendError(argument);
            }
            if (!(ex instanceof ServiceClientException)) throw new ServiceClientException(500, null, Optional.ofNullable(ex.getMessage()).orElse(ex.getClass().getName()), ex);
            throw (ServiceClientException)((Object)ex);
        }
    }

    protected String getUrl(String path, byte[] requestBodyBytes) {
        return String.format("%s/%s", this.baseUrl, path);
    }

    protected byte[] getRequestBodyBytes(String requestBodyText) {
        return requestBodyText.getBytes(StandardCharsets.UTF_8);
    }

    protected String getRequestBodyText(Object request) {
        return JSON.toJSONString((Object)request);
    }

    protected MediaType getMediaType() {
        return MEDIA_TYPE_JSON_UTF8;
    }

    protected void verify(Response httpResponse, byte[] responseBodyBytes, Object responseObj) {
    }

    private Request createRequest(String method, byte[] requestBodyBytes, String url) {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if ("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method)) {
            requestBuilder.method(method, null);
        } else {
            requestBuilder.method(method, RequestBody.create((MediaType)this.getMediaType(), (byte[])requestBodyBytes));
        }
        if (this.username != null) {
            String usernameAndPassword = String.format("%s:%s", this.username, this.password);
            String authorization = String.format("basic %s", Base64.getEncoder().encodeToString(usernameAndPassword.getBytes(StandardCharsets.UTF_8)));
            requestBuilder.header("Authorization", authorization);
        }
        requestBuilder.header("X-Trace-Id", Optional.ofNullable(LogContext.getTraceId()).orElse(""));
        return requestBuilder.build();
    }
}

