/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.client.http;

import com.alibaba.fastjson.JSON;
import com.xforceplus.taxware.architecture.g1.client.exception.ServiceClientException;
import com.xforceplus.taxware.architecture.g1.client.http.authorization.BasicAuthorization;
import com.xforceplus.taxware.architecture.g1.client.http.gateway.AbstractGateway;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseErrorRestfulResponseDTO;
import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000001Exception;
import com.xforceplus.taxware.architecture.g1.domain.listener.HttpClientListener;
import com.xforceplus.taxware.architecture.g1.domain.listener.HttpClientListenerArgument;
import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class AbstractHttpClient2 {
    private static final MediaType MEDIA_TYPE_JSON_UTF8 = MediaType.parse((String)"application/json; charset=UTF-8");
    private final OkHttpClient client;
    private final String baseUrl;
    private HttpClientListener listener;
    private AbstractGateway middleEndGateway;
    private BasicAuthorization basicAuthorization;

    public AbstractHttpClient2(String baseUrl, OkHttpClient client) {
        this.client = client;
        this.baseUrl = baseUrl;
    }

    public <RepT> RepT getCall(String name, String path, Map<String, String> param, Class<RepT> responseClass) {
        return this.methodCall(name, path, "GET", param, null, responseClass);
    }

    public <RepT, ReqT> RepT putCall(String name, String path, ReqT request, Class<RepT> responseClass) {
        return this.methodCall(name, path, "PUT", null, request, responseClass);
    }

    public <RepT, ReqT> RepT postCall(String name, String path, ReqT request, Class<RepT> responseClass) {
        return this.methodCall(name, path, "POST", null, request, responseClass);
    }

    public <RepT, ReqT> RepT postCall(String name, String path, Map<String, String> param, ReqT request, Class<RepT> responseClass) {
        return this.methodCall(name, path, "POST", param, request, responseClass);
    }

    public <RepT, ReqT> RepT deleteCall(String name, String path, ReqT request, Class<RepT> responseClass) {
        return this.methodCall(name, path, "DELETE", null, request, responseClass);
    }

    public <RepT, ReqT> RepT patchCall(String name, String path, ReqT request, Class<RepT> responseClass) {
        return this.methodCall(name, path, "PATCH", null, request, responseClass);
    }

    private <RepT, ReqT> RepT methodCall(String name, String path, String method, Map<String, String> param, ReqT request, Class<RepT> responseClass) {
        HttpClientListenerArgument argument = new HttpClientListenerArgument();
        argument.setName(name);
        try {
            String url = this.getUrl(path, param);
            argument.setMethod(method);
            argument.setUrl(url);
            argument.setUserAgent("OkHttp/" + name);
            byte[] requestBodyBytes = null;
            if (!"GET".equalsIgnoreCase(method)) {
                long startTime = System.currentTimeMillis();
                String requestBodyText = JSON.toJSONString(request);
                argument.setSerializeTimeCost(Long.valueOf(System.currentTimeMillis() - startTime));
                startTime = System.currentTimeMillis();
                requestBodyBytes = requestBodyText.getBytes(StandardCharsets.UTF_8);
                argument.setToByteTimeCost(Long.valueOf(System.currentTimeMillis() - startTime));
                argument.setRequestText(requestBodyText);
                argument.setRequestSize(requestBodyBytes.length);
            }
            if (this.listener != null) {
                this.listener.beforeSend(argument);
            }
            Request httpRequest = this.createRequest(url, method, requestBodyBytes);
            return this.execute(responseClass, argument, httpRequest);
        }
        catch (Exception ex) {
            return this.doError(argument, ex);
        }
    }

    private <RepT> RepT doError(HttpClientListenerArgument argument, Exception ex) {
        argument.setThrowable((Throwable)ex);
        if (this.listener != null) {
            this.listener.sendError(argument);
        }
        if (ex instanceof ServiceClientException) {
            throw (ServiceClientException)((Object)ex);
        }
        throw new ServiceClientException(500, null, Optional.ofNullable(ex.getMessage()).orElse(ex.getClass().getName()), ex);
    }

    private <RepT> RepT execute(Class<RepT> responseClass, HttpClientListenerArgument argument, Request httpRequest) throws IOException {
        try (Response httpResponse = this.client.newCall(httpRequest).execute();){
            argument.setResponseStatus(String.format("%d:%s", httpResponse.code(), httpResponse.message()));
            argument.setResponseHeaders(JSON.toJSONString((Object)httpResponse.headers().toMultimap()));
            ResponseBody responseBody = httpResponse.body();
            byte[] responseBodyBytes = responseBody != null ? responseBody.bytes() : new byte[]{};
            String responseBodyText = new String(responseBodyBytes, StandardCharsets.UTF_8);
            argument.setResponseText(responseBodyText);
            argument.setResponseSize(responseBodyBytes.length);
            if (!httpResponse.isSuccessful()) {
                try {
                    BaseErrorRestfulResponseDTO responseDTO = (BaseErrorRestfulResponseDTO)JSON.parseObject((String)responseBodyText, BaseErrorRestfulResponseDTO.class);
                    throw new ServiceClientException(httpResponse.code(), responseDTO.getCode(), Optional.ofNullable(responseDTO.getMessage()).orElse(httpResponse.message()));
                }
                catch (ServiceClientException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ServiceClientException(httpResponse.code(), null, httpResponse.message());
                }
            }
            Object result = "java.lang.String".equals(responseClass.getTypeName()) ? responseBodyText : JSON.parseObject((String)responseBodyText, responseClass);
            if (this.listener != null) {
                this.listener.sendComplete(argument);
            }
            Object object = result;
            return (RepT)object;
        }
    }

    private Request createRequest(String url, String method, byte[] requestBodyBytes) {
        Request.Builder builder = new Request.Builder().url(url);
        if (this.middleEndGateway != null) {
            builder.addHeader("x-app-token", this.middleEndGateway.getToken());
        }
        if (requestBodyBytes != null) {
            builder.method(method, RequestBody.create((MediaType)MEDIA_TYPE_JSON_UTF8, (byte[])requestBodyBytes));
        }
        if (this.basicAuthorization != null) {
            builder.header("Authorization", this.basicAuthorization.getToken());
        }
        builder.header("X-Caller-AppName", System.getProperty("spring.application.name", ""));
        builder.header("X-Trace-Id", Optional.ofNullable(LogContext.getTraceId()).orElse(""));
        return builder.build();
    }

    private String getUrl(String path, Map<String, String> param) {
        String queryString = param == null ? null : param.entrySet().parallelStream().map(entry -> {
            try {
                return String.format("%s=%s", entry.getKey(), URLEncoder.encode((String)entry.getValue(), String.valueOf(StandardCharsets.UTF_8)));
            }
            catch (UnsupportedEncodingException e) {
                throw new TXWR000001Exception("Get\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u503c\u8f6c\u6362URLEncode\u65f6\u5f02\u5e38", (Throwable)e);
            }
        }).collect(Collectors.joining("&"));
        return String.format("%s%s%s", this.baseUrl, path, queryString == null || queryString.trim().length() == 0 ? "" : "?" + queryString);
    }

    public void setListener(HttpClientListener listener) {
        this.listener = listener;
    }

    public void setMiddleEndGateway(AbstractGateway middleEndGateway) {
        this.middleEndGateway = middleEndGateway;
    }

    public void setBasicAuthorization(BasicAuthorization basicAuthorization) {
        this.basicAuthorization = basicAuthorization;
    }
}

