/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.domain.spring.filter.flow;

import com.xforceplus.taxware.architecture.g1.domain.spring.exception.ActuatorReflectException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

@WebFilter(filterName="FlowCtrlFilter", urlPatterns={"/flow/*", "/ctrl/*"})
public class FlowCtrlFilter
implements Filter,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(FlowCtrlFilter.class);
    private static final String FLOW_ONLINE = "/flow/online";
    private static final String FLOW_OFFLINE = "/flow/offline";
    private static final String FLOW_STATUS = "/flow/status";
    private static final String CTRL_STOP = "/ctrl/stop";
    private static final Set<String> LOCAL_ADDR = new HashSet<String>();
    private ConfigurableApplicationContext context;
    private Health health = Health.up().build();
    private HealthEndpoint healthEndpoint;
    private Method healthMethodCache;
    private Method getStatusMethodCache;
    private Runnable beforeOfflineRunnable;
    private Runnable beforeOnlineRunnable;
    private Runnable beforeStopRunnable;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.healthEndpoint = (HealthEndpoint)this.context.getBean(HealthEndpoint.class);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestURI = request.getRequestURI();
        String method = request.getMethod();
        String remoteHost = request.getRemoteHost();
        ServletOutputStream outputStream = response.getOutputStream();
        if (FLOW_STATUS.equals(requestURI) && "GET".equalsIgnoreCase(method)) {
            Status status = this.getHealthStatus();
            if (Status.UP == this.health.getStatus() && Status.UP == status) {
                response.setStatus(200);
                outputStream.write("status = up".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                outputStream.close();
            } else {
                response.setStatus(400);
                outputStream.write("status != up".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                outputStream.close();
            }
            return;
        }
        if (!LOCAL_ADDR.contains(remoteHost)) {
            response.setStatus(403);
            outputStream.write("remote host must be localhost".getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            outputStream.close();
            return;
        }
        if (FLOW_ONLINE.equals(requestURI) && "POST".equalsIgnoreCase(method)) {
            log.info("\u63a5\u5165\u6d41\u91cf...");
            if (this.beforeOnlineRunnable != null) {
                this.beforeOnlineRunnable.run();
            }
            this.health = Health.up().build();
            response.setStatus(200);
            outputStream.write("online ok".getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            outputStream.close();
        } else if (FLOW_OFFLINE.equals(requestURI) && "POST".equalsIgnoreCase(method)) {
            log.info("\u65ad\u5f00\u6d41\u91cf...");
            if (this.beforeOfflineRunnable != null) {
                this.beforeOfflineRunnable.run();
            }
            this.health = Health.down().build();
            response.setStatus(200);
            outputStream.write("offline ok".getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            outputStream.close();
        } else if (CTRL_STOP.equals(requestURI) && "POST".equalsIgnoreCase(method)) {
            if (this.beforeStopRunnable != null) {
                this.beforeStopRunnable.run();
            }
            String bizTimeoutStr = request.getParameter("biz-timeout");
            String stopTimeoutStr = request.getParameter("stop-timeout");
            int bizTimeout = Integer.parseInt(bizTimeoutStr) * 1000;
            int stopTimeout = Integer.parseInt(stopTimeoutStr) * 1000;
            if (this.context == null) {
                throw new RuntimeException("context must not be null");
            }
            log.info("\u51c6\u5907\u505c\u6b62\u670d\u52a1\uff01\u5148\u65ad\u5f00\u6d41\u91cf\uff0c\u7136\u540e\u9884\u7559 {}s \u7528\u6765\u6d88\u5316\u672a\u5904\u7406\u5b8c\u6210\u7684\u4e1a\u52a1\u903b\u8f91\uff0c\u518d\u7b49\u5f85 {}s \u7528\u6765\u5173\u95edSpring\u5bb9\u5668\uff0c\u6700\u540e\u7b49\u5f85K8s\u9500\u6bc1\u5fae\u670d\u52a1\u5bb9\u5668\u3002", (Object)bizTimeoutStr, (Object)stopTimeoutStr);
            try {
                this.health = Health.down().build();
                Thread.sleep(bizTimeout);
                Thread thread = new Thread(() -> this.closeContext(stopTimeout));
                thread.setContextClassLoader(this.getClass().getClassLoader());
                thread.start();
                Thread.sleep(stopTimeout);
                response.setStatus(200);
                outputStream.write("stop ok".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception e) {
                log.error("\u505c\u6b62\u670d\u52a1\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
                response.setStatus(500);
                outputStream.write("stop occur exception!".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                outputStream.close();
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    @NotNull
    private Status getHealthStatus() {
        block6: {
            Status status;
            try {
                Object statusResult;
                if (this.healthMethodCache == null) {
                    Class<?> healthEndPointClass = this.healthEndpoint.getClass();
                    this.healthMethodCache = healthEndPointClass.getMethod("health", new Class[0]);
                }
                Object invokeResult = this.healthMethodCache.invoke((Object)this.healthEndpoint, new Object[0]);
                if (this.getStatusMethodCache == null) {
                    Class<?> invokeResultClass = invokeResult.getClass();
                    this.getStatusMethodCache = invokeResultClass.getMethod("getStatus", new Class[0]);
                }
                if (!((statusResult = this.getStatusMethodCache.invoke(invokeResult, new Object[0])) instanceof Status)) break block6;
                status = (Status)statusResult;
            }
            catch (Exception e) {
                throw new ActuatorReflectException(e);
            }
            if (status == null) {
                FlowCtrlFilter.$$$reportNull$$$0(0);
            }
            return status;
        }
        throw new ActuatorReflectException("\u672a\u77e5\u7684 Status \u7c7b\u578b");
    }

    private void closeContext(int timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (Exception ex) {
            Thread.currentThread().interrupt();
        }
        this.context.close();
    }

    public void destroy() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.context = (ConfigurableApplicationContext)applicationContext;
        }
    }

    public void setBeforeOfflineRunnable(Runnable beforeOfflineRunnable) {
        this.beforeOfflineRunnable = beforeOfflineRunnable;
    }

    public void setBeforeOnlineRunnable(Runnable beforeOnlineRunnable) {
        this.beforeOnlineRunnable = beforeOnlineRunnable;
    }

    public void setBeforeStopRunnable(Runnable beforeStopRunnable) {
        this.beforeStopRunnable = beforeStopRunnable;
    }

    static {
        LOCAL_ADDR.add("0:0:0:0:0:0:0:1");
        LOCAL_ADDR.add("127.0.0.1");
        LOCAL_ADDR.add("localhost");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/xforceplus/taxware/architecture/g1/domain/spring/filter/flow/FlowCtrlFilter", "getHealthStatus"));
    }
}

