/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.domain.spring.rmq;

import com.xforceplus.taxware.architecture.g1.domain.exception.TXWR000001Exception;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogSender;
import com.xforceplus.taxware.architecture.g1.domain.model.CloudEnum;
import com.xforceplus.taxware.architecture.g1.domain.spring.annotation.SpringRmqConsumer;
import com.xforceplus.taxware.architecture.g1.domain.spring.annotation.SpringRmqProducer;
import com.xforceplus.taxware.architecture.g1.domain.spring.rmq.TaxwareRmqProperty;
import com.xforceplus.taxware.architecture.g1.domain.util.ApplicationUtil;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.RmqConsumer;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.RmqMessageListenerConcurrently;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.RmqProducer;
import com.xforceplus.taxware.architecture.g1.rocketmq.client.RmqSender;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringRmqInitializer
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringRmqInitializer.class);
    private static final Map<String, RmqConsumer> rmqConsumers = new ConcurrentHashMap<String, RmqConsumer>();
    private static final Map<String, RmqProducer> rmqProducers = new ConcurrentHashMap<String, RmqProducer>();
    private final TaxwareRmqProperty taxwareRmqProperty;
    private ApplicationContext applicationContext;
    @Value(value="${elk.indexName:}")
    private String indexName;

    @Autowired
    public SpringRmqInitializer(TaxwareRmqProperty taxwareRmqProperty) {
        this.taxwareRmqProperty = taxwareRmqProperty;
    }

    public Object postProcessBeforeInitialization(Object o, String s) throws BeansException {
        return o;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        SpringRmqProducer rmqProducerAnnotation;
        SpringRmqConsumer rmqConsumerAnnotation = bean.getClass().getAnnotation(SpringRmqConsumer.class);
        if (rmqConsumerAnnotation != null) {
            this.processRmqConsumer(bean, beanName, rmqConsumerAnnotation);
        }
        if ((rmqProducerAnnotation = bean.getClass().getAnnotation(SpringRmqProducer.class)) != null) {
            this.processRmqProducer(bean, beanName, rmqProducerAnnotation);
        }
        return bean;
    }

    private void processRmqConsumer(Object bean, String beanName, SpringRmqConsumer rmqConsumerAnnotation) {
        if (!(bean instanceof RmqMessageListenerConcurrently)) {
            throw new TXWR000001Exception(String.format("%s \u5fc5\u987b\u5b9e\u73b0 RmqMessageListenerConcurrently \u63a5\u53e3!", beanName));
        }
        RmqMessageListenerConcurrently rmqListener = (RmqMessageListenerConcurrently)bean;
        String sqsEnv = ApplicationUtil.getSqsEnv();
        String cloud = ApplicationUtil.getCloud() == CloudEnum.ALIYUN_CLOUD ? "" : "-" + ApplicationUtil.getCloud().toCode();
        String topicName = String.format("%s%s-%s", sqsEnv, cloud, rmqConsumerAnnotation.topicName());
        String theIndexName = (String)StringUtils.defaultIfBlank((CharSequence)rmqConsumerAnnotation.elkIndexName(), (CharSequence)StringUtils.defaultIfBlank((CharSequence)this.indexName, null));
        String groupName = String.format("%s%s-%s", sqsEnv, cloud, rmqConsumerAnnotation.groupName());
        RmqConsumer rmqConsumer = new RmqConsumer(groupName, this.taxwareRmqProperty.getAccessKey(), this.taxwareRmqProperty.getSecretKey());
        rmqConsumer.setNameSrvAddr(this.taxwareRmqProperty.getNameservers());
        rmqConsumer.subscribe(topicName, rmqConsumerAnnotation.subExpress());
        rmqConsumer.setConsumeThreadMin(rmqConsumerAnnotation.consumeThreadMin());
        rmqConsumer.setConsumeThreadMax(rmqConsumerAnnotation.consumeThreadMax());
        rmqConsumer.setMaxReconsumeTimes(rmqConsumerAnnotation.maxReconsumeTimes());
        rmqConsumer.setConsumeMessageBatchMaxSize(rmqConsumerAnnotation.consumeMessageBatchMaxSize());
        rmqConsumer.setPullBatchSize(rmqConsumerAnnotation.pullBatchSize());
        rmqConsumer.setIndexName(theIndexName);
        rmqConsumer.setLogSender(StringUtils.isNotBlank((CharSequence)rmqConsumerAnnotation.logSenderName()) ? (LogSender)this.applicationContext.getBean(rmqConsumerAnnotation.logSenderName()) : null);
        rmqConsumer.registerMessageListener(rmqListener);
        rmqConsumer.start();
        log.info(String.format("RmqConsumer \u542f\u52a8\u6210\u529f: [%s][group:%s][topic:%s,%s][threads:%d-%d][maxReconsume:%d][index:%s]", beanName, groupName, topicName, rmqConsumerAnnotation.subExpress(), rmqConsumerAnnotation.consumeThreadMin(), rmqConsumerAnnotation.consumeThreadMax(), rmqConsumerAnnotation.maxReconsumeTimes(), theIndexName));
        rmqConsumers.put(beanName, rmqConsumer);
    }

    private void processRmqProducer(Object bean, String beanName, SpringRmqProducer rmqProducerAnnotation) {
        if (!(bean instanceof RmqProducer)) {
            throw new TXWR000001Exception(String.format("%s \u5fc5\u987b\u7ee7\u627f RmqProducer \u7c7b!", beanName));
        }
        RmqProducer rmqProducer = (RmqProducer)bean;
        String sqsEnv = ApplicationUtil.getSqsEnv();
        String cloud = ApplicationUtil.getCloud() == CloudEnum.ALIYUN_CLOUD ? "" : "-" + ApplicationUtil.getCloud().toCode();
        String theIndexName = (String)StringUtils.defaultIfBlank((CharSequence)rmqProducerAnnotation.elkIndexName(), (CharSequence)StringUtils.defaultIfBlank((CharSequence)this.indexName, null));
        String groupName = String.format("%s%s-%s", sqsEnv, cloud, rmqProducerAnnotation.groupName());
        AclClientRPCHook aclClientRPCHook = new AclClientRPCHook(new SessionCredentials(this.taxwareRmqProperty.getAccessKey(), this.taxwareRmqProperty.getSecretKey()));
        rmqProducer.setDefaultMQProducer(this.createDefaultMQProducer(groupName, aclClientRPCHook));
        rmqProducer.setNameSrvAddr(this.taxwareRmqProperty.getNameservers());
        rmqProducer.setIndexName(theIndexName);
        rmqProducer.setLogSender(StringUtils.isNotBlank((CharSequence)rmqProducerAnnotation.logSenderName()) ? (LogSender)this.applicationContext.getBean(rmqProducerAnnotation.logSenderName()) : null);
        rmqProducer.setRmqSender(StringUtils.isNotBlank((CharSequence)rmqProducerAnnotation.rmqSenderName()) ? (RmqSender)this.applicationContext.getBean(rmqProducerAnnotation.rmqSenderName()) : null);
        rmqProducer.start();
        log.info(String.format("RmqProducer \u542f\u52a8\u6210\u529f: [%s][group:%s][index:%s]", beanName, groupName, theIndexName));
        rmqProducers.put(beanName, rmqProducer);
    }

    private DefaultMQProducer createDefaultMQProducer(String groupName, AclClientRPCHook aclClientRPCHook) {
        DefaultMQProducer defaultMQProducer = new DefaultMQProducer(groupName, (RPCHook)aclClientRPCHook);
        defaultMQProducer.setMaxMessageSize(0x1800000);
        return defaultMQProducer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

