/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.domain.spring.rmq;

import com.alibaba.fastjson.JSON;
import com.xforceplus.taxware.architecture.g1.domain.spring.annotation.EnableRmq;
import com.xforceplus.taxware.architecture.g1.domain.spring.annotation.SpringRmqConsumer;
import com.xforceplus.taxware.architecture.g1.domain.spring.annotation.SpringRmqProducer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class SpringRmqRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(SpringRmqRegistrar.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        log.info("Rmq\u81ea\u52a8\u6ce8\u518c\u5f00\u59cb");
        Map enableRmqAttrs = annotationMetadata.getAnnotationAttributes(EnableRmq.class.getCanonicalName());
        String[] basePackages = (String[])enableRmqAttrs.get("basePackages");
        log.info(String.format("EnableRmq BasePackages = %s", JSON.toJSONString((Object)basePackages)));
        ClassPathBeanDefinitionScanner consumerScanner = new ClassPathBeanDefinitionScanner(beanDefinitionRegistry, false, this.environment);
        AnnotationTypeFilter consumerAnnotationTypeFilter = new AnnotationTypeFilter(SpringRmqConsumer.class);
        consumerScanner.addIncludeFilter((TypeFilter)consumerAnnotationTypeFilter);
        consumerScanner.scan(basePackages);
        ClassPathBeanDefinitionScanner producerScanner = new ClassPathBeanDefinitionScanner(beanDefinitionRegistry, false, this.environment);
        AnnotationTypeFilter producerAnnotationTypeFilter = new AnnotationTypeFilter(SpringRmqProducer.class);
        producerScanner.addIncludeFilter((TypeFilter)producerAnnotationTypeFilter);
        producerScanner.scan(basePackages);
    }
}

