/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.elk.listener;

import com.xforceplus.taxware.architecture.g1.domain.listener.HttpClientListener;
import com.xforceplus.taxware.architecture.g1.domain.listener.HttpClientListenerArgument;
import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogEvent;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogSender;
import com.xforceplus.taxware.architecture.g1.domain.log.model.impl.HttpLogEvent;
import com.xforceplus.taxware.architecture.g1.elk.listener.ElkWebFilterListener;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class HttpClientListenerImpl
implements HttpClientListener {
    private final ThreadLocal<HttpLogEvent> session = new ThreadLocal();
    private final LogSender logSender;
    private final String serviceName;
    private ElkWebFilterListener listener;

    public HttpClientListenerImpl(LogSender logSender, String serviceName) {
        this.logSender = logSender;
        this.serviceName = serviceName;
    }

    public void beforeSend(HttpClientListenerArgument argument) {
        HttpLogEvent event = new HttpLogEvent();
        event.setService(this.serviceName);
        event.setType("RPC");
        event.setTraceId(LogContext.getTraceId());
        event.setName(argument.getName());
        event.setMethod(argument.getMethod());
        event.setUrl(argument.getUrl());
        event.setRequestText(argument.getRequestText());
        event.setRequestSize(argument.getRequestSize());
        event.setHeaders(argument.getRequestHeaders());
        event.setUserAgent(argument.getUserAgent());
        event.setSerializeForSendingTimeCost(argument.getSerializeTimeCost());
        event.setToByteForSendingTimeCost(argument.getToByteTimeCost());
        this.session.set(event);
    }

    public void sendComplete(HttpClientListenerArgument argument) {
        HttpLogEvent event = this.session.get();
        if (event == null) {
            return;
        }
        event.setHttpStatus(argument.getResponseStatus());
        event.setResponseHeader(argument.getResponseHeaders());
        event.setResponseSize(argument.getResponseSize());
        event.setResponseText(argument.getResponseText());
        if (!CollectionUtils.isEmpty((Map)argument.getExt())) {
            event.getExt().putAll(argument.getExt());
        }
        this.session.remove();
        if (this.listener != null) {
            this.listener.beforeSend(event);
        }
        if (this.logSender != null) {
            this.logSender.send((LogEvent)event);
        }
    }

    public void sendError(HttpClientListenerArgument argument) {
        HttpLogEvent event = this.session.get();
        if (event == null) {
            return;
        }
        event.setHttpStatus(argument.getResponseStatus());
        event.setResponseHeader(argument.getResponseHeaders());
        event.setResponseSize(argument.getResponseSize());
        event.setResponseText(argument.getResponseText());
        if (!CollectionUtils.isEmpty((Map)argument.getExt())) {
            event.getExt().putAll(argument.getExt());
        }
        event.setThrowable(argument.getThrowable());
        this.session.remove();
        if (this.listener != null) {
            this.listener.beforeSend(event);
        }
        if (this.logSender != null) {
            this.logSender.send((LogEvent)event);
        }
    }

    public void setListener(ElkWebFilterListener listener) {
        this.listener = listener;
    }
}

