/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.elk.model.response.contract.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.taxware.architecture.g1.core.exception.BaseCodeException;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import com.xforceplus.taxware.architecture.g1.elk.model.response.contract.AbstractResponseContract;

public class RestfulResponseContract
extends AbstractResponseContract {
    private final Throwable originalException;

    public RestfulResponseContract(Throwable throwable) {
        this.originalException = this.getOriginalException(throwable);
    }

    @Override
    public int getHttpStatus() {
        if (this.originalException instanceof BaseCodeException) {
            BaseCodeException baseCodeException = (BaseCodeException)this.originalException;
            return baseCodeException.getHttpStatus();
        }
        return 500;
    }

    @Override
    public String getCode() {
        if (this.originalException instanceof BaseCodeException) {
            BaseCodeException baseCodeException = (BaseCodeException)this.originalException;
            return baseCodeException.getErrorCode();
        }
        return "TXWR000001";
    }

    @Override
    public String getMessage() {
        if (this.originalException instanceof BaseCodeException) {
            BaseCodeException baseCodeException = (BaseCodeException)this.originalException;
            return baseCodeException.getMessage();
        }
        return this.getExceptionMessage(this.originalException);
    }

    @Override
    public String getResponseBody() {
        BaseRestfulResponseDTO responseDTO = new BaseRestfulResponseDTO();
        responseDTO.setCode(this.getCode());
        responseDTO.setMessage(this.getMessage());
        responseDTO.setTraceId(LogContext.getTraceId());
        return JSON.toJSONString((Object)responseDTO);
    }
}

