/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.elk.model.webflux;

import com.alibaba.fastjson.JSON;
import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import com.xforceplus.taxware.architecture.g1.domain.log.model.impl.HttpLogEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import reactor.core.publisher.Flux;

public class ElkServerHttpRequest
extends ServerHttpRequestDecorator {
    private static final Logger logger = LoggerFactory.getLogger(ElkServerHttpRequest.class);
    private HttpLogEvent event;

    public ElkServerHttpRequest(ServerHttpRequest request, HttpLogEvent event) {
        super(request);
        this.event = event;
        String name = request.getPath().value();
        LogContext.setName((String)name);
        event.setName(name);
        event.setMethod(Optional.ofNullable(request.getMethod()).map(Enum::name).orElse("unKnown"));
        event.setRemoteIp(Optional.ofNullable(request.getRemoteAddress()).map(InetSocketAddress::getAddress).map(InetAddress::getHostAddress).orElse("unKnown"));
        event.setHeaders(JSON.toJSONString((Object)request.getHeaders()));
        event.setType("Service");
    }

    public Flux<DataBuffer> getBody() {
        MediaType contentType = this.getDelegate().getHeaders().getContentType();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(bos);
        return super.getBody().map(dataBuffer -> {
            try {
                channel.write(dataBuffer.asByteBuffer().asReadOnlyBuffer());
            }
            catch (IOException e) {
                logger.error("Request Map", (Throwable)e);
            }
            return dataBuffer;
        }).doOnComplete(() -> {
            try {
                if (contentType == MediaType.APPLICATION_JSON_UTF8) {
                    this.event.setRequestText(bos.toString("UTF-8"));
                }
                this.event.setRequestSize(bos.size());
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Request Complete", (Throwable)e);
            }
        }).doOnTerminate(() -> {
            try {
                bos.close();
                channel.close();
            }
            catch (IOException e) {
                logger.error("Request Terminate", (Throwable)e);
            }
        }).doOnError(arg_0 -> ((HttpLogEvent)this.event).setThrowable(arg_0));
    }
}

