/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.elk.model.webflux;

import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import com.xforceplus.taxware.architecture.g1.domain.log.model.impl.HttpLogEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ElkServerHttpResponse
extends ServerHttpResponseDecorator {
    private static final Logger logger = LoggerFactory.getLogger(ElkServerHttpResponse.class);
    private HttpLogEvent event;

    public ElkServerHttpResponse(ServerHttpResponse delegate, HttpLogEvent event) {
        super(delegate);
        this.event = event;
    }

    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(bos);
        return super.writeWith((Publisher)Flux.from(body).map(dataBuff -> {
            try {
                channel.write(dataBuff.asByteBuffer().asReadOnlyBuffer());
            }
            catch (IOException e) {
                logger.error("Response WriteWith", (Throwable)e);
            }
            return dataBuff;
        }).doOnComplete(() -> {
            try {
                this.event.setResponseText(bos.toString("UTF-8"));
                this.event.setResponseSize(bos.size());
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Response Complete", (Throwable)e);
            }
        }).doOnTerminate(() -> {
            try {
                this.event.getExt().putAll(LogContext.getAllPoint());
                LogContext.clear();
                bos.close();
                channel.close();
            }
            catch (IOException e) {
                logger.error("Response Terminate", (Throwable)e);
            }
        })).doOnError(arg_0 -> ((HttpLogEvent)this.event).setThrowable(arg_0));
    }
}

