/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.elk.model.webflux;

import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogEvent;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogSender;
import com.xforceplus.taxware.architecture.g1.domain.log.model.impl.HttpLogEvent;
import com.xforceplus.taxware.architecture.g1.elk.model.webflux.ElkServerWebExchange;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ElkWebFilter
implements WebFilter {
    private List<String> pathPatterns;
    private LogSender logSender;
    private String serviceName;

    public ElkWebFilter() {
        this("unknown", new ArrayList<String>(), null);
    }

    public ElkWebFilter(String serviceName, List<String> pathPatterns, LogSender logSender) {
        this.serviceName = serviceName;
        this.pathPatterns = pathPatterns;
        this.logSender = logSender;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getPath().value();
        if (!this.isPathMatched(path)) {
            return chain.filter(exchange);
        }
        LogContext.init();
        HttpLogEvent event = new HttpLogEvent();
        event.setService(this.serviceName);
        event.setTraceId(LogContext.getTraceId());
        ElkServerWebExchange elkServerWebExchange = new ElkServerWebExchange(exchange, event);
        return chain.filter((ServerWebExchange)elkServerWebExchange).doOnEach(s -> event.getExt().putAll(LogContext.getAllPoint())).doOnError(arg_0 -> ((HttpLogEvent)event).setThrowable(arg_0)).doOnTerminate(() -> {
            this.sendLogEvent((LogEvent)event);
            LogContext.clear();
        });
    }

    private void sendLogEvent(LogEvent event) {
        if (this.logSender != null) {
            this.logSender.send(event);
        }
    }

    private boolean isPathMatched(String path) {
        if (this.pathPatterns == null) {
            return false;
        }
        for (String pathPattern : this.pathPatterns) {
            if (!path.matches(pathPattern)) continue;
            return true;
        }
        return false;
    }
}

