/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.elk.model.webmvc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class ElkHttpServletRequest
extends HttpServletRequestWrapper {
    private final ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();

    public ElkHttpServletRequest(HttpServletRequest request) {
        super(request);
        try {
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)this.bodyStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bodyStream.toByteArray());
        return new ServletInputStream(){

            public boolean isFinished() {
                return byteArrayInputStream.available() == 0;
            }

            public boolean isReady() {
                return byteArrayInputStream.available() > 0;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
    }

    public Map<String, String> getHeaderMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headName = (String)headerNames.nextElement();
            result.put(headName, this.getHeader(headName));
        }
        return result;
    }

    public String getBody() {
        try {
            return new String(this.bodyStream.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "UTF8\u7f16\u7801\u5f02\u5e38\uff0c\u5bf9\u5e94\u7684Base64:" + Base64.encodeBase64String((byte[])this.bodyStream.toByteArray());
        }
    }

    public int getBodySize() {
        return this.bodyStream.size();
    }
}

