/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.elk.model.webmvc;

import com.alibaba.fastjson.JSON;
import com.xforceplus.taxware.architecture.g1.domain.log.LogContext;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogEvent;
import com.xforceplus.taxware.architecture.g1.domain.log.model.LogSender;
import com.xforceplus.taxware.architecture.g1.domain.log.model.impl.HttpLogEvent;
import com.xforceplus.taxware.architecture.g1.domain.util.ApplicationUtil;
import com.xforceplus.taxware.architecture.g1.elk.listener.ElkWebFilterListener;
import com.xforceplus.taxware.architecture.g1.elk.model.response.contract.ResponseContract;
import com.xforceplus.taxware.architecture.g1.elk.model.response.contract.ResponseContractFactory;
import com.xforceplus.taxware.architecture.g1.elk.model.response.contract.ResponseContractModeEnum;
import com.xforceplus.taxware.architecture.g1.elk.model.webmvc.ElkHttpServletRequest;
import com.xforceplus.taxware.architecture.g1.elk.model.webmvc.ElkHttpServletResponse;
import com.xforceplus.taxware.architecture.g1.elk.oss.OssSender;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ElkWebFilter
implements Filter {
    private final LogSender logSender;
    private final String serviceName;
    private final Pattern pattern;
    private Pattern responseWhitePattern;
    private Pattern restfulPattern;
    private Pattern phoenixPattern;
    private ElkWebFilterListener listener;
    private OssSender ossSender;

    public ElkWebFilter(LogSender logSender, String serviceName, String pattern) {
        this.logSender = logSender;
        this.serviceName = serviceName;
        this.pattern = Pattern.compile(pattern);
    }

    public ElkWebFilter(LogSender logSender, String serviceName) {
        this(logSender, serviceName, ".*");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void setResponseWhitePattern(String pattern) {
        this.responseWhitePattern = Pattern.compile(pattern);
    }

    public void setRestfulPattern(String pattern) {
        this.restfulPattern = Pattern.compile(pattern);
    }

    public void setPhoenixPattern(String pattern) {
        this.phoenixPattern = Pattern.compile(pattern);
    }

    public void setListener(ElkWebFilterListener listener) {
        this.listener = listener;
    }

    public void setOssSender(OssSender ossSender) {
        this.ossSender = ossSender;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String uri = ((HttpServletRequest)servletRequest).getRequestURI();
        if (!this.isMatch(uri)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        ElkHttpServletRequest request = new ElkHttpServletRequest((HttpServletRequest)servletRequest);
        ElkHttpServletResponse response = new ElkHttpServletResponse((HttpServletResponse)servletResponse);
        this.doActualFilter(filterChain, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doActualFilter(FilterChain filterChain, ElkHttpServletRequest request, ElkHttpServletResponse response) {
        String fromSystem;
        LogContext.init();
        String uri = request.getRequestURI();
        if (request.getHeader("X-Trace-Id") != null) {
            LogContext.setTraceId((String)request.getHeader("X-Trace-Id"));
        }
        if (StringUtils.isNotBlank((CharSequence)(fromSystem = ApplicationUtil.getFromSystem()))) {
            LogContext.setLogPoint((String)"fromSystem", (Object)fromSystem);
        }
        HttpLogEvent event = new HttpLogEvent();
        event.setHeaders(JSON.toJSONString(request.getHeaderMap()));
        event.setRequestText(request.getBody());
        event.setRequestSize(request.getBodySize());
        event.setMethod(request.getMethod());
        event.setName(request.getRequestURI());
        event.setRemoteIp(request.getRemoteHost());
        event.setUrl(this.getFullUrl(request));
        event.setUserAgent(request.getHeader("user-agent"));
        event.setService(this.serviceName);
        event.setType("Service");
        event.setTraceId(LogContext.getTraceId());
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable ex) {
            event.setThrowable(ex);
            this.writeErrorResponse((HttpServletResponse)response, ex, this.calcResponseContractMode(uri));
        }
        finally {
            event.setExt(LogContext.getAllPoint());
            event.setResponseText(response.getBody());
            event.setResponseSize(response.getBodySize());
            this.preventLargeLog(event, uri);
            if (this.listener != null) {
                this.listener.beforeSend(event);
            }
            this.logSender.send((LogEvent)event);
            LogContext.clear();
        }
    }

    private ResponseContractModeEnum calcResponseContractMode(String uri) {
        if (this.isMatchRestfulPattern(uri)) {
            return ResponseContractModeEnum.RESTFUL;
        }
        if (this.isMatchPhoenixPattern(uri)) {
            return ResponseContractModeEnum.PHOENIX_V1;
        }
        return ResponseContractModeEnum.TAXWARE_V1;
    }

    private String getFullUrl(ElkHttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (requestURL == null) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            return String.format("%s?%s", requestURL, queryString);
        }
        return requestURL.toString();
    }

    private void preventLargeLog(@NotNull HttpLogEvent event, String uri) {
        if (event == null) {
            ElkWebFilter.$$$reportNull$$$0(0);
        }
        int sizeLimit = 985000;
        if (event.getRequestSize() + event.getResponseSize() <= 985000) {
            return;
        }
        if (event.getRequestSize() <= 985000) {
            if (this.ossSender != null) {
                event.setResponseTextUrl(this.ossSender.send(event.getResponseText()));
            }
            event.setResponseText(null);
        } else if (event.getResponseSize() <= 985000) {
            if (this.ossSender != null) {
                event.setRequestTextUrl(this.ossSender.send(event.getRequestText()));
            }
            event.setRequestText(null);
        } else {
            if (this.ossSender != null) {
                event.setRequestTextUrl(this.ossSender.send(event.getRequestText()));
                event.setResponseTextUrl(this.ossSender.send(event.getResponseText()));
            }
            event.setRequestText(null);
            event.setResponseText(null);
        }
        if (!this.isMatchResponseWhitePattern(uri) && event.getResponseText() != null) {
            if (this.ossSender != null) {
                event.setResponseTextUrl(this.ossSender.send(event.getResponseText()));
            }
            event.setResponseText(null);
        }
    }

    private boolean isMatch(String uri) {
        return this.pattern.matcher(uri).matches();
    }

    private boolean isMatchResponseWhitePattern(String uri) {
        if (this.responseWhitePattern == null) {
            return true;
        }
        return this.responseWhitePattern.matcher(uri).matches();
    }

    private boolean isMatchRestfulPattern(String uri) {
        if (this.restfulPattern == null) {
            return false;
        }
        return this.restfulPattern.matcher(uri).matches();
    }

    private boolean isMatchPhoenixPattern(String uri) {
        if (this.phoenixPattern == null) {
            return false;
        }
        return this.phoenixPattern.matcher(uri).matches();
    }

    public void destroy() {
    }

    private void writeErrorResponse(HttpServletResponse response, Throwable throwable, ResponseContractModeEnum responseContractMode) {
        try {
            ResponseContract responseContract = ResponseContractFactory.create(responseContractMode, throwable);
            LogContext.setLogPoint((String)"httpStatus", (Object)responseContract.getHttpStatus());
            LogContext.setLogPoint((String)"code", (Object)responseContract.getCode());
            LogContext.setLogPoint((String)"message", (Object)responseContract.getMessage());
            response.setHeader("Content-Type", "application/json; charset=UTF-8");
            response.setStatus(responseContract.getHttpStatus());
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(responseContract.getResponseBody().getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("G1: WriteErrorResponse Exception!", throwable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/xforceplus/taxware/architecture/g1/elk/model/webmvc/ElkWebFilter", "preventLargeLog"));
    }
}

