/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.elk.oss;

import com.alibaba.ttl.TtlRunnable;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.xforceplus.taxware.architecture.g1.domain.util.ApplicationUtil;
import com.xforceplus.taxware.architecture.g1.domain.util.IDUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class OssSender {
    private static final Logger log = LoggerFactory.getLogger(OssSender.class);
    private static final String INTERNAL_END_POINT = "oss-cn-hangzhou-internal.aliyuncs.com";
    private static final String END_POINT = "oss-cn-hangzhou.aliyuncs.com";
    private static final String BUCKET = "taxware-sl";
    private static final String AK = "LTAI4FeeXQDaWemFioYP6ZGL";
    private static final String SK = "72oAyMQdpFclRDAF7NkIP45RRimpPZ";
    private static AtomicInteger seqNo = new AtomicInteger(0);
    private final BlockingQueue<OssFile> queue;
    private final OSSClient ossClient;

    public OssSender() {
        this(1000, 2, null);
    }

    public OssSender(int queueSize, int threadSize, String endpoint) {
        this.queue = new LinkedBlockingDeque<OssFile>(queueSize);
        DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(AK, SK);
        this.ossClient = new OSSClient(this.getEndpoint(endpoint), (CredentialsProvider)credentialsProvider, new ClientConfiguration());
        for (int i = 0; i < threadSize; ++i) {
            this.addThread("OssSender-" + seqNo.addAndGet(1));
        }
    }

    @NotNull
    private String getEndpoint(String endpoint) {
        if ("dev".equals(ApplicationUtil.getEnv())) {
            String string = Optional.ofNullable(endpoint).orElse(END_POINT);
            if (string == null) {
                OssSender.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = Optional.ofNullable(endpoint).orElse(INTERNAL_END_POINT);
        if (string == null) {
            OssSender.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String send(String data, MediaType mediaType) {
        String key = String.format("elk/%s/%s/%s.%s", ApplicationUtil.getEnv(), DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"), IDUtil.genUUID32(), mediaType.getSubtype());
        String url = String.format("https://taxware-sl.oss-cn-hangzhou.aliyuncs.com/%s", key);
        OssFile ossFile = new OssFile();
        ossFile.setKey(key);
        ossFile.setContent(data);
        ossFile.setMediaType(mediaType);
        this.queue.offer(ossFile);
        return url;
    }

    public String send(String data) {
        return this.send(data, MediaType.APPLICATION_JSON_UTF8);
    }

    private void addThread(String threadName) {
        Thread thread = new Thread((Runnable)TtlRunnable.get(() -> {
            while (true) {
                try {
                    while (true) {
                        OssFile file = this.queue.take();
                        ObjectMetadata objectMetadata = new ObjectMetadata();
                        objectMetadata.setContentType("application/json");
                        PutObjectRequest putObjectRequest = new PutObjectRequest(BUCKET, file.getKey(), (InputStream)new ByteArrayInputStream(file.getContent().getBytes(StandardCharsets.UTF_8)), objectMetadata);
                        this.ossClient.putObject(putObjectRequest);
                    }
                }
                catch (Exception e) {
                    log.error("\u8bb0\u5f55ELK\u62a5\u6587\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                break;
            }
        }));
        thread.setName(threadName);
        thread.start();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/xforceplus/taxware/architecture/g1/elk/oss/OssSender", "getEndpoint"));
    }

    private class OssFile {
        private String key;
        private String content;
        private MediaType mediaType;

        public String getKey() {
            return this.key;
        }

        public String getContent() {
            return this.content;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setMediaType(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OssFile)) {
                return false;
            }
            OssFile other = (OssFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            MediaType this$mediaType = this.getMediaType();
            MediaType other$mediaType = other.getMediaType();
            return !(this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OssFile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            MediaType $mediaType = this.getMediaType();
            result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
            return result;
        }

        public String toString() {
            return "OssSender.OssFile(key=" + this.getKey() + ", content=" + this.getContent() + ", mediaType=" + this.getMediaType() + ")";
        }
    }
}

