/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.endecode;

import com.xforceplus.taxware.architecture.g1.endecode.exception.EcdsaSignException;
import com.xforceplus.taxware.architecture.g1.endecode.exception.EcdsaVerifyException;
import com.xforceplus.taxware.architecture.g1.endecode.exception.KeyPairException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class EcdsaUtil {
    public static final String SHA256withECDSA = "SHA256withECDSA";
    private static final String ALGORITHM = "EC";

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(ALGORITHM);
            ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256k1");
            generator.initialize(ecGenParameterSpec, new SecureRandom());
            generator.initialize(256);
            return generator.generateKeyPair();
        }
        catch (Exception e) {
            throw KeyPairException.create("\u5bc6\u94a5\u5bf9\u751f\u6210\u5931\u8d25", e);
        }
    }

    public static byte[] sign(byte[] data, byte[] privateKey, String signAlgorithm) {
        try {
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initSign(priKey);
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw EcdsaSignException.create("Ecdsa\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] sign, String signAlgorithm) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PublicKey pubKey = keyFactory.generatePublic(keySpec);
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initVerify(pubKey);
            signature.update(data);
            return signature.verify(sign);
        }
        catch (Exception e) {
            throw EcdsaVerifyException.create("Ecdsa\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }
}

