/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.architecture.g1.endecode;

import com.xforceplus.taxware.architecture.g1.endecode.exception.CreateZipBytesException;
import com.xforceplus.taxware.architecture.g1.endecode.model.ZipEntry;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;

public class ZipUtil {
    public static byte[] createZipBytes(ZipEntry ... zipEntries) {
        if (zipEntries == null || zipEntries.length == 0) {
            throw new CreateZipBytesException("\u53c2\u6570 zipEntries \u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        ZipParameters zipParameters = new ZipParameters();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)resultStream);){
            for (ZipEntry entry : zipEntries) {
                zipParameters.setFileNameInZip(entry.getName());
                zipOutputStream.putNextEntry(zipParameters);
                zipOutputStream.write(entry.getData());
                zipOutputStream.closeEntry();
            }
        }
        catch (Exception ex) {
            throw new CreateZipBytesException("\u521b\u5efaZip\u5b57\u8282\u7ec4\u65f6\u53d1\u751f\u5f02\u5e38\uff01" + Optional.ofNullable(ex.getMessage()).orElse(ex.getClass().getName()), ex);
        }
        return resultStream.toByteArray();
    }
}

